/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.Serializer;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.StringFactory;
import org.modeshape.jcr.value.UriFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

public class MapDB {
    protected static final Serializer<?> DEFAULT_SERIALIZER = Serializer.BASIC;
    protected static final BTreeKeySerializer<?> DEFAULT_BTREE_KEY_SERIALIZER = BTreeKeySerializer.BASIC;

    public static Serializers serializers(ValueFactories factories) {
        return new SerializerSupplier(factories);
    }

    public static <T> BTreeKeySerializer<UniqueKey<T>> uniqueKeySerializer(Serializer<T> serializer, Comparator<T> comparator) {
        return new UniqueKeySerializer<T>(serializer, MapDB.uniqueKeyComparator(comparator));
    }

    public static <T> Comparator<UniqueKey<T>> uniqueKeyComparator(Comparator<T> comparator) {
        return new UniqueKeyComparator<T>(comparator);
    }

    private MapDB() {
    }

    public static class ValueSerializer<V>
    implements Serializer<V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient ValueFactory<V> valueFactory;
        private final transient StringFactory stringFactory;

        public ValueSerializer(StringFactory stringFactory, ValueFactory<V> valueFactory) {
            this.valueFactory = valueFactory;
            this.stringFactory = stringFactory;
        }

        public int fixedSize() {
            return -1;
        }

        public void serialize(DataOutput out, V value) throws IOException {
            out.writeUTF((String)this.stringFactory.create(value));
        }

        public V deserialize(DataInput in, int available) throws IOException {
            String pathStr = in.readUTF();
            return this.valueFactory.create(pathStr);
        }

        public String toString() {
            return "ValueSerializer<" + (Object)((Object)this.valueFactory.getPropertyType()) + ">";
        }
    }

    public static class DoubleSerializer
    implements Serializer<Double>,
    Serializable {
        private static final long serialVersionUID = 1L;

        public void serialize(DataOutput out, Double value) throws IOException {
            out.writeDouble(value);
        }

        public Double deserialize(DataInput in, int available) throws IOException {
            if (available == 0) {
                return null;
            }
            return in.readDouble();
        }

        public int fixedSize() {
            return -1;
        }
    }

    public static class PackedStringKeySerializer<K extends Comparable<K>>
    extends BTreeKeySerializer<K>
    implements Serializable,
    KeySerializerWithComparator<K> {
        private static final long serialVersionUID = 1L;
        private static final Charset UTF8_CHARSET = Charset.forName("UTF8");
        private final transient ValueFactory<K> valueFactory;
        private final transient StringFactory stringFactory;
        protected final transient Comparator<K> comparator;

        public PackedStringKeySerializer(StringFactory stringFactory, ValueFactory<K> valueFactory) {
            this(stringFactory, valueFactory, null);
        }

        protected PackedStringKeySerializer(StringFactory stringFactory, ValueFactory<K> valueFactory, Comparator<K> comparator) {
            this.valueFactory = valueFactory;
            this.stringFactory = stringFactory;
            this.comparator = comparator != null ? comparator : new Comparator<K>(){

                @Override
                public int compare(K o1, K o2) {
                    return o1.compareTo(o2);
                }
            };
        }

        @Override
        public BTreeKeySerializer<K> withComparator(Comparator<?> comparator) {
            if (comparator == null) {
                return this;
            }
            return new PackedStringKeySerializer<K>(this.stringFactory, this.valueFactory, comparator);
        }

        public Comparator<K> getComparator() {
            return this.comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                String key = (String)this.stringFactory.create(keys[i]);
                byte[] b = key.getBytes(UTF8_CHARSET);
                PackedStringKeySerializer.leadingValuePackWrite((DataOutput)out, (byte[])b, previous, (int)0);
                previous = b;
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            byte[] previous = null;
            for (int i = start; i < end; ++i) {
                byte[] b = PackedStringKeySerializer.leadingValuePackRead((DataInput)in, previous, (int)0);
                if (b == null) continue;
                String str = new String(b, UTF8_CHARSET);
                ret[i] = this.valueFactory.create(str);
                previous = b;
            }
            return ret;
        }

        public String toString() {
            return "ValueSerializer<" + (Object)((Object)this.valueFactory.getPropertyType()) + ">";
        }
    }

    public static interface KeySerializerWithComparator<K> {
        public BTreeKeySerializer<K> withComparator(Comparator<?> var1);
    }

    public static final class DelegatingKeySerializer<K extends Comparable<K>>
    extends BTreeKeySerializer<K>
    implements Serializable,
    KeySerializerWithComparator<K> {
        private static final long serialVersionUID = 1L;
        protected final transient Serializer<K> defaultSerializer;
        protected final transient Comparator<K> comparator;

        public DelegatingKeySerializer(Serializer<K> defaultSerializer) {
            this(defaultSerializer, null);
        }

        public DelegatingKeySerializer(Serializer<K> defaultSerializer, Comparator<K> comparator) {
            this.defaultSerializer = defaultSerializer;
            this.comparator = comparator != null ? comparator : new NaturalComparator();
        }

        public Comparator<K> getComparator() {
            return this.comparator;
        }

        @Override
        public BTreeKeySerializer<K> withComparator(Comparator<?> comparator) {
            if (comparator == null) {
                return this;
            }
            return new DelegatingKeySerializer<K>(this.defaultSerializer, comparator);
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                this.defaultSerializer.serialize(out, (Object)((Comparable)keys[i]));
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                ret[i] = this.defaultSerializer.deserialize(in, -1);
            }
            return ret;
        }

        public String toString() {
            return "DelegatingBTreeSerializer<" + this.defaultSerializer + ">";
        }
    }

    public static class NaturalComparator<K extends Comparable<K>>
    implements Comparator<K>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(K o1, K o2) {
            return o1.compareTo(o2);
        }
    }

    public static final class UniqueKeySerializer<K>
    extends BTreeKeySerializer<UniqueKey<K>>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected final transient Serializer<K> keySerializer;
        protected final transient Comparator<UniqueKey<K>> comparator;

        public UniqueKeySerializer(Serializer<K> keySerializer, Comparator<UniqueKey<K>> comparator) {
            this.keySerializer = keySerializer;
            this.comparator = comparator;
        }

        public Comparator<UniqueKey<K>> getComparator() {
            return this.comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            for (int i = start; i < end; ++i) {
                UniqueKey key = (UniqueKey)keys[i];
                this.keySerializer.serialize(out, key.actualKey);
                out.writeLong(key.id);
            }
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            Object[] ret = new Object[size];
            for (int i = start; i < end; ++i) {
                Object key = this.keySerializer.deserialize(in, -1);
                long id = in.readLong();
                ret[i] = new UniqueKey<Object>(key, id);
            }
            return ret;
        }

        public String toString() {
            return "UniqueKeySerializer<" + this.keySerializer + ">";
        }
    }

    public static final class ComparableUniqueKeyComparator<K>
    implements Comparator<UniqueKey<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(UniqueKey<K> o1, UniqueKey<K> o2) {
            if (o1 == o2) {
                return 0;
            }
            int diff = ObjectUtil.compareWithNulls((Comparable)((Comparable)o1.actualKey), (Comparable)((Comparable)o2.actualKey));
            if (diff != 0) {
                return diff;
            }
            long ldiff = o1.id - o2.id;
            return ldiff == 0L ? 0 : (ldiff <= 0L ? -1 : 1);
        }
    }

    public static final class UniqueKeyComparator<K>
    implements Comparator<UniqueKey<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient Comparator<K> valueComparator;

        public UniqueKeyComparator(Comparator<K> valueComparator) {
            this.valueComparator = valueComparator;
        }

        @Override
        public int compare(UniqueKey<K> o1, UniqueKey<K> o2) {
            if (o1 == o2) {
                return 0;
            }
            int diff = this.valueComparator.compare(o1.actualKey, o2.actualKey);
            if (diff != 0) {
                return diff;
            }
            long ldiff = o1.id - o2.id;
            return ldiff == 0L ? 0 : (ldiff <= 0L ? -1 : 1);
        }
    }

    public static final class UniqueKey<K> {
        protected final K actualKey;
        protected final long id;
        private final int hc;

        public UniqueKey(K actualKey, long id) {
            this.actualKey = actualKey;
            this.id = id;
            this.hc = actualKey != null ? actualKey.hashCode() : 0;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof UniqueKey) {
                UniqueKey that = (UniqueKey)obj;
                if (this.actualKey == null && that.actualKey != null) {
                    return false;
                }
                if (!this.actualKey.equals(that.actualKey)) {
                    return false;
                }
                return this.id == that.id;
            }
            return false;
        }

        public String toString() {
            return "[" + this.actualKey + "," + this.id + "]";
        }
    }

    private static class BTreeKeySerializerWitheComparator<T>
    extends BTreeKeySerializer<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final BTreeKeySerializer<?> original;
        private final Comparator<T> comparator;

        protected BTreeKeySerializerWitheComparator(BTreeKeySerializer<?> original, Comparator<T> comparator) {
            this.original = original;
            this.comparator = comparator;
        }

        public Object[] deserialize(DataInput in, int start, int end, int size) throws IOException {
            return this.original.deserialize(in, start, end, size);
        }

        public Comparator<T> getComparator() {
            return this.comparator;
        }

        public void serialize(DataOutput out, int start, int end, Object[] keys) throws IOException {
            this.original.serialize(out, start, end, keys);
        }
    }

    public static final class SerializerSupplier
    implements Serializers {
        private final Map<Class<?>, Serializer<?>> serializersByClass;
        private final Map<Class<?>, BTreeKeySerializer<?>> bTreeKeySerializersByClass;
        private final Map<Class<?>, BTreeKeySerializer<?>> packedBTreeKeySerializersByClass;

        protected SerializerSupplier(ValueFactories factories) {
            PathFactory pathFactory = factories.getPathFactory();
            NameFactory nameFactory = factories.getNameFactory();
            StringFactory stringFactory = factories.getStringFactory();
            ReferenceFactory refFactory = factories.getReferenceFactory();
            UriFactory uriFactory = factories.getUriFactory();
            DateTimeFactory dateFactory = factories.getDateFactory();
            ValueFactory<BigDecimal> decimalFactory = factories.getDecimalFactory();
            this.serializersByClass = new HashMap();
            this.serializersByClass.put(String.class, Serializer.STRING);
            this.serializersByClass.put(Long.class, Serializer.LONG);
            this.serializersByClass.put(Boolean.class, Serializer.BOOLEAN);
            this.serializersByClass.put(Double.class, new DoubleSerializer());
            this.serializersByClass.put(BigDecimal.class, new ValueSerializer<BigDecimal>(stringFactory, decimalFactory));
            this.serializersByClass.put(URI.class, new ValueSerializer<URI>(stringFactory, uriFactory));
            this.serializersByClass.put(DateTime.class, new ValueSerializer<DateTime>(stringFactory, dateFactory));
            this.serializersByClass.put(Path.class, new ValueSerializer<Path>(stringFactory, pathFactory));
            this.serializersByClass.put(Name.class, new ValueSerializer<Name>(stringFactory, nameFactory));
            this.serializersByClass.put(Reference.class, new ValueSerializer<Reference>(stringFactory, refFactory));
            this.serializersByClass.put(NodeKey.class, new Serializer<NodeKey>(){

                public void serialize(DataOutput out, NodeKey value) throws IOException {
                    out.writeUTF(value.toString());
                }

                public NodeKey deserialize(DataInput in, int available) throws IOException {
                    String keyStr = in.readUTF();
                    return new NodeKey(keyStr);
                }

                public int fixedSize() {
                    return -1;
                }
            });
            this.bTreeKeySerializersByClass = new HashMap();
            this.packedBTreeKeySerializersByClass = new HashMap();
            for (Map.Entry<Class<?>, Serializer<?>> entry : this.serializersByClass.entrySet()) {
                Serializer<?> serializer = entry.getValue();
                DelegatingKeySerializer bTreeSerializer = new DelegatingKeySerializer(serializer);
                this.bTreeKeySerializersByClass.put(entry.getKey(), bTreeSerializer);
                this.packedBTreeKeySerializersByClass.put(entry.getKey(), bTreeSerializer);
            }
            this.packedBTreeKeySerializersByClass.put(String.class, new PackedStringKeySerializer<String>(stringFactory, stringFactory));
            this.packedBTreeKeySerializersByClass.put(Name.class, new PackedStringKeySerializer<Name>(stringFactory, nameFactory));
            this.packedBTreeKeySerializersByClass.put(Path.class, new PackedStringKeySerializer<Path>(stringFactory, pathFactory));
            this.packedBTreeKeySerializersByClass.put(Name.class, new PackedStringKeySerializer<Name>(stringFactory, nameFactory));
            this.packedBTreeKeySerializersByClass.put(DateTime.class, new PackedStringKeySerializer<DateTime>(stringFactory, dateFactory));
            this.packedBTreeKeySerializersByClass.put(URI.class, new PackedStringKeySerializer<URI>(stringFactory, uriFactory));
            this.packedBTreeKeySerializersByClass.put(Reference.class, new PackedStringKeySerializer<Reference>(stringFactory, refFactory));
            this.packedBTreeKeySerializersByClass.put(BigDecimal.class, new PackedStringKeySerializer<BigDecimal>(stringFactory, decimalFactory));
        }

        @Override
        public Serializer<?> serializerFor(Class<?> type) {
            Serializer<?> result = this.serializersByClass.get(type);
            if (result != null) {
                return result;
            }
            return DEFAULT_SERIALIZER;
        }

        @Override
        public BTreeKeySerializer<?> bTreeKeySerializerFor(Class<?> type, Comparator<?> comparator, boolean pack) {
            BTreeKeySerializer<?> result;
            Map<Class<?>, BTreeKeySerializer<?>> byClass = pack ? this.packedBTreeKeySerializersByClass : this.bTreeKeySerializersByClass;
            BTreeKeySerializer<?> bTreeKeySerializer = result = byClass.containsKey(type) ? byClass.get(type) : DEFAULT_BTREE_KEY_SERIALIZER;
            if (result instanceof KeySerializerWithComparator) {
                KeySerializerWithComparator serializer = (KeySerializerWithComparator)result;
                assert (comparator != null);
                return serializer.withComparator(comparator);
            }
            return this.bTreeKeySerializerWith(result, comparator);
        }

        private <T> BTreeKeySerializer<T> bTreeKeySerializerWith(BTreeKeySerializer<?> original, Comparator<T> comparator) {
            return new BTreeKeySerializerWitheComparator<T>(original, comparator);
        }
    }

    public static interface Serializers {
        public Serializer<?> serializerFor(Class<?> var1);

        public BTreeKeySerializer<?> bTreeKeySerializerFor(Class<?> var1, Comparator<?> var2, boolean var3);
    }
}

