/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.api.query.qom.Limit;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;

@NotThreadSafe
public abstract class NodeSequence {
    protected static final Logger LOGGER = Logger.getLogger(NodeSequence.class);
    public static final RowFilter NO_PASS_ROW_FILTER = new RowFilter(){

        @Override
        public boolean isCurrentRowValid(Batch batch) {
            return false;
        }

        public String toString() {
            return "(no-pass-filter)";
        }
    };
    public static final RowFilter PASS_ROW_FILTER = new RowFilter(){

        @Override
        public boolean isCurrentRowValid(Batch batch) {
            return true;
        }

        public String toString() {
            return "(pass-filter)";
        }
    };

    public abstract int width();

    public abstract long getRowCount();

    public abstract boolean isEmpty();

    public abstract Batch nextBatch();

    public abstract void close();

    public static NodeSequence emptySequence(final int width) {
        assert (width >= 0);
        return new NodeSequence(){

            @Override
            public int width() {
                return width;
            }

            @Override
            public Batch nextBatch() {
                return null;
            }

            @Override
            public long getRowCount() {
                return 0L;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public void close() {
            }

            public String toString() {
                return "(empty-sequence width=" + this.width() + ")";
            }
        };
    }

    public static Batch emptyBatch(final String workspaceName, final int width) {
        assert (width > 0);
        return new Batch(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public String getWorkspaceName() {
                return workspaceName;
            }

            @Override
            public int width() {
                return width;
            }

            @Override
            public long rowCount() {
                return 0L;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public void nextRow() {
                throw new NoSuchElementException();
            }

            @Override
            public CachedNode getNode() {
                throw new NoSuchElementException();
            }

            @Override
            public CachedNode getNode(int index) {
                throw new NoSuchElementException();
            }

            @Override
            public float getScore() {
                throw new NoSuchElementException();
            }

            @Override
            public float getScore(int index) {
                throw new NoSuchElementException();
            }

            public String toString() {
                return "(empty-batch width=" + this.width() + ")";
            }
        };
    }

    public static NodeSequence withBatch(final Batch sequence) {
        if (sequence == null) {
            return NodeSequence.emptySequence(1);
        }
        return new NodeSequence(){
            private boolean done = false;

            @Override
            public int width() {
                return sequence.width();
            }

            @Override
            public long getRowCount() {
                return sequence.rowCount();
            }

            @Override
            public boolean isEmpty() {
                return sequence.isEmpty();
            }

            @Override
            public Batch nextBatch() {
                if (this.done) {
                    return null;
                }
                this.done = true;
                return sequence;
            }

            @Override
            public void close() {
            }

            public String toString() {
                return "(sequence-with-batch " + sequence + " )";
            }
        };
    }

    public static NodeSequence withBatches(Collection<Batch> batches, int width) {
        if (batches == null || batches.isEmpty()) {
            return NodeSequence.emptySequence(width);
        }
        if (batches.size() == 1) {
            Batch batch = batches.iterator().next();
            assert (width == batch.width());
            return NodeSequence.withBatch(batch);
        }
        long rowCount = 0L;
        for (Batch batch : batches) {
            long count = batch.rowCount();
            rowCount = count < 0L ? -1L : rowCount + count;
        }
        return NodeSequence.withBatches(batches.iterator(), width, rowCount);
    }

    public static NodeSequence withBatches(final Iterator<Batch> batches, final int width, final long rowCount) {
        assert (rowCount >= -1L);
        if (batches == null) {
            return NodeSequence.emptySequence(width);
        }
        return new NodeSequence(){

            @Override
            public int width() {
                return width;
            }

            @Override
            public long getRowCount() {
                return rowCount;
            }

            @Override
            public boolean isEmpty() {
                return rowCount == 0L;
            }

            @Override
            public Batch nextBatch() {
                return batches.hasNext() ? (Batch)batches.next() : null;
            }

            @Override
            public void close() {
            }

            public String toString() {
                return "(sequence width=" + this.width() + " (iterator<batch>) )";
            }
        };
    }

    public static NodeSequence withNodes(Collection<CachedNode> nodes, float score, String workspaceName) {
        if (nodes == null || nodes.isEmpty()) {
            return NodeSequence.emptySequence(1);
        }
        return NodeSequence.withNodes(nodes.iterator(), nodes.size(), score, workspaceName);
    }

    public static NodeSequence withNodes(Iterator<CachedNode> nodes, long nodeCount, float score, String workspaceName) {
        assert (nodeCount >= -1L);
        if (nodes == null) {
            return NodeSequence.emptySequence(1);
        }
        return NodeSequence.withBatch(NodeSequence.batchOf(nodes, nodeCount, score, workspaceName));
    }

    public static NodeSequence withNode(final CachedNode node, final int width, final float score, final String workspaceName) {
        return new NodeSequence(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public long getRowCount() {
                return 1L;
            }

            @Override
            public int width() {
                return width;
            }

            @Override
            public Batch nextBatch() {
                return new Batch(){
                    private boolean done = false;

                    @Override
                    public String getWorkspaceName() {
                        return workspaceName;
                    }

                    @Override
                    public float getScore() {
                        return score;
                    }

                    @Override
                    public float getScore(int index) {
                        if (index == 0) {
                            return score;
                        }
                        throw new IndexOutOfBoundsException();
                    }

                    @Override
                    public CachedNode getNode(int index) {
                        if (index == 0) {
                            return this.getNode();
                        }
                        throw new IndexOutOfBoundsException();
                    }

                    @Override
                    public CachedNode getNode() {
                        return this.done ? null : node;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.done;
                    }

                    @Override
                    public void nextRow() {
                        this.done = true;
                    }

                    @Override
                    public boolean isEmpty() {
                        return false;
                    }

                    @Override
                    public long rowCount() {
                        return 1L;
                    }

                    @Override
                    public int width() {
                        return width;
                    }
                };
            }

            @Override
            public void close() {
            }
        };
    }

    public static NodeSequence withNodeKeys(Collection<NodeKey> keys, float score, String workspaceName, RepositoryCache repository) {
        if (keys == null || keys.isEmpty()) {
            return NodeSequence.emptySequence(1);
        }
        return NodeSequence.withNodeKeys(keys.iterator(), (long)keys.size(), score, workspaceName, repository);
    }

    public static NodeSequence withNodeKeys(Collection<NodeKey> keys, float score, String workspaceName, NodeCache cache) {
        if (keys == null || keys.isEmpty()) {
            return NodeSequence.emptySequence(1);
        }
        return NodeSequence.withNodeKeys(keys.iterator(), (long)keys.size(), score, workspaceName, cache);
    }

    public static NodeSequence withNodeKeys(Iterator<NodeKey> keys, long keyCount, float score, String workspaceName, RepositoryCache repository) {
        assert (keyCount >= -1L);
        if (keys == null) {
            return NodeSequence.emptySequence(1);
        }
        return NodeSequence.withBatch(NodeSequence.batchOfKeys(keys, keyCount, score, workspaceName, repository));
    }

    public static NodeSequence withNodeKeys(Iterator<NodeKey> keys, long keyCount, float score, String workspaceName, NodeCache cache) {
        assert (keyCount >= -1L);
        if (keys == null) {
            return NodeSequence.emptySequence(1);
        }
        return NodeSequence.withBatch(NodeSequence.batchOfKeys(keys, keyCount, score, workspaceName, cache));
    }

    public static NodeSequence limit(NodeSequence sequence, Limit limitAndOffset) {
        if (sequence == null) {
            return NodeSequence.emptySequence(0);
        }
        if (limitAndOffset != null && !limitAndOffset.isUnlimited()) {
            int limit = limitAndOffset.getRowLimit();
            if (limitAndOffset.isOffset()) {
                sequence = NodeSequence.skip(sequence, limitAndOffset.getOffset());
            }
            if (limit != Integer.MAX_VALUE) {
                sequence = NodeSequence.limit(sequence, limit);
            }
        }
        return sequence;
    }

    public static NodeSequence limit(final NodeSequence sequence, final long maxRows) {
        if (sequence == null) {
            return NodeSequence.emptySequence(0);
        }
        if (maxRows <= 0L) {
            return NodeSequence.emptySequence(sequence.width());
        }
        if (sequence.isEmpty()) {
            return sequence;
        }
        return new NodeSequence(){
            protected long rowsRemaining;
            {
                this.rowsRemaining = maxRows;
            }

            @Override
            public long getRowCount() {
                long count = sequence.getRowCount();
                if (count < 0L) {
                    return -1L;
                }
                return count < maxRows ? count : maxRows;
            }

            @Override
            public int width() {
                return sequence.width();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Batch nextBatch() {
                if (this.rowsRemaining <= 0L) {
                    return null;
                }
                Batch next = sequence.nextBatch();
                if (next == null) {
                    return null;
                }
                long size = next.rowCount();
                boolean sizeKnown = false;
                if (size >= 0L) {
                    sizeKnown = true;
                    if (size <= this.rowsRemaining) {
                        this.rowsRemaining -= size;
                        return next;
                    }
                    assert (size > this.rowsRemaining);
                }
                long limit = this.rowsRemaining;
                this.rowsRemaining = 0L;
                return new LimitBatch(next, limit, sizeKnown);
            }

            @Override
            public void close() {
                sequence.close();
            }

            public String toString() {
                return "(limit " + maxRows + " " + sequence + " )";
            }
        };
    }

    public static NodeSequence skip(final NodeSequence sequence, final int skip) {
        if (sequence == null) {
            return NodeSequence.emptySequence(0);
        }
        if (skip <= 0 || sequence.isEmpty()) {
            return sequence;
        }
        return new NodeSequence(){
            private int rowsToSkip;
            {
                this.rowsToSkip = skip;
            }

            @Override
            public long getRowCount() {
                long count = sequence.getRowCount();
                if (count < (long)skip) {
                    return -1L;
                }
                return count == (long)skip ? 0L : count - (long)skip;
            }

            @Override
            public int width() {
                return sequence.width();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Batch nextBatch() {
                Batch next = sequence.nextBatch();
                while (next != null) {
                    if (this.rowsToSkip <= 0) {
                        return next;
                    }
                    long size = next.rowCount();
                    if (size >= 0L) {
                        if (size == 0L) {
                            next = sequence.nextBatch();
                            continue;
                        }
                        if (size <= (long)this.rowsToSkip) {
                            this.rowsToSkip = (int)((long)this.rowsToSkip - size);
                            next = sequence.nextBatch();
                            continue;
                        }
                        for (int i = 0; i != this.rowsToSkip; ++i) {
                            if (!next.hasNext()) {
                                return null;
                            }
                            next.nextRow();
                            --size;
                        }
                        this.rowsToSkip = 0;
                        return new AlternateSizeBatch(next, size);
                    }
                    while (this.rowsToSkip > 0 && next.hasNext()) {
                        next.nextRow();
                        --this.rowsToSkip;
                    }
                    if (next.hasNext()) {
                        return next;
                    }
                    next = sequence.nextBatch();
                }
                return next;
            }

            @Override
            public void close() {
                sequence.close();
            }

            public String toString() {
                return "(skip " + skip + " " + sequence + " )";
            }
        };
    }

    public static NodeSequence filter(final NodeSequence sequence, final RowFilter filter) {
        if (sequence == null) {
            return NodeSequence.emptySequence(0);
        }
        if (filter == null || sequence.isEmpty()) {
            return sequence;
        }
        return new NodeSequence(){

            @Override
            public long getRowCount() {
                return -1L;
            }

            @Override
            public int width() {
                return sequence.width();
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Batch nextBatch() {
                Batch next = sequence.nextBatch();
                return 8.batchFilteredWith(next, filter);
            }

            @Override
            public void close() {
                sequence.close();
            }

            public String toString() {
                return "(filtered " + filter + " " + sequence + ")";
            }
        };
    }

    public static NodeSequence append(final NodeSequence first, final NodeSequence second) {
        if (first == null) {
            return second != null ? second : NodeSequence.emptySequence(0);
        }
        if (second == null) {
            return first;
        }
        int firstWidth = first.width();
        final int secondWidth = second.width();
        if (firstWidth > 0 && secondWidth > 0 && firstWidth != secondWidth) {
            throw new IllegalArgumentException("The sequences must have the same width: " + first + " and " + second);
        }
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        long firstCount = first.getRowCount();
        long secondCount = second.getRowCount();
        final long count = firstCount < 0L ? -1L : (secondCount < 0L ? -1L : firstCount + secondCount);
        return new NodeSequence(){
            private NodeSequence current;
            {
                this.current = first;
            }

            @Override
            public int width() {
                return secondWidth;
            }

            @Override
            public long getRowCount() {
                return count;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Batch nextBatch() {
                Batch batch = this.current.nextBatch();
                while (batch == null && this.current == first) {
                    this.current = second;
                    batch = this.current.nextBatch();
                }
                return batch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    first.close();
                }
                finally {
                    second.close();
                }
            }

            public String toString() {
                return "(append width=" + this.width() + " " + first + "," + second + " )";
            }
        };
    }

    public static NodeSequence merging(final NodeSequence first, final NodeSequence second, final int totalWidth) {
        if (first == null) {
            if (second == null) {
                return NodeSequence.emptySequence(totalWidth);
            }
            final int firstWidth = totalWidth - second.width();
            return new NodeSequence(){

                @Override
                public int width() {
                    return totalWidth;
                }

                @Override
                public long getRowCount() {
                    return second.getRowCount();
                }

                @Override
                public boolean isEmpty() {
                    return second.isEmpty();
                }

                @Override
                public Batch nextBatch() {
                    return 10.batchOf(null, second.nextBatch(), firstWidth, second.width());
                }

                @Override
                public void close() {
                    second.close();
                }

                public String toString() {
                    return "(merge width=" + this.width() + " (null-sequence)," + second + " )";
                }
            };
        }
        if (second == null) {
            final int secondWidth = totalWidth - first.width();
            return new NodeSequence(){

                @Override
                public int width() {
                    return totalWidth;
                }

                @Override
                public long getRowCount() {
                    return first.getRowCount();
                }

                @Override
                public boolean isEmpty() {
                    return first.isEmpty();
                }

                @Override
                public Batch nextBatch() {
                    return 11.batchOf(first.nextBatch(), null, first.width(), secondWidth);
                }

                @Override
                public void close() {
                    first.close();
                }

                public String toString() {
                    return "(merge width=" + this.width() + " " + first + ",(null-sequence) )";
                }
            };
        }
        final int firstWidth = first.width();
        final int secondWidth = second.width();
        final long rowCount = Math.max(-1L, first.getRowCount() + second.getRowCount());
        return new NodeSequence(){

            @Override
            public int width() {
                return totalWidth;
            }

            @Override
            public long getRowCount() {
                return rowCount;
            }

            @Override
            public boolean isEmpty() {
                return rowCount == 0L;
            }

            @Override
            public Batch nextBatch() {
                Batch nextA = first.nextBatch();
                Batch nextB = second.nextBatch();
                if (nextA == null) {
                    if (nextB == null) {
                        return null;
                    }
                    return 12.batchOf(null, nextB, firstWidth, secondWidth);
                }
                return 12.batchOf(nextA, nextB, firstWidth, secondWidth);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                try {
                    first.close();
                }
                finally {
                    second.close();
                }
            }

            public String toString() {
                return "(merge width=" + this.width() + " " + first + "," + second + " )";
            }
        };
    }

    public static Batch batchOf(Collection<CachedNode> nodes, float score, String workspaceName) {
        if (nodes == null) {
            return NodeSequence.emptyBatch(workspaceName, 1);
        }
        return NodeSequence.batchOf(nodes.iterator(), nodes.size(), score, workspaceName);
    }

    public static Batch batchOf(final Iterator<CachedNode> nodes, final long nodeCount, final float score, final String workspaceName) {
        assert (nodeCount >= -1L);
        if (nodes == null) {
            return NodeSequence.emptyBatch(workspaceName, 1);
        }
        return new Batch(){
            private CachedNode current;

            @Override
            public int width() {
                return 1;
            }

            @Override
            public long rowCount() {
                return nodeCount;
            }

            @Override
            public boolean isEmpty() {
                return nodeCount == 0L;
            }

            @Override
            public String getWorkspaceName() {
                return workspaceName;
            }

            @Override
            public boolean hasNext() {
                return nodes.hasNext();
            }

            @Override
            public void nextRow() {
                this.current = (CachedNode)nodes.next();
            }

            @Override
            public CachedNode getNode() {
                return this.current;
            }

            @Override
            public CachedNode getNode(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this.current;
            }

            @Override
            public float getScore() {
                return score;
            }

            @Override
            public float getScore(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return score;
            }

            public String toString() {
                return "(batch node-count=" + this.rowCount() + " score=" + this.getScore() + " )";
            }
        };
    }

    public static Batch batchOfKeys(Collection<NodeKey> keys, float score, String workspaceName, RepositoryCache repository) {
        if (keys == null) {
            return NodeSequence.emptyBatch(workspaceName, 1);
        }
        return NodeSequence.batchOfKeys(keys.iterator(), (long)keys.size(), score, workspaceName, repository);
    }

    public static Batch batchOfKeys(final Iterator<NodeKey> keys, final long nodeCount, final float score, final String workspaceName, final NodeCache cache) {
        assert (nodeCount >= -1L);
        if (keys == null) {
            return NodeSequence.emptyBatch(workspaceName, 1);
        }
        return new Batch(){
            private CachedNode current;

            @Override
            public int width() {
                return 1;
            }

            @Override
            public long rowCount() {
                return nodeCount;
            }

            @Override
            public boolean isEmpty() {
                return nodeCount == 0L;
            }

            @Override
            public String getWorkspaceName() {
                return workspaceName;
            }

            @Override
            public boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            public void nextRow() {
                NodeKey key = (NodeKey)keys.next();
                this.current = cache.getNode(key);
            }

            @Override
            public CachedNode getNode() {
                return this.current;
            }

            @Override
            public CachedNode getNode(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this.current;
            }

            @Override
            public float getScore() {
                return score;
            }

            @Override
            public float getScore(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return score;
            }

            public String toString() {
                return "(batch key-count=" + this.rowCount() + " score=" + this.getScore() + " " + keys + ")";
            }
        };
    }

    public static Batch batchOfKeys(Iterator<NodeKey> keys, long nodeCount, float score, String workspaceName, RepositoryCache repository) {
        assert (nodeCount >= -1L);
        if (keys == null) {
            return NodeSequence.emptyBatch(workspaceName, 1);
        }
        WorkspaceCache cache = repository.getWorkspaceCache(workspaceName);
        return NodeSequence.batchOfKeys(keys, nodeCount, score, workspaceName, cache);
    }

    public static Batch batchOfKeys(final Iterator<NodeKey> keys, final Iterator<Float> scores, final long nodeCount, final String workspaceName, RepositoryCache repository) {
        assert (nodeCount >= -1L);
        if (keys == null) {
            return NodeSequence.emptyBatch(workspaceName, 1);
        }
        final WorkspaceCache cache = repository.getWorkspaceCache(workspaceName);
        return new Batch(){
            private CachedNode current;
            private float score;

            @Override
            public int width() {
                return 1;
            }

            @Override
            public long rowCount() {
                return nodeCount;
            }

            @Override
            public boolean isEmpty() {
                return nodeCount == 0L;
            }

            @Override
            public String getWorkspaceName() {
                return workspaceName;
            }

            @Override
            public boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            public void nextRow() {
                NodeKey key = (NodeKey)keys.next();
                this.current = cache.getNode(key);
                Float score = (Float)scores.next();
                this.score = score != null ? score.floatValue() : 1.0f;
            }

            @Override
            public CachedNode getNode() {
                return this.current;
            }

            @Override
            public CachedNode getNode(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this.current;
            }

            @Override
            public float getScore() {
                return this.score;
            }

            @Override
            public float getScore(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException();
                }
                return this.score;
            }

            public String toString() {
                return "(batch key-count=" + this.rowCount() + " score=" + this.getScore() + " )";
            }
        };
    }

    protected static Batch batchOf(final Batch first, final Batch second, final int firstWidth, final int secondWidth) {
        String workspaceName;
        if (first == null && second == null) {
            return null;
        }
        assert (first != null || second != null);
        String string = workspaceName = first != null ? first.getWorkspaceName() : second.getWorkspaceName();
        assert (first == null || workspaceName.equals(first.getWorkspaceName()));
        assert (second == null || workspaceName.equals(second.getWorkspaceName()));
        assert (first == null || first.width() == firstWidth);
        assert (second == null || second.width() == secondWidth);
        long rowCount = 0L;
        if (first == null) {
            assert (second != null);
            rowCount = second.rowCount();
        } else if (second == null) {
            rowCount = first.rowCount();
        } else {
            long firstSize = first.rowCount();
            long secondSize = second.rowCount();
            rowCount = firstSize == -1L || secondSize == -1L ? -1L : Math.max(firstSize, secondSize);
        }
        final long totalRowCount = rowCount;
        return new Batch(){
            private Batch batch1;
            private Batch batch2;
            private final int totalWidth;
            {
                this.batch1 = first;
                this.batch2 = second;
                this.totalWidth = firstWidth + secondWidth;
            }

            @Override
            public final int width() {
                return this.totalWidth;
            }

            @Override
            public long rowCount() {
                return totalRowCount;
            }

            @Override
            public boolean isEmpty() {
                return totalRowCount == 0L;
            }

            @Override
            public String getWorkspaceName() {
                return workspaceName;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext1() || this.hasNext2();
            }

            private boolean hasNext1() {
                if (this.batch1 == null) {
                    return false;
                }
                if (this.batch1.hasNext()) {
                    return true;
                }
                this.batch1 = null;
                return false;
            }

            private boolean hasNext2() {
                if (this.batch2 == null) {
                    return false;
                }
                if (this.batch2.hasNext()) {
                    return true;
                }
                this.batch2 = null;
                return false;
            }

            @Override
            public void nextRow() {
                if (this.hasNext1()) {
                    this.batch1.nextRow();
                    if (this.hasNext2()) {
                        this.batch2.nextRow();
                    }
                } else {
                    assert (this.batch1 == null);
                    if (this.hasNext2()) {
                        this.batch2.nextRow();
                    } else {
                        throw new NoSuchElementException();
                    }
                }
            }

            @Override
            public CachedNode getNode() {
                return this.batch1 != null ? this.batch1.getNode() : null;
            }

            @Override
            public CachedNode getNode(int index) {
                if (index > 0 && index < firstWidth) {
                    return this.batch1 != null ? this.batch1.getNode(index) : null;
                }
                if (index >= firstWidth && index < this.totalWidth) {
                    return this.batch2 != null ? this.batch2.getNode(index - firstWidth) : null;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public float getScore() {
                return this.batch1 != null ? this.batch1.getScore() : 0.0f;
            }

            @Override
            public float getScore(int index) {
                if (index > 0 && index < firstWidth) {
                    return this.batch1 != null ? this.batch1.getScore(index) : 0.0f;
                }
                if (index >= firstWidth && index < this.totalWidth) {
                    return this.batch2 != null ? this.batch2.getScore(index - firstWidth) : 0.0f;
                }
                throw new IndexOutOfBoundsException();
            }
        };
    }

    protected static final NodeKey keyFor(CachedNode node) {
        return node != null ? node.getKey() : null;
    }

    public static RowFilter requireBoth(final RowFilter first, final RowFilter second) {
        if (first == null) {
            return second == null ? NO_PASS_ROW_FILTER : second;
        }
        if (second == null) {
            return first;
        }
        return new RowFilter(){

            @Override
            public boolean isCurrentRowValid(Batch batch) {
                return first.isCurrentRowValid(batch) && second.isCurrentRowValid(batch);
            }
        };
    }

    public static RowFilter requireEither(final RowFilter first, final RowFilter second) {
        if (first == null) {
            return second == null ? NO_PASS_ROW_FILTER : second;
        }
        if (second == null) {
            return first;
        }
        return new RowFilter(){

            @Override
            public boolean isCurrentRowValid(Batch batch) {
                return first.isCurrentRowValid(batch) || second.isCurrentRowValid(batch);
            }
        };
    }

    public static Batch batchFilteredWith(final Batch batch, final RowFilter filter) {
        if (batch == null || batch.isEmpty() || batch.rowCount() == 0L || filter == null || batch.width() < 1) {
            return batch;
        }
        return new Batch(){
            private boolean atNext = false;

            @Override
            public int width() {
                return batch.width();
            }

            @Override
            public boolean isEmpty() {
                return batch.isEmpty();
            }

            @Override
            public String getWorkspaceName() {
                return batch.getWorkspaceName();
            }

            @Override
            public long rowCount() {
                return -1L;
            }

            @Override
            public CachedNode getNode() {
                return batch.getNode();
            }

            @Override
            public CachedNode getNode(int index) {
                return batch.getNode(index);
            }

            @Override
            public float getScore() {
                return batch.getScore();
            }

            @Override
            public float getScore(int index) {
                return batch.getScore(index);
            }

            @Override
            public boolean hasNext() {
                return this.findNext();
            }

            @Override
            public void nextRow() {
                if (this.findNext()) {
                    this.atNext = false;
                    return;
                }
                throw new NoSuchElementException();
            }

            private boolean findNext() {
                if (!this.atNext) {
                    while (batch.hasNext()) {
                        batch.nextRow();
                        if (!filter.isCurrentRowValid(batch)) continue;
                        this.atNext = true;
                        break;
                    }
                }
                return this.atNext;
            }

            public String toString() {
                return "(filtered-batch " + filter + " on " + batch + ")";
            }
        };
    }

    public static Batch batchWithCount(Batch batch) {
        if (batch == null || batch.isEmpty() || batch.rowCount() >= 0L || batch.width() < 1) {
            return batch;
        }
        return batch.width() == 1 ? new SingleWidthBatch(batch) : new MultiWidthBatch(batch);
    }

    public static Batch copy(Batch batch) {
        if (batch == null) {
            return batch;
        }
        if (batch.isEmpty() || batch.width() < 1) {
            return NodeSequence.emptyBatch(batch.getWorkspaceName(), 1);
        }
        return batch.width() == 1 ? new SingleWidthBatch(batch) : new MultiWidthBatch(batch);
    }

    protected static final class MultiWidthBatch
    extends SingleWidthBatch {
        protected MultiWidthBatch(Batch batch) {
            super(batch);
        }

        @Override
        protected void addRow(Batch batch) {
            for (int i = 0; i != this.width(); ++i) {
                this.nodes.add(batch.getNode(i));
                this.scores.add(Float.valueOf(batch.getScore(i)));
            }
        }

        @Override
        public long rowCount() {
            return this.nodes.size() / this.width();
        }

        @Override
        protected int nodeIndex(int rowNumber, int positionInRow) {
            return rowNumber * this.width() + positionInRow;
        }
    }

    protected static class SingleWidthBatch
    implements Batch,
    Restartable {
        private final Batch original;
        protected final List<CachedNode> nodes = new ArrayList<CachedNode>();
        protected final List<Float> scores = new ArrayList<Float>();
        protected int rowNumber = -1;
        protected final long rowCount;

        protected SingleWidthBatch(Batch batch) {
            this.original = batch;
            long count = 0L;
            while (this.original.hasNext()) {
                this.original.nextRow();
                this.addRow(this.original);
                ++count;
            }
            this.rowCount = count;
        }

        @Override
        public void restart() {
            this.rowNumber = -1;
        }

        protected void addRow(Batch batch) {
            this.nodes.add(this.original.getNode());
            this.scores.add(Float.valueOf(this.original.getScore()));
        }

        @Override
        public String getWorkspaceName() {
            return this.original.getWorkspaceName();
        }

        @Override
        public int width() {
            return this.original.width();
        }

        @Override
        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        @Override
        public long rowCount() {
            return this.rowCount;
        }

        @Override
        public boolean hasNext() {
            return (long)(this.rowNumber + 1) < this.rowCount;
        }

        @Override
        public void nextRow() {
            ++this.rowNumber;
        }

        @Override
        public CachedNode getNode() {
            try {
                return this.nodes.get(this.nodeIndex(this.rowNumber, 0));
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public CachedNode getNode(int index) {
            if (index < 0 || index >= this.width()) {
                throw new NoSuchElementException();
            }
            return this.nodes.get(this.nodeIndex(this.rowNumber, index));
        }

        @Override
        public float getScore() {
            return this.scores.get(this.nodeIndex(this.rowNumber, 0)).floatValue();
        }

        @Override
        public float getScore(int index) {
            if (index < 0 || index >= this.width()) {
                throw new NoSuchElementException();
            }
            return this.scores.get(this.nodeIndex(this.rowNumber, index)).floatValue();
        }

        protected int nodeIndex(int rowNumber, int positionInRow) {
            return rowNumber + positionInRow;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while ((long)i != this.rowCount) {
                sb.append('[');
                for (int j = 0; j != this.width(); ++j) {
                    CachedNode node;
                    if (j != 0) {
                        sb.append(",");
                    }
                    if ((node = this.nodes.get(this.nodeIndex(i, j))) != null) {
                        sb.append(node.getKey());
                        continue;
                    }
                    sb.append("null");
                }
                sb.append(']').append("\n");
                ++i;
            }
            return sb.toString();
        }
    }

    public static interface RowFilter {
        public boolean isCurrentRowValid(Batch var1);
    }

    protected static class AlternateSizeBatch
    implements Batch {
        private final Batch original;
        private final long newSize;

        protected AlternateSizeBatch(Batch original, long newSize) {
            this.original = original;
            this.newSize = newSize;
        }

        @Override
        public long rowCount() {
            return this.newSize;
        }

        @Override
        public String getWorkspaceName() {
            return this.original.getWorkspaceName();
        }

        @Override
        public boolean isEmpty() {
            return this.newSize == 0L;
        }

        @Override
        public int width() {
            return this.original.width();
        }

        @Override
        public boolean hasNext() {
            return this.original.hasNext();
        }

        @Override
        public void nextRow() {
            this.original.nextRow();
        }

        @Override
        public CachedNode getNode() {
            return this.original.getNode();
        }

        @Override
        public CachedNode getNode(int index) {
            return this.original.getNode(index);
        }

        @Override
        public float getScore() {
            return this.original.getScore();
        }

        @Override
        public float getScore(int index) {
            return this.original.getScore(index);
        }

        public String toString() {
            return "(batch size=" + this.newSize + " " + this.original + " )";
        }
    }

    protected static class LimitBatch
    implements Batch {
        private final Batch original;
        private final boolean sizeKnown;
        private final long rowCount;
        private long rowsUsed = 0L;

        protected LimitBatch(Batch original, long rowCount, boolean sizeKnown) {
            this.original = original;
            this.sizeKnown = sizeKnown;
            this.rowCount = rowCount;
        }

        @Override
        public long rowCount() {
            return this.sizeKnown ? this.rowCount : -1L;
        }

        @Override
        public String getWorkspaceName() {
            return this.original.getWorkspaceName();
        }

        @Override
        public boolean isEmpty() {
            return this.sizeKnown && this.rowCount == 0L;
        }

        @Override
        public int width() {
            return this.original.width();
        }

        @Override
        public boolean hasNext() {
            return this.rowsUsed < this.rowCount && this.original.hasNext();
        }

        @Override
        public void nextRow() {
            if (++this.rowsUsed > this.rowCount) {
                throw new NoSuchElementException();
            }
            this.original.nextRow();
        }

        @Override
        public CachedNode getNode() {
            return this.original.getNode();
        }

        @Override
        public CachedNode getNode(int index) {
            return this.original.getNode(index);
        }

        @Override
        public float getScore() {
            return this.original.getScore();
        }

        @Override
        public float getScore(int index) {
            return this.original.getScore(index);
        }

        public String toString() {
            return "(limit-batch size=" + this.rowCount + " " + this.original + " )";
        }
    }

    public static interface Restartable {
        public void restart();
    }

    @NotThreadSafe
    public static interface Batch
    extends RowAccessor {
        public String getWorkspaceName();

        public long rowCount();

        public boolean isEmpty();

        public boolean hasNext();

        public void nextRow();
    }

    @NotThreadSafe
    public static interface RowAccessor {
        public int width();

        public CachedNode getNode();

        public CachedNode getNode(int var1);

        public float getScore();

        public float getScore(int var1);
    }
}

