/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;

public class DefaultTimeScheduler
extends ScheduledThreadPoolExecutor
implements TimeScheduler {
    private static int TIMER_DEFAULT_NUM_THREADS = 3;
    protected static final Log log = LogFactory.getLog(DefaultTimeScheduler.class);

    public DefaultTimeScheduler() {
        this(TIMER_DEFAULT_NUM_THREADS);
    }

    public DefaultTimeScheduler(ThreadFactory factory) {
        this(factory, TIMER_DEFAULT_NUM_THREADS);
    }

    public DefaultTimeScheduler(ThreadFactory factory, int max_threads) {
        super(max_threads, factory);
        this.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(this.getRejectedExecutionHandler()));
    }

    public DefaultTimeScheduler(int corePoolSize) {
        super(corePoolSize);
        this.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(this.getRejectedExecutionHandler()));
    }

    @Override
    public void setThreadFactory(ThreadFactory factory) {
        super.setThreadFactory(factory);
    }

    @Override
    public String dumpTimerTasks() {
        return this.getQueue().toString();
    }

    @Override
    public int getCurrentThreads() {
        return super.getPoolSize();
    }

    @Override
    public int getMinThreads() {
        return super.getCorePoolSize();
    }

    @Override
    public void setMinThreads(int size) {
        super.setCorePoolSize(size);
    }

    @Override
    public int getMaxThreads() {
        return super.getMaximumPoolSize();
    }

    @Override
    public void setMaxThreads(int size) {
        super.setMaximumPoolSize(size);
    }

    @Override
    public long getKeepAliveTime() {
        return super.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public void setKeepAliveTime(long time) {
        super.setKeepAliveTime(time, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> scheduleWithDynamicInterval(TimeScheduler.Task task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.isShutdown()) {
            return null;
        }
        TaskWrapper task_wrapper = new TaskWrapper(task);
        task_wrapper.doSchedule();
        return task_wrapper;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new RobustRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public int size() {
        return this.getQueue().size();
    }

    @Override
    public void stop() {
        List<Runnable> tasks = this.shutdownNow();
        for (Runnable task : tasks) {
            if (!(task instanceof Future)) continue;
            Future future = (Future)((Object)task);
            future.cancel(true);
        }
        this.getQueue().clear();
        try {
            this.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        try {
            String tmp = System.getProperty("jgroups.timer.num_threads");
            if (tmp != null) {
                TIMER_DEFAULT_NUM_THREADS = Integer.parseInt(tmp);
            }
        }
        catch (Exception e) {
            log.error("could not set number of timer threads", e);
        }
    }

    protected class TaskWrapper<V>
    implements Runnable,
    Future<V> {
        private final TimeScheduler.Task task;
        private volatile Future<?> future;
        private volatile boolean cancelled = false;

        public TaskWrapper(TimeScheduler.Task task) {
            this.task = task;
        }

        public Future<?> getFuture() {
            return this.future;
        }

        @Override
        public void run() {
            try {
                if (this.cancelled) {
                    if (this.future != null) {
                        this.future.cancel(true);
                    }
                    return;
                }
                if (this.future != null && this.future.isCancelled()) {
                    return;
                }
                this.task.run();
            }
            catch (Throwable t) {
                log.error("failed running task " + this.task, t);
            }
            if (this.cancelled) {
                if (this.future != null) {
                    this.future.cancel(true);
                }
                return;
            }
            if (this.future != null && this.future.isCancelled()) {
                return;
            }
            this.doSchedule();
        }

        public void doSchedule() {
            long next_interval = this.task.nextInterval();
            if (next_interval <= 0L) {
                if (log.isTraceEnabled()) {
                    log.trace("task will not get rescheduled as interval is " + next_interval);
                }
            } else {
                this.future = DefaultTimeScheduler.this.schedule(this, next_interval, TimeUnit.MILLISECONDS);
                if (this.cancelled) {
                    this.future.cancel(true);
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean retval = !this.isDone();
            this.cancelled = true;
            if (this.future != null) {
                this.future.cancel(mayInterruptIfRunning);
            }
            return retval;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.cancelled || this.future == null || this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }

    protected static class RobustRunnable
    implements Runnable {
        final Runnable command;

        public RobustRunnable(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            block3: {
                if (this.command != null) {
                    try {
                        this.command.run();
                    }
                    catch (Throwable t) {
                        if (!log.isErrorEnabled()) break block3;
                        log.error("exception executing task " + this.command + ": " + t);
                    }
                }
            }
        }

        public String toString() {
            return this.command != null ? this.command.toString() : null;
        }
    }
}

