/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.change;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.change.BinaryValueUnused;
import org.modeshape.jcr.cache.change.BinaryValueUsed;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.Changes;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeChanged;
import org.modeshape.jcr.cache.change.NodeMoved;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.NodeRenamed;
import org.modeshape.jcr.cache.change.NodeReordered;
import org.modeshape.jcr.cache.change.NodeSequenced;
import org.modeshape.jcr.cache.change.NodeSequencingFailure;
import org.modeshape.jcr.cache.change.PropertyAdded;
import org.modeshape.jcr.cache.change.PropertyChanged;
import org.modeshape.jcr.cache.change.PropertyRemoved;
import org.modeshape.jcr.cache.change.RepositoryMetadataChanged;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;

@ThreadSafe
public class RecordingChanges
implements Changes,
ChangeSet {
    private static final long serialVersionUID = 1L;
    private static final transient ConcurrentHashMap<Name, Name> NAME_INSTANCES_MAP = new ConcurrentHashMap();
    private final String processKey;
    private final String repositoryKey;
    private final String workspaceName;
    private final String journalId;
    private final String sessionId;
    private final Queue<Change> events = new ConcurrentLinkedQueue<Change>();
    private final String uuid = UUID.randomUUID().toString();
    private Set<NodeKey> nodeKeys = Collections.emptySet();
    private Map<String, String> userData = Collections.emptyMap();
    private Set<BinaryKey> unusedBinaries = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<BinaryKey> usedBinaries = Collections.newSetFromMap(new ConcurrentHashMap());
    private String userId;
    private DateTime timestamp;

    public RecordingChanges(String sessionId, String processKey, String repositoryKey, String workspaceName, String journalId) {
        this.sessionId = sessionId;
        this.processKey = processKey;
        this.repositoryKey = repositoryKey;
        this.workspaceName = workspaceName;
        this.journalId = journalId;
        assert (this.sessionId != null);
        assert (this.processKey != null);
        assert (this.repositoryKey != null);
    }

    @Override
    public void workspaceAdded(String workspaceName) {
        this.events.add(new WorkspaceAdded(workspaceName));
    }

    @Override
    public void workspaceRemoved(String workspaceName) {
        this.events.add(new WorkspaceRemoved(workspaceName));
    }

    @Override
    public void repositoryMetadataChanged() {
        this.events.add(new RepositoryMetadataChanged());
    }

    @Override
    public void nodeCreated(NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes, Map<Name, Property> properties, boolean queryable) {
        this.events.add(new NodeAdded(key, parentKey, path, this.filterName(primaryType), this.filterNameSet(mixinTypes), properties, queryable));
    }

    @Override
    public void nodeRemoved(NodeKey key, NodeKey parentKey, Path path, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
        this.events.add(new NodeRemoved(key, parentKey, path, this.filterName(primaryType), this.filterNameSet(mixinTypes), queryable));
    }

    @Override
    public void nodeRenamed(NodeKey key, Path newPath, Path.Segment oldName, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
        this.events.add(new NodeRenamed(key, newPath, oldName, this.filterName(primaryType), this.filterNameSet(mixinTypes), queryable));
    }

    @Override
    public void nodeMoved(NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey newParent, NodeKey oldParent, Path newPath, Path oldPath, boolean queryable) {
        this.events.add(new NodeMoved(key, this.filterName(primaryType), this.filterNameSet(mixinTypes), newParent, oldParent, newPath, oldPath, queryable));
    }

    @Override
    public void nodeReordered(NodeKey key, Name primaryType, Set<Name> mixinTypes, NodeKey parent, Path newPath, Path oldPath, Path reorderedBeforePath, boolean queryable) {
        this.events.add(new NodeReordered(key, this.filterName(primaryType), this.filterNameSet(mixinTypes), parent, newPath, oldPath, reorderedBeforePath, queryable));
    }

    @Override
    public void nodeChanged(NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, boolean queryable) {
        this.events.add(new NodeChanged(key, path, this.filterName(primaryType), this.filterNameSet(mixinTypes), queryable));
    }

    @Override
    public void nodeSequenced(NodeKey sequencedNodeKey, Path sequencedNodePath, Name sequencedNodePrimaryType, Set<Name> sequencedNodeMixinTypes, NodeKey outputNodeKey, Path outputNodePath, String outputPath, String userId, String selectedPath, String sequencerName, boolean queryable) {
        this.events.add(new NodeSequenced(sequencedNodeKey, sequencedNodePath, this.filterName(sequencedNodePrimaryType), this.filterNameSet(sequencedNodeMixinTypes), outputNodeKey, outputNodePath, outputPath, userId, selectedPath, sequencerName, queryable));
    }

    @Override
    public void nodeSequencingFailure(NodeKey sequencedNodeKey, Path sequencedNodePath, Name sequencedNodePrimaryType, Set<Name> sequencedNodeMixinTypes, String outputPath, String userId, String selectedPath, String sequencerName, boolean queryable, Throwable cause) {
        this.events.add(new NodeSequencingFailure(sequencedNodeKey, sequencedNodePath, this.filterName(sequencedNodePrimaryType), this.filterNameSet(sequencedNodeMixinTypes), outputPath, userId, selectedPath, sequencerName, queryable, cause));
    }

    @Override
    public void propertyAdded(NodeKey key, Name nodePrimaryType, Set<Name> nodeMixinTypes, Path nodePath, Property property, boolean queryable) {
        this.events.add(new PropertyAdded(key, this.filterName(nodePrimaryType), this.filterNameSet(nodeMixinTypes), nodePath, property, queryable));
    }

    @Override
    public void propertyRemoved(NodeKey key, Name nodePrimaryType, Set<Name> nodeMixinTypes, Path nodePath, Property property, boolean queryable) {
        this.events.add(new PropertyRemoved(key, this.filterName(nodePrimaryType), this.filterNameSet(nodeMixinTypes), nodePath, property, queryable));
    }

    @Override
    public void propertyChanged(NodeKey key, Name nodePrimaryType, Set<Name> nodeMixinTypes, Path nodePath, Property newProperty, Property oldProperty, boolean queryable) {
        this.events.add(new PropertyChanged(key, this.filterName(nodePrimaryType), this.filterNameSet(nodeMixinTypes), nodePath, newProperty, oldProperty, queryable));
    }

    @Override
    public void binaryValueNoLongerUsed(BinaryKey key) {
        this.events.add(new BinaryValueUnused(key));
        this.unusedBinaries.add(key);
    }

    @Override
    public void binaryValueUsed(BinaryKey key) {
        this.events.add(new BinaryValueUsed(key));
        this.usedBinaries.add(key);
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty() && this.nodeKeys.isEmpty();
    }

    @Override
    public Iterator<Change> iterator() {
        return this.events.iterator();
    }

    @Override
    public Set<NodeKey> changedNodes() {
        return this.nodeKeys;
    }

    @Override
    public Set<BinaryKey> unusedBinaries() {
        return this.unusedBinaries;
    }

    @Override
    public Set<BinaryKey> usedBinaries() {
        return this.usedBinaries;
    }

    @Override
    public boolean hasBinaryChanges() {
        return !this.usedBinaries.isEmpty() || !this.unusedBinaries.isEmpty();
    }

    public void setChangedNodes(Set<NodeKey> keys) {
        if (keys != null) {
            this.nodeKeys = Collections.unmodifiableSet(new HashSet<NodeKey>(keys));
        }
    }

    public void freeze(String userId, Map<String, String> userData, DateTime timestamp) {
        this.userId = userId;
        if (userData != null) {
            this.userData = Collections.unmodifiableMap(userData);
        }
        this.timestamp = timestamp;
    }

    @Override
    public String getProcessKey() {
        return this.processKey;
    }

    @Override
    public String getRepositoryKey() {
        return this.repositoryKey;
    }

    @Override
    public String getWorkspaceName() {
        return this.workspaceName;
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, String> getUserData() {
        return this.userData;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getJournalId() {
        return this.journalId;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Save by '").append(this.getUserId()).append("' at ").append(this.getTimestamp()).append(" with user data = ").append(this.userData).append(" in repository with key '").append(this.repositoryKey).append("' and workspace '").append(this.workspaceName);
        if (this.journalId != null) {
            sb.append(". Journal id=").append(this.journalId);
        }
        sb.append("'\n");
        for (Change change : this) {
            sb.append("  ").append(change).append("\n");
        }
        sb.append("changed ").append(this.nodeKeys.size()).append(" nodes:\n");
        for (NodeKey key : this.nodeKeys) {
            sb.append("  ").append(key).append("\n");
        }
        return sb.toString();
    }

    private Name filterName(Name input) {
        if (input == null) {
            return null;
        }
        Name name = NAME_INSTANCES_MAP.putIfAbsent(input, input);
        return name != null ? name : input;
    }

    private Set<Name> filterNameSet(Set<Name> input) {
        HashSet<Name> result = new HashSet<Name>(input.size());
        for (Name name : input) {
            result.add(this.filterName(name));
        }
        return result;
    }
}

