/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableArray;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Null;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.document.ImmutableChildReferences;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.BinaryFactory;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.DateTimeFactory;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ReferenceFactory;
import org.modeshape.jcr.value.UuidFactory;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.StringReference;
import org.modeshape.jcr.value.basic.UuidReference;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.InMemoryBinaryValue;

public class DocumentTranslator {
    public static final String SHA1 = "sha1";
    public static final String PARENT = "parent";
    public static final String LARGE_VALUE = "value";
    public static final String PROPERTIES = "properties";
    public static final String CHILDREN = "children";
    public static final String CHILDREN_INFO = "childrenInfo";
    public static final String COUNT = "count";
    public static final String BLOCK_SIZE = "blockSize";
    public static final String NEXT_BLOCK = "nextBlock";
    public static final String LAST_BLOCK = "lastBlock";
    public static final String NAME = "name";
    public static final String KEY = "key";
    public static final String REFERRERS = "referrers";
    public static final String WEAK = "weak";
    public static final String STRONG = "strong";
    public static final String REFERENCE_COUNT = "refCount";
    private final SchematicDb database;
    private final AtomicLong largeStringSize = new AtomicLong();
    private final ExecutionContext context;
    private final PropertyFactory propertyFactory;
    private final ValueFactories factories;
    private final PathFactory paths;
    private final NameFactory names;
    private final DateTimeFactory dates;
    private final BinaryFactory binaries;
    private final ValueFactory<Long> longs;
    private final ValueFactory<Double> doubles;
    private final ValueFactory<URI> uris;
    private final ValueFactory<BigDecimal> decimals;
    private final ValueFactory<String> strings;
    private final ReferenceFactory refs;
    private final ReferenceFactory weakrefs;
    private final UuidFactory uuids;
    private final TextEncoder encoder = NoOpEncoder.getInstance();
    private final TextDecoder decoder = NoOpEncoder.getInstance();

    public DocumentTranslator(ExecutionContext context, SchematicDb database, long largeStringSize) {
        this.database = database;
        this.largeStringSize.set(largeStringSize);
        this.context = context;
        this.propertyFactory = this.context.getPropertyFactory();
        this.factories = this.context.getValueFactories();
        this.paths = this.factories.getPathFactory();
        this.names = this.factories.getNameFactory();
        this.dates = this.factories.getDateFactory();
        this.binaries = this.factories.getBinaryFactory();
        this.longs = this.factories.getLongFactory();
        this.doubles = this.factories.getDoubleFactory();
        this.uris = this.factories.getUriFactory();
        this.decimals = this.factories.getDecimalFactory();
        this.refs = this.factories.getReferenceFactory();
        this.weakrefs = this.factories.getWeakReferenceFactory();
        this.uuids = this.factories.getUuidFactory();
        this.strings = this.factories.getStringFactory();
        assert (this.largeStringSize.get() >= 0L);
    }

    void setLargeValueSize(long largeValueSize) {
        assert (largeValueSize > -1L);
        this.largeStringSize.set(largeValueSize);
    }

    public NodeKey getParentKey(Document document, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        Object value = document.get(PARENT);
        return this.keyFrom(value, primaryWorkspaceKey, secondaryWorkspaceKey);
    }

    public Set<NodeKey> getParentKeys(Document document, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        Object value = document.get(PARENT);
        if (value instanceof String) {
            return Collections.emptySet();
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 1) {
                return Collections.emptySet();
            }
            LinkedHashSet<NodeKey> keys = new LinkedHashSet<NodeKey>();
            Iterator iter = values.iterator();
            iter.next();
            while (iter.hasNext()) {
                String key;
                Object v = iter.next();
                if (v == null || !(key = (String)v).equals(primaryWorkspaceKey) && !key.equals(secondaryWorkspaceKey)) continue;
                keys.add(new NodeKey(key));
            }
            return keys;
        }
        return Collections.emptySet();
    }

    private final NodeKey keyFrom(Object value, String primaryWorkspaceKey, String secondaryWorkspaceKey) {
        if (value instanceof String) {
            return new NodeKey((String)value);
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 1) {
                return this.keyFrom(values.get(0), primaryWorkspaceKey, secondaryWorkspaceKey);
            }
            NodeKey keyWithSecondaryWorkspaceKey = null;
            for (Object v : values) {
                if (v == null) continue;
                NodeKey key = new NodeKey((String)v);
                if (key.getWorkspaceKey().equals(primaryWorkspaceKey)) {
                    return key;
                }
                if (keyWithSecondaryWorkspaceKey != null || secondaryWorkspaceKey == null || !key.getWorkspaceKey().equals(secondaryWorkspaceKey)) continue;
                keyWithSecondaryWorkspaceKey = key;
            }
            return keyWithSecondaryWorkspaceKey;
        }
        return null;
    }

    public void getProperties(Document document, Map<Name, Property> result) {
        Document properties = document.getDocument(PROPERTIES);
        if (properties != null) {
            for (Document.Field nsField : properties.fields()) {
                String namespaceUri = nsField.getName();
                Document nsDoc = nsField.getValueAsDocument();
                for (Document.Field propField : nsDoc.fields()) {
                    String localName = propField.getName();
                    Name propertyName = this.names.create(namespaceUri, localName);
                    if (result.containsKey(propertyName)) continue;
                    Object fieldValue = propField.getValue();
                    Property property = this.propertyFor(propertyName, fieldValue);
                    result.put(propertyName, property);
                }
            }
        }
    }

    public int countProperties(Document document) {
        Document properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            return 0;
        }
        int count = 0;
        for (Document.Field nsField : properties.fields()) {
            Document urlProps = nsField.getValueAsDocument();
            if (urlProps == null) continue;
            for (Document.Field propField : urlProps.fields()) {
                if (Null.matches((Object)propField.getValue())) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean hasProperties(Document document) {
        Document properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            return false;
        }
        for (Document.Field nsField : properties.fields()) {
            Document urlProps = nsField.getValueAsDocument();
            if (urlProps == null) continue;
            for (Document.Field propField : urlProps.fields()) {
                if (Null.matches((Object)propField.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProperty(Document document, Name propertyName) {
        Document properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            return false;
        }
        Document urlProps = properties.getDocument(propertyName.getNamespaceUri());
        if (urlProps == null) {
            return false;
        }
        Object fieldValue = urlProps.get(propertyName.getLocalName());
        return !Null.matches((Object)fieldValue);
    }

    public Property getProperty(Document document, Name propertyName) {
        Document properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            return null;
        }
        Document urlProps = properties.getDocument(propertyName.getNamespaceUri());
        if (urlProps == null) {
            return null;
        }
        Object fieldValue = urlProps.get(propertyName.getLocalName());
        return fieldValue == null ? null : this.propertyFor(propertyName, fieldValue);
    }

    protected Property propertyFor(Name propertyName, Object fieldValue) {
        Object value = this.valueFromDocument(fieldValue);
        if (value instanceof List) {
            List values = (List)value;
            return this.propertyFactory.create(propertyName, values);
        }
        return this.propertyFactory.create(propertyName, value);
    }

    public void setProperty(EditableDocument document, Property property, Set<BinaryKey> unusedBinaryKeys) {
        Name propertyName;
        String namespaceUri;
        EditableDocument urlProps;
        EditableDocument properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            properties = document.setDocument(PROPERTIES);
        }
        if ((urlProps = properties.getDocument(namespaceUri = (propertyName = property.getName()).getNamespaceUri())) == null) {
            urlProps = properties.setDocument(namespaceUri);
        }
        String localName = propertyName.getLocalName();
        Object oldValue = urlProps.get(localName);
        this.decrementBinaryReferenceCount(oldValue, unusedBinaryKeys);
        if (property.isEmpty()) {
            urlProps.setArray(localName);
        } else if (property.isMultiple()) {
            EditableArray values = Schematic.newArray((int)property.size());
            for (Object v : property) {
                values.add(this.valueToDocument(v, unusedBinaryKeys));
            }
            urlProps.setArray(localName, (Array)values);
        } else {
            assert (property.isSingle());
            Object value = this.valueToDocument(property.getFirstValue(), unusedBinaryKeys);
            if (value == null) {
                urlProps.remove(localName);
            } else {
                urlProps.set(localName, value);
            }
        }
    }

    public Property removeProperty(EditableDocument document, Name propertyName, Set<BinaryKey> unusedBinaryKeys) {
        EditableDocument properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            return null;
        }
        String namespaceUri = propertyName.getNamespaceUri();
        EditableDocument urlProps = properties.getDocument(namespaceUri);
        if (urlProps == null) {
            return null;
        }
        String localName = propertyName.getLocalName();
        Object fieldValue = urlProps.remove(localName);
        this.decrementBinaryReferenceCount(fieldValue, unusedBinaryKeys);
        if (urlProps.isEmpty()) {
            properties.remove(namespaceUri);
        }
        return fieldValue == null ? null : this.propertyFor(propertyName, fieldValue);
    }

    public void addPropertyValues(EditableDocument document, Name propertyName, boolean isMultiple, Collection<?> values, Set<BinaryKey> unusedBinaryKeys) {
        String localName;
        Object propValue;
        String namespaceUri;
        EditableDocument urlProps;
        assert (values != null);
        int numValues = values.size();
        if (numValues == 0) {
            return;
        }
        EditableDocument properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            properties = document.setDocument(PROPERTIES);
        }
        if ((urlProps = properties.getDocument(namespaceUri = propertyName.getNamespaceUri())) == null) {
            urlProps = properties.setDocument(namespaceUri);
        }
        if ((propValue = urlProps.get(localName = propertyName.getLocalName())) == null) {
            if (isMultiple || numValues > 1) {
                EditableArray array = Schematic.newArray((int)numValues);
                for (Object value : values) {
                    array.addValue(this.valueToDocument(value, unusedBinaryKeys));
                }
                urlProps.setArray(localName, (Array)array);
            } else {
                urlProps.set(localName, this.valueToDocument(values.iterator().next(), unusedBinaryKeys));
            }
        } else if (propValue instanceof List) {
            this.decrementBinaryReferenceCount(propValue, unusedBinaryKeys);
            EditableArray array = urlProps.getArray(localName);
            for (Object value : values) {
                value = this.valueToDocument(value, unusedBinaryKeys);
                array.addValueIfAbsent(value);
            }
        } else {
            this.decrementBinaryReferenceCount(propValue, unusedBinaryKeys);
            if (numValues == 1) {
                Object value = this.valueToDocument(values.iterator().next(), unusedBinaryKeys);
                if (!value.equals(propValue)) {
                    EditableArray array = Schematic.newArray((Object[])new Object[]{value, propValue});
                    urlProps.setArray(localName, (Array)array);
                }
            } else {
                EditableArray array = Schematic.newArray((int)numValues);
                for (Object value : values) {
                    if ((value = this.valueToDocument(value, unusedBinaryKeys)).equals(propValue)) continue;
                    array.addValue(value);
                }
                assert (!array.isEmpty());
                urlProps.setArray(localName, (Array)array);
            }
        }
    }

    public void removePropertyValues(EditableDocument document, Name propertyName, Collection<?> values, Set<BinaryKey> unusedBinaryKeys) {
        assert (values != null);
        int numValues = values.size();
        if (numValues == 0) {
            return;
        }
        EditableDocument properties = document.getDocument(PROPERTIES);
        if (properties == null) {
            return;
        }
        String namespaceUri = propertyName.getNamespaceUri();
        EditableDocument urlProps = properties.getDocument(namespaceUri);
        if (urlProps == null) {
            return;
        }
        String localName = propertyName.getLocalName();
        Object propValue = urlProps.get(localName);
        if (propValue instanceof List) {
            EditableArray array = urlProps.getArray(localName);
            for (Object value : values) {
                value = this.valueToDocument(value, unusedBinaryKeys);
                array.remove(value);
            }
        } else if (propValue != null) {
            for (Object value : values) {
                if (!(value = this.valueToDocument(value, unusedBinaryKeys)).equals(propValue)) continue;
                urlProps.remove(localName);
                break;
            }
        }
        if (urlProps.isEmpty()) {
            properties.remove(namespaceUri);
        }
    }

    public void setParents(EditableDocument document, NodeKey parent, NodeKey oldParent, SessionNode.ChangedAdditionalParents additionalParents) {
        Object existingParent = document.get(PARENT);
        if (existingParent == null) {
            if (parent != null) {
                if (additionalParents == null || additionalParents.isEmpty()) {
                    document.setString(PARENT, parent.toString());
                } else {
                    EditableArray parents = Schematic.newArray((int)(additionalParents.additionCount() + 1));
                    parents.add((Object)parent.toString());
                    for (NodeKey added : additionalParents.getAdditions()) {
                        parents.add((Object)added.toString());
                    }
                    document.set(PARENT, (Object)parents);
                }
            } else if (additionalParents != null && !additionalParents.isEmpty()) {
                EditableArray parents = Schematic.newArray((int)additionalParents.additionCount());
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.add((Object)added.toString());
                }
                document.set(PARENT, (Object)parents);
            }
            return;
        }
        if (existingParent instanceof List) {
            EditableArray parents = document.getArray(PARENT);
            if (parent != null && !parent.equals(oldParent)) {
                parents.addStringIfAbsent(parent.toString());
                if (oldParent != null) {
                    parents.remove(oldParent.toString());
                }
            }
            if (additionalParents != null) {
                for (NodeKey removed : additionalParents.getRemovals()) {
                    parents.remove(removed.toString());
                }
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.addStringIfAbsent(added.toString());
                }
            }
        } else if (existingParent instanceof String) {
            String existing = (String)existingParent;
            if (parent != null && (additionalParents == null || additionalParents.isEmpty())) {
                String oldParentStr;
                String string = oldParentStr = oldParent != null ? oldParent.toString() : null;
                if (existing.equals(oldParentStr)) {
                    document.set(PARENT, (Object)parent.toString());
                } else {
                    EditableArray parents = Schematic.newArray((int)2);
                    parents.add((Object)existing);
                    parents.add((Object)parent.toString());
                    document.set(PARENT, (Object)parents);
                }
            } else {
                int totalNumber = additionalParents.additionCount() - additionalParents.removalCount() + 1;
                assert (totalNumber >= 0);
                EditableArray parents = Schematic.newArray((int)totalNumber);
                if (parent != null && !existingParent.equals(parent.toString())) {
                    parents.add((Object)parent.toString());
                } else {
                    parents.add(existingParent);
                }
                for (NodeKey removed : additionalParents.getRemovals()) {
                    parents.remove(removed.toString());
                }
                for (NodeKey added : additionalParents.getAdditions()) {
                    parents.add((Object)added.toString());
                }
                document.set(PARENT, (Object)parents);
            }
        }
    }

    public void setKey(EditableDocument document, NodeKey key) {
        assert (document.getString(KEY) == null);
        document.setString(KEY, key.toString());
    }

    public void changeChildren(NodeKey key, EditableDocument document, SessionNode.ChangedChildren changedChildren, ChildReferences appended) {
        assert (changedChildren != null || appended != null);
        ChildReferencesInfo info = this.getChildReferencesInfo((Document)document);
        long newTotalSize = 0L;
        EditableDocument doc = document;
        EditableDocument lastDoc = document;
        String lastDocKey = null;
        if (changedChildren != null && !changedChildren.isEmpty()) {
            Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey = changedChildren.getInsertionsByBeforeKey();
            Set<NodeKey> removals = changedChildren.getRemovals();
            Map<NodeKey, Name> newNames = changedChildren.getNewNames();
            while (doc != null) {
                ChildReferencesInfo docInfo;
                long blockCount = this.insertChildren(doc, insertionsByBeforeKey, removals, newNames);
                newTotalSize += blockCount;
                SchematicEntry nextEntry = null;
                ChildReferencesInfo childReferencesInfo = docInfo = doc == document ? info : this.getChildReferencesInfo((Document)doc);
                if (docInfo != null && docInfo.nextKey != null) {
                    nextEntry = this.database.get(docInfo.nextKey);
                }
                if (nextEntry != null) {
                    doc.getDocument(CHILDREN_INFO).setNumber(BLOCK_SIZE, blockCount);
                    lastDoc = doc = nextEntry.editDocumentContent();
                    assert (docInfo != null);
                    lastDocKey = docInfo.nextKey;
                    continue;
                }
                if (doc == document) {
                    EditableDocument childInfo = doc.getDocument(CHILDREN_INFO);
                    childInfo.remove(BLOCK_SIZE);
                    childInfo.set(COUNT, (Object)newTotalSize);
                }
                doc = null;
            }
        } else {
            long l = newTotalSize = info != null ? info.totalSize : 0L;
        }
        if (appended != null && appended.size() != 0L) {
            EditableDocument childInfo;
            String lastKey;
            String string = lastKey = info != null ? info.lastKey : null;
            if (lastKey != null && !lastKey.equals(lastDocKey)) {
                SchematicEntry lastBlockEntry = this.database.get(lastKey);
                lastDoc = lastBlockEntry.editDocumentContent();
            } else {
                lastKey = null;
            }
            EditableArray lastChildren = lastDoc.getArray(CHILDREN);
            if (lastChildren == null) {
                lastChildren = lastDoc.setArray(CHILDREN);
            }
            for (ChildReference ref : appended) {
                lastChildren.add((Object)this.fromChildReference(ref));
            }
            if (lastDoc != document) {
                EditableDocument lastDocInfo = lastDoc.getDocument(CHILDREN_INFO);
                if (lastDocInfo == null) {
                    lastDocInfo = lastDoc.setDocument(CHILDREN_INFO);
                }
                lastDocInfo.setNumber(BLOCK_SIZE, lastChildren.size());
            }
            if ((childInfo = document.getDocument(CHILDREN_INFO)) == null) {
                childInfo = document.setDocument(CHILDREN_INFO);
            }
            childInfo.setNumber(COUNT, newTotalSize += appended.size());
            if (lastKey != null) {
                childInfo.setString(LAST_BLOCK, lastKey);
            }
        }
    }

    protected long insertChildren(EditableDocument document, Map<NodeKey, SessionNode.Insertions> insertionsByBeforeKey, Set<NodeKey> removals, Map<NodeKey, Name> newNames) {
        EditableArray children = document.getArray(CHILDREN);
        assert (children != null);
        EditableArray newChildren = Schematic.newArray((int)children.size());
        for (Object value : children) {
            ChildReference ref = this.childReferenceFrom(value);
            if (ref == null) continue;
            NodeKey childKey = ref.getKey();
            SessionNode.Insertions insertions = insertionsByBeforeKey.remove(childKey);
            if (insertions != null) {
                for (ChildReference inserted : insertions.inserted()) {
                    newChildren.add((Object)this.fromChildReference(inserted));
                }
            }
            if (removals.remove(childKey)) continue;
            Name newName = newNames.get(childKey);
            if (newName != null) {
                ChildReference newRef = ref.with(newName, 1);
                value = this.fromChildReference(newRef);
            }
            newChildren.add(value);
        }
        document.set(CHILDREN, (Object)newChildren);
        return newChildren.size();
    }

    public ChildReferences getChildReferences(WorkspaceCache cache, Document document) {
        List children = document.getArray(CHILDREN);
        if (children == null) {
            return ImmutableChildReferences.EMPTY_CHILD_REFERENCES;
        }
        ArrayList<ChildReference> refs = new ArrayList<ChildReference>(children.size());
        for (Object value : children) {
            ChildReference ref = this.childReferenceFrom(value);
            if (ref == null) continue;
            refs.add(ref);
        }
        ChildReferences result = ImmutableChildReferences.create(refs);
        ChildReferencesInfo info = this.getChildReferencesInfo(document);
        if (info != null) {
            result = ImmutableChildReferences.create(result, info, cache);
        }
        return result;
    }

    public ChildReferencesInfo getChildReferencesInfo(Document document) {
        Document childrenInfo = document.getDocument(CHILDREN_INFO);
        if (childrenInfo != null) {
            long totalSize = childrenInfo.getLong(COUNT, 0L);
            long blockSize = childrenInfo.getLong(BLOCK_SIZE, 0L);
            String nextBlockKey = childrenInfo.getString(NEXT_BLOCK);
            String lastBlockKey = childrenInfo.getString(LAST_BLOCK, nextBlockKey);
            return new ChildReferencesInfo(totalSize, blockSize, nextBlockKey, lastBlockKey);
        }
        return null;
    }

    protected ChildReference childReferenceFrom(Object value) {
        if (value instanceof Document) {
            Document doc = (Document)value;
            String keyStr = doc.getString(KEY);
            NodeKey key = new NodeKey(keyStr);
            String nameStr = doc.getString(NAME);
            Name name = (Name)this.names.create(nameStr, this.decoder);
            return new ChildReference(key, name, 1);
        }
        return null;
    }

    public EditableDocument fromChildReference(ChildReference ref) {
        return Schematic.newDocument((String)KEY, (Object)this.valueToDocument(ref.getKey(), null), (String)NAME, (Object)this.strings.create(ref.getName()));
    }

    public Set<NodeKey> getReferrers(Document document, CachedNode.ReferenceType type) {
        Document weak;
        Document strong;
        Document referrers = document.getDocument(REFERRERS);
        if (referrers == null) {
            return new HashSet<NodeKey>();
        }
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        if (type != CachedNode.ReferenceType.WEAK && (strong = referrers.getDocument(STRONG)) != null) {
            for (String keyString : strong.keySet()) {
                result.add(new NodeKey(keyString));
            }
        }
        if (type != CachedNode.ReferenceType.STRONG && (weak = referrers.getDocument(WEAK)) != null) {
            for (String keyString : weak.keySet()) {
                result.add(new NodeKey(keyString));
            }
        }
        return result;
    }

    public void changeReferrers(EditableDocument document, SessionNode.ReferrerChanges changes) {
        List<NodeKey> weakRemoved;
        Map<NodeKey, Integer> weakCount;
        if (changes.isEmpty()) {
            return;
        }
        EditableDocument referrers = document.getDocument(REFERRERS);
        List<NodeKey> strongAdded = changes.getAddedReferrers(CachedNode.ReferenceType.STRONG);
        List<NodeKey> weakAdded = changes.getAddedReferrers(CachedNode.ReferenceType.WEAK);
        if (referrers == null) {
            referrers = document.setDocument(REFERRERS);
            if (!strongAdded.isEmpty()) {
                HashSet<NodeKey> strongAddedSet = new HashSet<NodeKey>(strongAdded);
                EditableDocument strong = referrers.setDocument(STRONG);
                for (NodeKey key : strongAddedSet) {
                    strong.set(key.toString(), (Object)Collections.frequency(strongAdded, key));
                }
            }
            if (!weakAdded.isEmpty()) {
                HashSet<NodeKey> weakAddedSet = new HashSet<NodeKey>(weakAdded);
                EditableDocument weak = referrers.setDocument(WEAK);
                for (NodeKey key : weakAddedSet) {
                    weak.set(key.toString(), (Object)Collections.frequency(weakAdded, key));
                }
            }
            return;
        }
        List<NodeKey> strongRemoved = changes.getRemovedReferrers(CachedNode.ReferenceType.STRONG);
        Map<NodeKey, Integer> strongCount = this.computeReferrersCountDelta(strongAdded, strongRemoved);
        if (!strongCount.isEmpty()) {
            EditableDocument strong = referrers.getOrCreateDocument(STRONG);
            this.updateReferrers(strong, strongCount);
        }
        if (!(weakCount = this.computeReferrersCountDelta(weakAdded, weakRemoved = changes.getRemovedReferrers(CachedNode.ReferenceType.WEAK))).isEmpty()) {
            EditableDocument weak = referrers.getOrCreateDocument(WEAK);
            this.updateReferrers(weak, weakCount);
        }
    }

    private void updateReferrers(EditableDocument owningDocument, Map<NodeKey, Integer> referrersCountDelta) {
        for (NodeKey strongKey : referrersCountDelta.keySet()) {
            int newCount = referrersCountDelta.get(strongKey);
            String keyString = strongKey.toString();
            Integer existingCount = (Integer)owningDocument.get(keyString);
            if (existingCount != null) {
                int actualCount = existingCount + newCount;
                if (actualCount <= 0) {
                    owningDocument.remove(keyString);
                    continue;
                }
                owningDocument.set(keyString, (Object)actualCount);
                continue;
            }
            if (newCount <= 0) continue;
            owningDocument.set(keyString, (Object)newCount);
        }
    }

    private Map<NodeKey, Integer> computeReferrersCountDelta(List<NodeKey> addedReferrers, List<NodeKey> removedReferrers) {
        HashMap<NodeKey, Integer> referrersCountDelta = new HashMap<NodeKey, Integer>(0);
        HashSet<NodeKey> addedReferrersUnique = new HashSet<NodeKey>(addedReferrers);
        for (NodeKey addedReferrer : addedReferrersUnique) {
            int referrersCount = Collections.frequency(addedReferrers, addedReferrer) - Collections.frequency(removedReferrers, addedReferrer);
            referrersCountDelta.put(addedReferrer, referrersCount);
        }
        HashSet<NodeKey> removedReferrersUnique = new HashSet<NodeKey>(removedReferrers);
        for (NodeKey removedReferrer : removedReferrersUnique) {
            if (referrersCountDelta.containsKey(removedReferrer)) continue;
            referrersCountDelta.put(removedReferrer, -1 * Collections.frequency(removedReferrers, removedReferrer));
        }
        return referrersCountDelta;
    }

    protected Object valueToDocument(Object value, Set<BinaryKey> unusedBinaryKeys) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String valueStr = (String)value;
            if ((long)valueStr.length() < this.largeStringSize.get()) {
                return value;
            }
            value = this.binaries.create(valueStr);
        }
        if (value instanceof NodeKey) {
            return ((NodeKey)value).toString();
        }
        if (value instanceof UUID) {
            return Schematic.newDocument((String)"$uuid", (Object)this.strings.create((UUID)value));
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Integer) {
            return new Long(((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Name) {
            Name name = (Name)value;
            return Schematic.newDocument((String)"$name", (Object)name.getString(this.encoder));
        }
        if (value instanceof Path) {
            Path path = (Path)value;
            EditableArray segments = Schematic.newArray((int)path.size());
            for (Path.Segment segment : path) {
                String str = segment.getString(this.encoder);
                segments.add(str);
            }
            boolean relative = !path.isAbsolute();
            return Schematic.newDocument((String)"$path", (Object)segments, (String)"$relative", (Object)relative);
        }
        if (value instanceof DateTime) {
            return Schematic.newDocument((String)"$date", (Object)this.strings.create((DateTime)value));
        }
        if (value instanceof BigDecimal) {
            return Schematic.newDocument((String)"$dec", (Object)this.strings.create((BigDecimal)value));
        }
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            String key = ref.isWeak() ? "$wref" : "$ref";
            String refString = value instanceof NodeKeyReference ? ((NodeKeyReference)value).getNodeKey().toString() : this.strings.create(ref);
            boolean isForeign = value instanceof NodeKeyReference && ((NodeKeyReference)value).isForeign();
            return Schematic.newDocument((String)key, (Object)refString, (String)"$foreign", (Object)isForeign);
        }
        if (value instanceof URI) {
            return Schematic.newDocument((String)"$uri", (Object)this.strings.create((URI)value));
        }
        if (value instanceof BinaryValue) {
            BinaryValue binary = (BinaryValue)value;
            if (binary instanceof InMemoryBinaryValue) {
                return new Binary(((InMemoryBinaryValue)binary).getBytes());
            }
            String sha1 = binary.getHexHash();
            long size = binary.getSize();
            EditableDocument ref = Schematic.newDocument((String)"$sha1", (Object)sha1, (String)"$len", (Object)size);
            this.incrementBinaryReferenceCount(binary.getKey(), unusedBinaryKeys);
            return ref;
        }
        assert (false) : "Unexpected property value \"" + value + "\" of type " + value.getClass().getSimpleName();
        return null;
    }

    protected final String keyForBinaryReferenceDocument(String sha1) {
        return sha1 + "-ref";
    }

    protected void incrementBinaryReferenceCount(BinaryKey binaryKey, Set<BinaryKey> unusedBinaryKeys) {
        String sha1 = binaryKey.toString();
        String key = this.keyForBinaryReferenceDocument(sha1);
        SchematicEntry entry = this.database.get(key);
        if (entry == null) {
            EditableDocument metadata = Schematic.newDocument((String)SHA1, (Object)sha1, (String)REFERENCE_COUNT, (Object)1L);
            EditableDocument content = Schematic.newDocument();
            this.database.put(key, (Document)metadata, (Document)content);
        } else {
            EditableDocument sha1Usage;
            Long countValue = (sha1Usage = entry.editDocumentContent()).getLong(REFERENCE_COUNT);
            sha1Usage.setNumber(REFERENCE_COUNT, countValue != null ? countValue + 1L : 1L);
        }
        if (unusedBinaryKeys != null) {
            unusedBinaryKeys.remove(binaryKey);
        }
    }

    protected boolean decrementBinaryReferenceCount(Object fieldValue, Set<BinaryKey> unusedBinaryKeys) {
        Document docValue;
        String sha1;
        if (fieldValue instanceof List) {
            for (Object value : (List)fieldValue) {
                this.decrementBinaryReferenceCount(value, unusedBinaryKeys);
            }
        } else if (fieldValue instanceof Document && (sha1 = (docValue = (Document)fieldValue).getString(SHA1)) != null) {
            SchematicEntry entry = this.database.get(sha1 + "-usage");
            EditableDocument sha1Usage = entry.editDocumentContent();
            Long countValue = sha1Usage.getLong(REFERENCE_COUNT);
            if (countValue == null) {
                return true;
            }
            long count = countValue - 1L;
            if (count < 0L) {
                count = 0L;
                if (unusedBinaryKeys != null) {
                    unusedBinaryKeys.add(new BinaryKey(sha1));
                }
            }
            sha1Usage.setNumber(REFERENCE_COUNT, count);
            return count <= 1L;
        }
        return false;
    }

    protected Object valueFromDocument(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Binary) {
            Binary binary = (Binary)value;
            return this.binaries.create(binary.getBytes());
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            return this.uris.create(uri);
        }
        if (value instanceof List) {
            List values = (List)value;
            int size = values.size();
            if (size == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>(values.size());
            for (Object val : values) {
                result.add(this.valueFromDocument(val));
            }
            return result;
        }
        if (value instanceof Document) {
            Document doc = (Document)value;
            String valueStr = null;
            List array = null;
            valueStr = doc.getString("$name");
            if (!Null.matches((Object)valueStr)) {
                return this.names.create(valueStr, this.decoder);
            }
            array = doc.getArray("$path");
            if (!Null.matches((Object)array)) {
                List<Path.Segment> segments = this.segmentsFrom(array);
                boolean relative = doc.getBoolean("$relative");
                return relative ? this.paths.createRelativePath(segments) : this.paths.createAbsolutePath(segments);
            }
            valueStr = doc.getString("$date");
            if (!Null.matches((Object)valueStr)) {
                return this.dates.create(valueStr);
            }
            valueStr = doc.getString("$dec");
            if (!Null.matches((Object)valueStr)) {
                return this.decimals.create(valueStr);
            }
            valueStr = doc.getString("$ref");
            if (!Null.matches((Object)valueStr)) {
                return this.createReferenceFromString(this.refs, doc, valueStr);
            }
            valueStr = doc.getString("$wref");
            if (!Null.matches((Object)valueStr)) {
                return this.createReferenceFromString(this.weakrefs, doc, valueStr);
            }
            valueStr = doc.getString("$uuid");
            if (!Null.matches((Object)valueStr)) {
                return this.uuids.create(valueStr);
            }
            valueStr = doc.getString("$uri");
            if (!Null.matches((Object)valueStr)) {
                return this.uris.create(valueStr);
            }
            valueStr = doc.getString("$sha1");
            if (!Null.matches((Object)valueStr)) {
                String sha1 = valueStr;
                long size = doc.getLong("$len");
                try {
                    return this.binaries.find(new BinaryKey(sha1), size);
                }
                catch (BinaryStoreException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        }
        if (value instanceof Integer) {
            return this.longs.create(((Integer)value).longValue());
        }
        if (value instanceof Float) {
            return this.doubles.create(((Float)value).doubleValue());
        }
        assert (false) : "Unexpected document value \"" + value + "\" of type " + value.getClass().getSimpleName();
        return null;
    }

    private Object createReferenceFromString(ReferenceFactory referenceFactory, Document doc, String valueStr) {
        boolean isForeign = doc.getBoolean("$foreign");
        if (NodeKey.isValidFormat(valueStr)) {
            return referenceFactory.create(new NodeKey(valueStr), isForeign);
        }
        try {
            UUID uuid = UUID.fromString(valueStr);
            return this.refs.create(new UuidReference(uuid));
        }
        catch (IllegalArgumentException e) {
            return this.refs.create(new StringReference(valueStr));
        }
    }

    protected List<Path.Segment> segmentsFrom(List<?> segmentValues) {
        ArrayList<Path.Segment> segments = new ArrayList<Path.Segment>(segmentValues.size());
        for (Object value : segmentValues) {
            Path.Segment segment = this.paths.createSegment(value.toString(), this.decoder);
            segments.add(segment);
        }
        return segments;
    }

    protected Object resolveLargeValue(String sha1) {
        SchematicEntry entry = this.database.get(sha1);
        if (entry == null) {
            return null;
        }
        if (entry.hasBinaryContent()) {
            return this.binaries.create(entry.getContentAsBinary().getBytes());
        }
        Document largeValueDoc = entry.getContentAsDocument();
        return largeValueDoc.getString(LARGE_VALUE);
    }

    public void optimizeChildrenBlocks(NodeKey key, EditableDocument document, int targetCountPerBlock, int tolerance) {
        EditableArray children;
        if (document == null) {
            SchematicEntry entry = this.database.get(key.toString());
            if (entry == null) {
                return;
            }
            document = entry.editDocumentContent();
            if (document == null) {
                return;
            }
        }
        if ((children = document.getArray(CHILDREN)) == null) {
            return;
        }
        EditableDocument info = document.getDocument(CHILDREN_INFO);
        boolean selfContained = true;
        if (info != null) {
            boolean bl = selfContained = !info.containsField(NEXT_BLOCK);
        }
        if (selfContained) {
            int total = children.size();
            if (total < targetCountPerBlock + tolerance) {
                return;
            }
            this.splitChildren(key, document, children, targetCountPerBlock, tolerance, true, null);
        } else {
            assert (info != null);
            EditableDocument doc = document;
            NodeKey docKey = key;
            while (doc != null) {
                boolean isFirst;
                EditableDocument docInfo = doc.getDocument(CHILDREN_INFO);
                String nextKey = docInfo != null ? docInfo.getString(NEXT_BLOCK) : null;
                children = doc.getArray(CHILDREN);
                int count = children.size();
                boolean bl = isFirst = doc == document;
                if (count > targetCountPerBlock + tolerance) {
                    this.splitChildren(docKey, doc, children, targetCountPerBlock, tolerance, isFirst, nextKey);
                } else if (count < targetCountPerBlock - tolerance && nextKey != null && (nextKey = this.mergeChildren(docKey, doc, children, isFirst, nextKey)) == null) {
                    info.setString(LAST_BLOCK, docKey.toString());
                }
                if (nextKey != null) {
                    SchematicEntry nextEntry = this.database.get(nextKey);
                    doc = nextEntry.editDocumentContent();
                    docKey = new NodeKey(nextKey);
                    continue;
                }
                doc = null;
            }
        }
    }

    protected boolean splitChildren(NodeKey key, EditableDocument document, EditableArray children, int targetCountPerBlock, int tolerance, boolean isFirst, String nextBlock) {
        String firstNewBlockKey;
        assert (0 < targetCountPerBlock);
        assert (0 < tolerance);
        assert (tolerance < targetCountPerBlock);
        int total = children.size();
        int numFullBlocks = total / targetCountPerBlock;
        if (numFullBlocks == 0) {
            return false;
        }
        int sizeOfLastBlock = total % targetCountPerBlock;
        if (sizeOfLastBlock < targetCountPerBlock - tolerance) {
            if (numFullBlocks == 1) {
                return false;
            }
            sizeOfLastBlock = 0;
        }
        int startIndex = targetCountPerBlock;
        int endIndex = 0;
        String blockKey = firstNewBlockKey = key.withRandomId().toString();
        for (int n = 1; n != numFullBlocks; ++n) {
            String nextBlockKey;
            boolean isLast = n == numFullBlocks - 1;
            endIndex = isLast ? total : startIndex + targetCountPerBlock;
            EditableArray blockChildren = Schematic.newArray((Collection)children.subList(startIndex, endIndex));
            nextBlockKey = isLast ? (nextBlockKey = nextBlock) : key.withRandomId().toString();
            EditableDocument blockDoc = Schematic.newDocument();
            EditableDocument childInfo = blockDoc.setDocument(CHILDREN_INFO);
            childInfo.setNumber(BLOCK_SIZE, blockChildren.size());
            if (nextBlockKey != null) {
                childInfo.setString(NEXT_BLOCK, nextBlockKey.toString());
            }
            blockDoc.setArray(CHILDREN, (Array)blockChildren);
            this.database.put(blockKey, (Document)blockDoc, null);
            if (isLast) continue;
            blockKey = nextBlockKey;
            startIndex = endIndex;
        }
        EditableArray newChildren = Schematic.newArray((Collection)children.subList(0, targetCountPerBlock));
        document.setArray(CHILDREN, (Array)newChildren);
        EditableDocument childInfo = document.getDocument(CHILDREN_INFO);
        if (childInfo == null) {
            childInfo = document.setDocument(CHILDREN_INFO);
        }
        childInfo.setNumber(BLOCK_SIZE, newChildren.size());
        childInfo.setString(NEXT_BLOCK, firstNewBlockKey);
        if (isFirst && nextBlock == null) {
            childInfo.setString(LAST_BLOCK, blockKey);
        }
        return true;
    }

    protected String mergeChildren(NodeKey key, EditableDocument document, EditableArray children, boolean isFirst, String nextBlock) {
        EditableDocument info = document.getDocument(CHILDREN_INFO);
        if (info == null) {
            info = document.setDocument(CHILDREN_INFO);
        }
        HashSet<String> toBeDeleted = new HashSet<String>();
        SchematicEntry nextEntry = null;
        String nextBlocksNext = null;
        while (nextBlock != null) {
            nextEntry = this.database.get(nextBlock);
            Document nextDoc = nextEntry.getContentAsDocument();
            List nextChildren = nextDoc.getArray(CHILDREN);
            Document nextInfo = nextDoc.getDocument(CHILDREN_INFO);
            if (nextChildren == null || nextChildren.isEmpty()) {
                toBeDeleted.add(nextBlock);
                nextEntry = null;
                nextBlock = nextInfo != null ? nextInfo.getString(NEXT_BLOCK) : null;
                continue;
            }
            children.addAll((Collection)nextChildren);
            String string = nextBlocksNext = nextInfo != null ? nextInfo.getString(NEXT_BLOCK) : null;
            if (isFirst && nextBlocksNext == null) {
                info.setNumber(COUNT, children.size());
                info.remove(NEXT_BLOCK);
                info.remove(LAST_BLOCK);
            } else {
                info.setNumber(BLOCK_SIZE, children.size());
                info.setString(NEXT_BLOCK, nextBlocksNext);
            }
            toBeDeleted.add(nextBlock);
            nextBlock = null;
        }
        for (String deleteKey : toBeDeleted) {
            this.database.remove(deleteKey);
        }
        return nextBlocksNext;
    }

    public boolean isLocked(EditableDocument doc) {
        return this.hasProperty((Document)doc, JcrLexicon.LOCK_OWNER) || this.hasProperty((Document)doc, JcrLexicon.LOCK_IS_DEEP);
    }

    @Immutable
    public static class ChildReferencesInfo {
        public final long totalSize;
        public final long blockSize;
        public final String nextKey;
        public final String lastKey;

        public ChildReferencesInfo(long totalSize, long blockSize, String nextKey, String lastKey) {
            this.totalSize = totalSize;
            this.blockSize = blockSize;
            this.nextKey = nextKey;
            this.lastKey = lastKey;
        }

        public String toString() {
            return "totalSize: " + this.totalSize + "; blockSize: " + this.blockSize + "; nextKey: " + this.nextKey + "; lastKey: " + this.lastKey;
        }
    }
}

