/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.Collections;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.validate.Schemata;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;

@NotThreadSafe
public class JcrQueryResult
implements QueryResult {
    public static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    public static final String JCR_PATH_COLUMN_NAME = "jcr:path";
    public static final String JCR_NAME_COLUMN_NAME = "jcr:name";
    public static final String MODE_LOCALNAME_COLUMN_NAME = "mode:localName";
    public static final String MODE_DEPTH_COLUMN_NAME = "mode:depth";
    protected static final Set<String> PSEUDO_COLUMNS = Collections.unmodifiableSet((Object[])new String[]{"jcr:score", "jcr:path", "jcr:name", "mode:localName", "mode:depth"});
    protected final JcrQueryContext context;
    protected final QueryResults results;
    protected final Schemata schemata;
    protected final String queryStatement;
    private List<String> columnTables;

    protected JcrQueryResult(JcrQueryContext context, String query, QueryResults graphResults, Schemata schemata) {
        this.context = context;
        this.results = graphResults;
        this.schemata = schemata;
        this.queryStatement = query;
        assert (this.context != null);
        assert (this.results != null);
        assert (this.schemata != null);
        assert (this.queryStatement != null);
    }

    protected QueryResults results() {
        return this.results;
    }

    public List<String> getColumnNameList() {
        return this.results.getColumns().getColumnNames();
    }

    public List<String> getColumnTypeList() {
        return this.results.getColumns().getColumnTypes();
    }

    public String[] getColumnNames() {
        List<String> names = this.getColumnNameList();
        return names.toArray(new String[names.size()]);
    }

    public String[] getColumnTypes() {
        List<String> types = this.getColumnTypeList();
        return types.toArray(new String[types.size()]);
    }

    public String[] getSelectorNames() {
        if (this.columnTables == null) {
            QueryResults.Columns columns = this.results.getColumns();
            HashSet<SelectorName> selectorNames = new HashSet<SelectorName>();
            ArrayList<String> tables = new ArrayList<String>(columns.getColumnCount());
            for (Column column : columns) {
                SelectorName selectorName = column.selectorName();
                if (!selectorNames.add(column.selectorName())) continue;
                tables.add(selectorName.getString());
            }
            this.columnTables = tables;
        }
        return this.columnTables.toArray(new String[this.columnTables.size()]);
    }

    public NodeIterator getNodes() throws RepositoryException {
        if (this.getSelectorNames().length > 1) {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryUnableToCallMethod.text(new Object[]{this.queryStatement}));
        }
        int numRows = this.results.getRowCount();
        if (numRows == 0) {
            return this.context.emptyNodeIterator();
        }
        ArrayList<Node> nodes = new ArrayList<Node>(numRows);
        String selectorName = this.results.getColumns().getSelectorNames().get(0);
        int locationIndex = this.results.getColumns().getLocationIndex(selectorName);
        for (Object[] tuple : this.results.getTuples()) {
            QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
            Node node = this.context.getNode(location);
            if (node == null) continue;
            nodes.add(node);
        }
        return new QueryResultNodeIterator(nodes);
    }

    public RowIterator getRows() {
        int numRows = this.results.getRowCount();
        List<Object[]> tuples = this.results.getTuples();
        if (this.results.getColumns().getLocationCount() == 1) {
            return new SingleSelectorQueryResultRowIterator(this.context, this.queryStatement, this.results, tuples.iterator(), numRows);
        }
        return new QueryResultRowIterator(this.context, this.queryStatement, this.results, tuples.iterator(), numRows);
    }

    public String getPlan() {
        return this.results.getPlan();
    }

    public String toString() {
        return this.results.toString();
    }

    protected static class MultiSelectorQueryResultRow
    implements Row {
        protected final QueryResultRowIterator iterator;
        protected final Object[] tuple;
        private Value[] values = null;
        private Node[] nodes;

        protected MultiSelectorQueryResultRow(QueryResultRowIterator iterator, Node[] nodes, int[] locationIndexes, Object[] tuple) {
            this.iterator = iterator;
            this.tuple = tuple;
            this.nodes = nodes;
            assert (this.iterator != null);
            assert (this.tuple != null);
        }

        public Node getNode(String selectorName) throws RepositoryException {
            int nodeIndex = this.iterator.columns.getSelectorNames().indexOf(selectorName);
            if (nodeIndex == -1) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.nodes[nodeIndex];
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            String selectorName = this.iterator.columns.getSelectorNameForColumnName(columnName);
            int nodeIndex = this.iterator.columns.getSelectorNames().indexOf(selectorName);
            if (nodeIndex == -1) {
                throw new RepositoryException(JcrI18n.queryResultsDoNotIncludeColumn.text(new Object[]{columnName, this.iterator.query}));
            }
            Node node = this.nodes[nodeIndex];
            if (node == null) {
                return null;
            }
            String propertyName = this.iterator.getPropertyNameForColumnName(columnName);
            if (PSEUDO_COLUMNS.contains(propertyName)) {
                int locationIndex = this.iterator.columns.getLocationIndexForColumn(columnName);
                if (JcrQueryResult.JCR_PATH_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[locationIndex];
                    return this.iterator.jcrPath(location.getPath());
                }
                if (JcrQueryResult.JCR_NAME_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[locationIndex];
                    Path path = location.getPath();
                    if (path.isRoot()) {
                        return this.iterator.jcrName();
                    }
                    return this.iterator.jcrName(path.getLastSegment().getName());
                }
                if (JcrQueryResult.MODE_LOCALNAME_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[locationIndex];
                    Path path = location.getPath();
                    if (path.isRoot()) {
                        return this.iterator.jcrString("");
                    }
                    return this.iterator.jcrString(path.getLastSegment().getName().getLocalName());
                }
                if (JcrQueryResult.MODE_DEPTH_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[locationIndex];
                    Path path = location.getPath();
                    Long depth = new Long(path.size());
                    return this.iterator.jcrLong(depth);
                }
                if (JcrQueryResult.JCR_SCORE_COLUMN_NAME.equals(propertyName)) {
                    int scoreIndex = this.iterator.columns.getFullTextSearchScoreIndexFor(columnName);
                    Float score = Float.valueOf(scoreIndex == -1 ? 0.0f : ((Float)this.tuple[scoreIndex]).floatValue());
                    return this.iterator.jcrDouble(score);
                }
            }
            if (!node.hasProperty(propertyName)) {
                return null;
            }
            Property property = node.getProperty(propertyName);
            Value value = null;
            value = property.isMultiple() ? property.getValues()[0] : property.getValue();
            return value;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }

        public Node getNode() throws RepositoryException {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryRequireSpecifyingSelectorName.text(new Object[]{this.iterator.query}));
        }

        public String getPath() throws RepositoryException {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryRequireSpecifyingSelectorName.text(new Object[]{this.iterator.query}));
        }

        public double getScore() throws RepositoryException {
            throw new RepositoryException(JcrI18n.multipleSelectorsAppearInQueryRequireSpecifyingSelectorName.text(new Object[]{this.iterator.query}));
        }

        public String getPath(String selectorName) throws RepositoryException {
            return this.getNode(selectorName).getPath();
        }

        public double getScore(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            int scoreIndex = this.iterator.columns.getFullTextSearchScoreIndexFor(selectorName);
            if (scoreIndex == -1) {
                throw new RepositoryException(JcrI18n.queryResultsDoNotIncludeScore.text(new Object[]{this.iterator.query}));
            }
            Object score = this.tuple[scoreIndex];
            return score instanceof Float ? ((Float)score).doubleValue() : ((Double)score).doubleValue();
        }
    }

    protected static class SingleSelectorQueryResultRow
    implements Row {
        protected final SingleSelectorQueryResultRowIterator iterator;
        protected final Node node;
        protected final Object[] tuple;
        private Value[] values = null;

        protected SingleSelectorQueryResultRow(SingleSelectorQueryResultRowIterator iterator, Node node, Object[] tuple) {
            this.iterator = iterator;
            this.node = node;
            this.tuple = tuple;
            assert (this.iterator != null);
            assert (this.node != null);
            assert (this.tuple != null);
        }

        public Node getNode(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.node;
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            String propertyName = this.iterator.getPropertyNameForColumnName(columnName);
            if (PSEUDO_COLUMNS.contains(propertyName)) {
                if (JcrQueryResult.JCR_PATH_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[this.iterator.locationIndex];
                    return this.iterator.jcrPath(location.getPath());
                }
                if (JcrQueryResult.JCR_NAME_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[this.iterator.locationIndex];
                    Path path = location.getPath();
                    if (path.isRoot()) {
                        return this.iterator.jcrName();
                    }
                    return this.iterator.jcrName(path.getLastSegment().getName());
                }
                if (JcrQueryResult.MODE_LOCALNAME_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[this.iterator.locationIndex];
                    Path path = location.getPath();
                    if (path.isRoot()) {
                        return this.iterator.jcrString("");
                    }
                    return this.iterator.jcrString(path.getLastSegment().getName().getLocalName());
                }
                if (JcrQueryResult.MODE_DEPTH_COLUMN_NAME.equals(propertyName)) {
                    QueryResults.Location location = (QueryResults.Location)this.tuple[this.iterator.locationIndex];
                    Path path = location.getPath();
                    Long depth = new Long(path.size());
                    return this.iterator.jcrLong(depth);
                }
                if (JcrQueryResult.JCR_SCORE_COLUMN_NAME.equals(propertyName)) {
                    Float score = Float.valueOf(this.iterator.scoreIndex == -1 ? 0.0f : ((Float)this.tuple[this.iterator.scoreIndex]).floatValue());
                    return this.iterator.jcrDouble(score);
                }
            }
            if (!this.node.hasProperty(propertyName)) {
                return null;
            }
            Property property = this.node.getProperty(propertyName);
            Value value = null;
            value = property.isMultiple() ? property.getValues()[0] : property.getValue();
            return value;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }

        public Node getNode() {
            return this.node;
        }

        public String getPath() throws RepositoryException {
            return this.node.getPath();
        }

        public String getPath(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.node.getPath();
        }

        public double getScore() throws RepositoryException {
            int index = this.iterator.scoreIndex;
            if (index == -1) {
                throw new RepositoryException(JcrI18n.queryResultsDoNotIncludeScore.text(new Object[]{this.iterator.query}));
            }
            Object score = this.tuple[index];
            return score instanceof Float ? ((Float)score).doubleValue() : ((Double)score).doubleValue();
        }

        public double getScore(String selectorName) throws RepositoryException {
            if (!this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.getScore();
        }
    }

    @NotThreadSafe
    protected static class SingleSelectorQueryResultRowIterator
    extends QueryResultRowIterator {
        protected final int locationIndex;
        protected final int scoreIndex;

        protected SingleSelectorQueryResultRowIterator(JcrQueryContext context, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            super(context, query, results, tuples, numRows);
            String selectorName = this.columns.getSelectorNames().get(0);
            this.locationIndex = this.columns.getLocationIndex(selectorName);
            this.scoreIndex = this.columns.getFullTextSearchScoreIndexFor(selectorName);
        }

        @Override
        protected Row getNextRow(Object[] tuple) throws RepositoryException {
            QueryResults.Location location = (QueryResults.Location)tuple[this.locationIndex];
            Node node = this.context.getNode(location);
            return node != null ? this.createRow(node, tuple) : null;
        }

        protected Row createRow(Node node, Object[] tuple) {
            return new SingleSelectorQueryResultRow(this, node, tuple);
        }
    }

    @NotThreadSafe
    protected static class QueryResultRowIterator
    implements RowIterator {
        protected final List<String> columnNames;
        private final Iterator<Object[]> tuples;
        private final Set<String> selectorNames;
        protected final JcrQueryContext context;
        protected final QueryResults.Columns columns;
        protected final String query;
        private int[] locationIndexes;
        private long position = 0L;
        private long numRows;
        private Row nextRow;

        protected QueryResultRowIterator(JcrQueryContext context, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            this.tuples = tuples;
            this.query = query;
            this.columns = results.getColumns();
            this.columnNames = this.columns.getColumnNames();
            this.context = context;
            this.numRows = numRows;
            this.selectorNames = new HashSet<String>(this.columns.getSelectorNames());
            int i = 0;
            List<String> columnSelectorNames = this.columns.getSelectorNames();
            this.locationIndexes = new int[columnSelectorNames.size()];
            for (String selectorName : columnSelectorNames) {
                this.locationIndexes[i++] = this.columns.getLocationIndex(selectorName);
            }
        }

        public boolean hasSelector(String selectorName) {
            return this.selectorNames.contains(selectorName);
        }

        public Row nextRow() {
            if (this.nextRow == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.nextRow != null);
            Row result = this.nextRow;
            this.nextRow = null;
            return result;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.numRows;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.tuples.next();
            }
            this.position += skipNum;
        }

        public boolean hasNext() {
            if (this.nextRow != null) {
                return true;
            }
            while (this.tuples.hasNext()) {
                Object[] tuple = this.tuples.next();
                ++this.position;
                try {
                    this.nextRow = this.getNextRow(tuple);
                    if (this.nextRow != null) {
                        return true;
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                --this.numRows;
            }
            return false;
        }

        protected Row getNextRow(Object[] tuple) throws RepositoryException {
            Node[] nodes = new Node[this.locationIndexes.length];
            int index = 0;
            boolean foundAtLeastOneNode = false;
            for (int locationIndex : this.locationIndexes) {
                QueryResults.Location location = (QueryResults.Location)tuple[locationIndex];
                Node node = this.context.getNode(location);
                if (node != null) {
                    foundAtLeastOneNode = true;
                }
                nodes[index++] = node;
            }
            if (!foundAtLeastOneNode) {
                return null;
            }
            return new MultiSelectorQueryResultRow(this, nodes, this.locationIndexes, tuple);
        }

        protected String getPropertyNameForColumnName(String columnName) {
            return this.columns.getPropertyNameForColumnName(columnName);
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected Value jcrPath(Path path) {
            return this.context.createValue(8, path);
        }

        protected Value jcrName(Name name) {
            return this.context.createValue(7, name);
        }

        protected Value jcrName() {
            return this.context.createValue(7, "");
        }

        protected Value jcrString(String name) {
            return this.context.createValue(1, name);
        }

        protected Value jcrLong(Long value) {
            return this.context.createValue(3, value);
        }

        protected Value jcrDouble(Float score) {
            return this.context.createValue(4, score);
        }
    }

    @NotThreadSafe
    protected static class QueryResultNodeIterator
    implements NodeIterator {
        private final Iterator<? extends Node> nodes;
        private final int size;
        private long position = 0L;

        protected QueryResultNodeIterator(List<? extends Node> nodes) {
            this.nodes = nodes.iterator();
            this.size = nodes.size();
        }

        public Node nextNode() {
            Node node = this.nodes.next();
            ++this.position;
            return node;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.nextNode();
            }
        }

        public boolean hasNext() {
            return this.nodes.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

