/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class SizeMeasuringInputStream
extends InputStream {
    private final InputStream stream;
    private final AtomicLong size;

    public SizeMeasuringInputStream(InputStream stream, AtomicLong size) {
        this.stream = stream;
        this.size = size;
    }

    @Override
    public int read() throws IOException {
        int result = this.stream.read();
        if (result != -1) {
            this.size.addAndGet(1L);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.stream.read(b, off, len);
        if (n != -1) {
            this.size.addAndGet(n);
        }
        return n;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int n = this.stream.read(b);
        if (n != -1) {
            this.size.addAndGet(n);
        }
        return n;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.stream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

