/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;

@ThreadSafe
class JcrNode
extends AbstractJcrNode {
    JcrNode(JcrSession session, NodeKey nodeKey) {
        super(session, nodeKey);
    }

    @Override
    final boolean isRoot() {
        return false;
    }

    @Override
    AbstractJcrNode.Type type() {
        return AbstractJcrNode.Type.NODE;
    }

    @Override
    public int getIndex() throws RepositoryException {
        return this.segment().getIndex();
    }

    public String getName() throws RepositoryException {
        return this.segment().getName().getString(this.namespaces());
    }

    @Override
    public AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException {
        this.checkSession();
        NodeKey parentKey = this.node().getParentKey(this.sessionCache());
        return this.session().node(parentKey, null);
    }

    public String getPath() throws RepositoryException {
        return this.path().getString(this.namespaces());
    }

    @Override
    protected void doRemove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        SessionCache cache = this.sessionCache();
        NodeKey key = this.key();
        MutableCachedNode parent = this.mutableParent();
        parent.removeChild(cache, key);
        cache.destroy(key);
    }
}

