/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.identitytrust;

import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.identitytrust.IdentityTrustContext;
import org.jboss.security.identitytrust.IdentityTrustException;
import org.jboss.security.identitytrust.IdentityTrustManager;
import org.jboss.security.identitytrust.JBossIdentityTrustContext;

public class JBossIdentityTrustManager
implements IdentityTrustManager {
    protected static Logger log = Logger.getLogger(JBossIdentityTrustManager.class);
    protected boolean trace = log.isTraceEnabled();
    private String securityDomain = null;
    private IdentityTrustContext identityTrustContext = null;

    public JBossIdentityTrustManager(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void setIdentityTrustContext(IdentityTrustContext itc) {
        if (itc == null) {
            throw new IllegalArgumentException("PB00014: Null Argument:null Identity Trust Context");
        }
        this.identityTrustContext = itc;
    }

    public IdentityTrustManager.TrustDecision isTrusted(SecurityContext securityContext) {
        IdentityTrustManager.TrustDecision td;
        block5: {
            if (securityContext == null) {
                throw new IllegalArgumentException("PB00014: Null Argument:Security Context is null");
            }
            if (this.identityTrustContext == null) {
                this.identityTrustContext = new JBossIdentityTrustContext(this.securityDomain, securityContext);
            }
            td = IdentityTrustManager.TrustDecision.NotApplicable;
            if (this.identityTrustContext == null) {
                throw new IllegalStateException("PB00015: Null Value:IdentityTrustContext is null");
            }
            try {
                td = this.identityTrustContext.isTrusted();
            }
            catch (IdentityTrustException e) {
                if (!this.trace) break block5;
                log.trace((Object)"Trust Exception:", (Throwable)e);
            }
        }
        return td;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }
}

