/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;

public class ExpirationConfigurationBuilder
extends AbstractConfigurationChildBuilder<ExpirationConfiguration> {
    private long lifespan = -1L;
    private long maxIdle = -1L;
    private boolean reaperEnabled = true;
    private long wakeUpInterval = TimeUnit.MINUTES.toMillis(1L);

    ExpirationConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public ExpirationConfigurationBuilder lifespan(long l) {
        this.lifespan = l;
        return this;
    }

    public ExpirationConfigurationBuilder maxIdle(long l) {
        this.maxIdle = l;
        return this;
    }

    public ExpirationConfigurationBuilder enableReaper() {
        this.reaperEnabled = true;
        return this;
    }

    public ExpirationConfigurationBuilder reaperEnabled(boolean enabled) {
        this.reaperEnabled = enabled;
        return this;
    }

    public ExpirationConfigurationBuilder disableReaper() {
        this.reaperEnabled = false;
        return this;
    }

    public ExpirationConfigurationBuilder wakeUpInterval(long l) {
        this.wakeUpInterval = l;
        return this;
    }

    @Override
    void validate() {
    }

    @Override
    ExpirationConfiguration create() {
        return new ExpirationConfiguration(this.lifespan, this.maxIdle, this.reaperEnabled, this.wakeUpInterval);
    }

    public ExpirationConfigurationBuilder read(ExpirationConfiguration template) {
        this.lifespan = template.lifespan();
        this.maxIdle = template.maxIdle();
        this.reaperEnabled = template.reaperEnabled();
        this.wakeUpInterval = template.wakeUpInterval();
        return this;
    }

    public String toString() {
        return "ExpirationConfigurationBuilder{lifespan=" + this.lifespan + ", maxIdle=" + this.maxIdle + ", reaperEnabled=" + this.reaperEnabled + ", wakeUpInterval=" + this.wakeUpInterval + '}';
    }
}

