/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.i18n;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.modeshape.common.util.CheckArg;

public final class ClasspathLocalizationRepository {
    private ClasspathLocalizationRepository() {
    }

    public static URL getLocalizationBundle(ClassLoader classLoader, String bundleName, Locale locale) {
        CheckArg.isNotNull(classLoader, "classLoader");
        URL url = null;
        List<String> paths = ClasspathLocalizationRepository.getPathsToSearchForBundle(bundleName, locale);
        for (String path : paths) {
            url = classLoader.getResource(path);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    static List<String> getPathsToSearchForBundle(String bundleName, Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        String pathPrefix = bundleName.replaceAll("\\.", "/");
        String localeVariant = '_' + locale.toString();
        int ndx = localeVariant.lastIndexOf(95);
        while (ndx >= 0) {
            String path = pathPrefix + localeVariant + ".properties";
            result.add(path);
            localeVariant = localeVariant.substring(0, ndx);
            ndx = localeVariant.lastIndexOf(95);
        }
        result.add(pathPrefix + localeVariant + ".properties");
        return result;
    }
}

