/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.util.Map;
import javax.jcr.Credentials;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.jcr.security.SecurityContext;

public class ServletProvider
implements AuthenticationProvider {
    @Override
    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        ServletCredentials creds;
        HttpServletRequest request;
        if (credentials instanceof ServletCredentials && (request = (creds = (ServletCredentials)credentials).getRequest()) != null) {
            return repositoryContext.with(new ServletSecurityContext(request));
        }
        return null;
    }

    protected static class ServletSecurityContext
    implements SecurityContext {
        private HttpServletRequest request;
        private final String username;

        protected ServletSecurityContext(HttpServletRequest request) {
            this.request = request;
            this.username = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        }

        @Override
        public boolean isAnonymous() {
            return false;
        }

        @Override
        public final String getUserName() {
            return this.username;
        }

        @Override
        public final boolean hasRole(String roleName) {
            return this.request != null && this.request.isUserInRole(roleName);
        }

        @Override
        public void logout() {
            this.request = null;
        }
    }
}

