/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.BoundedList;

public class TCPPING
extends Discovery {
    @Property(description="Number of additional ports to be probed for membership. A port_range of 0 does not probe additional ports. Example: initial_hosts=A[7800] port_range=0 probes A:7800, port_range=1 probes A:7800 and A:7801")
    private int port_range = 1;
    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts.class, dependsUpon="port_range", systemProperty={"jgroups.tcpping.initial_hosts"})
    private List<IpAddress> initial_hosts = null;
    @Property(description="max number of hosts to keep beyond the ones in initial_hosts")
    protected int max_dynamic_hosts = 100;
    protected final BoundedList<PhysicalAddress> dynamic_hosts = new BoundedList(this.max_dynamic_hosts);

    @Override
    public boolean isDynamic() {
        return false;
    }

    public List<IpAddress> getInitialHosts() {
        return this.initial_hosts;
    }

    public void setInitialHosts(List<IpAddress> initial_hosts) {
        this.initial_hosts = initial_hosts;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public void setPortRange(int port_range) {
        this.port_range = port_range;
    }

    @ManagedAttribute
    public String getDynamicHostList() {
        return this.dynamic_hosts.toString();
    }

    @ManagedOperation
    public void clearDynamicHostList() {
        this.dynamic_hosts.clear();
    }

    @ManagedAttribute
    public String getInitialHostsList() {
        return this.initial_hosts.toString();
    }

    @Override
    public Collection<PhysicalAddress> fetchClusterMembers(String cluster_name) {
        HashSet<PhysicalAddress> combined_target_members = new HashSet<PhysicalAddress>(this.initial_hosts);
        combined_target_members.addAll(this.dynamic_hosts);
        return combined_target_members;
    }

    @Override
    public boolean sendDiscoveryRequestsInParallel() {
        return true;
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 6: {
                for (Address logical_addr : this.members) {
                    PhysicalAddress physical_addr = (PhysicalAddress)this.down_prot.down(new Event(87, logical_addr));
                    if (physical_addr == null || this.initial_hosts.contains(physical_addr)) continue;
                    this.dynamic_hosts.addIfAbsent(physical_addr);
                }
                break;
            }
        }
        return retval;
    }

    @Override
    public void discoveryRequestReceived(Address sender, String logical_name, Collection<PhysicalAddress> physical_addrs) {
        super.discoveryRequestReceived(sender, logical_name, physical_addrs);
        if (physical_addrs != null) {
            for (PhysicalAddress addr : physical_addrs) {
                if (this.initial_hosts.contains(addr)) continue;
                this.dynamic_hosts.addIfAbsent(addr);
            }
        }
    }
}

