/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.Version;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.VersionAwareMarshaller;

public class SerializationConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<SerializationConfiguration> {
    private Marshaller marshaller = new VersionAwareMarshaller();
    private short marshallVersion = Short.valueOf("5.1".replace(".", ""));
    private Map<Integer, AdvancedExternalizer<?>> advancedExternalizers = new HashMap();

    SerializationConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public SerializationConfigurationBuilder marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public SerializationConfigurationBuilder version(short marshallVersion) {
        this.marshallVersion = marshallVersion;
        return this;
    }

    public SerializationConfigurationBuilder version(String marshallVersion) {
        this.marshallVersion = Version.getVersionShort(marshallVersion);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(int id, AdvancedExternalizer<T> advancedExternalizer) {
        this.advancedExternalizers.put(id, advancedExternalizer);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> advancedExternalizer) {
        this.addAdvancedExternalizer(advancedExternalizer.getId(), advancedExternalizer);
        return this;
    }

    public <T> SerializationConfigurationBuilder addAdvancedExternalizer(AdvancedExternalizer<T> ... advancedExternalizers) {
        for (AdvancedExternalizer<T> advancedExternalizer : advancedExternalizers) {
            this.addAdvancedExternalizer(advancedExternalizer);
        }
        return this;
    }

    @Override
    protected void validate() {
    }

    @Override
    SerializationConfiguration create() {
        return new SerializationConfiguration(this.marshaller, this.marshallVersion, this.advancedExternalizers);
    }

    SerializationConfigurationBuilder read(SerializationConfiguration template) {
        this.advancedExternalizers = template.advancedExternalizers();
        this.marshaller = template.marshaller();
        this.marshallVersion = template.version();
        return this;
    }

    public String toString() {
        return "SerializationConfigurationBuilder{advancedExternalizers=" + this.advancedExternalizers + ", marshaller=" + this.marshaller + ", marshallVersion=" + this.marshallVersion + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializationConfigurationBuilder that = (SerializationConfigurationBuilder)o;
        if (this.marshallVersion != that.marshallVersion) {
            return false;
        }
        if (this.advancedExternalizers != null ? !((Object)this.advancedExternalizers).equals(that.advancedExternalizers) : that.advancedExternalizers != null) {
            return false;
        }
        return !(this.marshaller != null ? !this.marshaller.equals(that.marshaller) : that.marshaller != null);
    }

    public int hashCode() {
        int result = this.marshaller != null ? this.marshaller.hashCode() : 0;
        result = 31 * result + this.marshallVersion;
        result = 31 * result + (this.advancedExternalizers != null ? ((Object)this.advancedExternalizers).hashCode() : 0);
        return result;
    }
}

