/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collection;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;

public class LocalDocumentStore
implements DocumentStore {
    private final SchematicDb database;
    private String localSourceKey;

    public LocalDocumentStore(SchematicDb database) {
        this.database = database;
    }

    @Override
    public boolean containsKey(String key) {
        return this.database.containsKey(key);
    }

    @Override
    public SchematicEntry get(String key) {
        return this.database.get(key);
    }

    @Override
    public SchematicEntry storeDocument(String key, Document document) {
        return this.putIfAbsent(key, document);
    }

    @Override
    public void updateDocument(String key, Document document, SessionNode sessionNode) {
    }

    @Override
    public String newDocumentKey(String parentKey, Name documentName) {
        return null;
    }

    public SchematicEntry putIfAbsent(String key, Document document) {
        return this.database.putIfAbsent(key, document, null);
    }

    public void put(String key, Document document) {
        this.database.put(key, document, null);
    }

    public void put(Document entryDocument) {
        this.database.put(entryDocument);
    }

    public void replace(String key, Document document) {
        this.database.replace(key, document, null);
    }

    @Override
    public boolean remove(String key) {
        return this.database.remove(key) != null;
    }

    @Override
    public boolean prepareDocumentsForUpdate(Collection<String> keys) {
        return this.database.lock(keys);
    }

    @Override
    public boolean updatesRequirePreparing() {
        return this.database.isExplicitLockingEnabled();
    }

    @Override
    public LocalDocumentStore localStore() {
        return this;
    }

    @Override
    public TransactionManager transactionManager() {
        return this.localCache().getAdvancedCache().getTransactionManager();
    }

    @Override
    public XAResource xaResource() {
        return this.localCache().getAdvancedCache().getXAResource();
    }

    @Override
    public void setLocalSourceKey(String sourceKey) {
        this.localSourceKey = sourceKey;
    }

    @Override
    public String getLocalSourceKey() {
        return this.localSourceKey;
    }

    @Override
    public String createExternalProjection(String projectedNodeKey, String sourceName, String externalPath, String alias) {
        throw new UnsupportedOperationException("External projections are not supported in the local document store");
    }

    @Override
    public Document getChildrenBlock(String key) {
        SchematicEntry entry = this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getContentAsDocument();
    }

    @Override
    public Document getChildReference(String parentKey, String childKey) {
        return null;
    }

    public Cache<String, SchematicEntry> localCache() {
        return this.database.getCache();
    }

    @Override
    public ExternalBinaryValue getExternalBinary(String sourceName, String id) {
        throw new UnsupportedOperationException("External binaries are only supported by the federated document store");
    }
}

