/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.SingleIterator;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.value.InvalidPathException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.basic.AbstractPath;
import org.modeshape.jcr.value.basic.BasicPath;
import org.modeshape.jcr.value.basic.IdentifierPathSegment;
import org.modeshape.jcr.value.basic.RootPath;

@Immutable
public class IdentifierPath
extends AbstractPath {
    private static final long serialVersionUID = 1L;
    private final IdentifierPathSegment idSegment;
    private transient List<Path.Segment> segments;

    public IdentifierPath(IdentifierPathSegment idSegment) {
        this.idSegment = idSegment;
    }

    @Override
    public Path getAncestor(int degree) {
        CheckArg.isNonNegative((int)degree, (String)"degree");
        if (degree == 0) {
            return this;
        }
        String msg = GraphI18n.pathAncestorDegreeIsInvalid.text(new Object[]{this.getString(), Inflector.getInstance().ordinalize(degree)});
        throw new InvalidPathException(msg);
    }

    @Override
    protected Iterator<Path.Segment> getSegmentsOfParent() {
        return new SingleIterator((Object)this.idSegment);
    }

    @Override
    public Path getCanonicalPath() {
        return this;
    }

    @Override
    public Path getCommonAncestor(Path that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        return this.equals(that) ? this : RootPath.INSTANCE;
    }

    @Override
    public Path.Segment getLastSegment() {
        return this.idSegment;
    }

    @Override
    public boolean endsWith(Name nameOfLastSegment) {
        return this.idSegment.getName().equals(nameOfLastSegment);
    }

    @Override
    public boolean endsWith(Name nameOfLastSegment, int snsIndex) {
        return snsIndex == 1 && this.idSegment.getName().equals(nameOfLastSegment);
    }

    @Override
    public Path getNormalizedPath() {
        return this;
    }

    @Override
    public Path relativeToRoot() {
        return new BasicPath(this.getSegmentsList(), false);
    }

    @Override
    public Path getParent() {
        return RootPath.INSTANCE;
    }

    @Override
    public Path.Segment getSegment(int index) {
        CheckArg.isNonNegative((int)index, (String)"index");
        if (index == 0) {
            return this.idSegment;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Path.Segment[] getSegmentsArray() {
        return new Path.Segment[]{this.idSegment};
    }

    @Override
    public List<Path.Segment> getSegmentsList() {
        if (this.segments == null) {
            this.segments = Collections.singletonList(this.idSegment);
        }
        return this.segments;
    }

    @Override
    public String getString() {
        return this.idSegment.getString();
    }

    @Override
    public String getString(TextEncoder encoder) {
        return this.idSegment.getString(encoder);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return this.idSegment.getString(namespaceRegistry);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        CheckArg.isNotNull((Object)namespaceRegistry, (String)"namespaceRegistry");
        return this.idSegment.getString(namespaceRegistry, encoder);
    }

    @Override
    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        return delimiterEncoder == null ? this.getString(namespaceRegistry, encoder) : delimiterEncoder.encode(this.getString(namespaceRegistry, encoder));
    }

    @Override
    public boolean hasSameAncestor(Path that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        return true;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isIdentifier() {
        return true;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isSameAs(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        return other.isIdentifier() && this.idSegment.equals(other.getLastSegment());
    }

    @Override
    public boolean isAncestorOf(Path descendant) {
        CheckArg.isNotNull((Object)descendant, (String)"descendant");
        return false;
    }

    @Override
    public boolean isDescendantOf(Path ancestor) {
        CheckArg.isNotNull((Object)ancestor, (String)"ancestor");
        return false;
    }

    @Override
    public boolean isAtOrAbove(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        return this.isSameAs(other);
    }

    @Override
    public boolean isAtOrBelow(Path other) {
        CheckArg.isNotNull((Object)other, (String)"other");
        return this.isSameAs(other);
    }

    @Override
    public Path resolve(Path relativePath) {
        CheckArg.isNotNull((Object)relativePath, (String)"relative path");
        String msg = GraphI18n.unableToResolvePathRelativeToIdentifierPath.text(new Object[]{relativePath, this});
        throw new InvalidPathException(msg);
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return new SingleIterator((Object)this.idSegment);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Path subpath(int beginIndex) {
        CheckArg.isNonNegative((int)beginIndex, (String)"beginIndex");
        if (beginIndex == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        CheckArg.isNonNegative((int)beginIndex, (String)"beginIndex");
        CheckArg.isNonNegative((int)endIndex, (String)"endIndex");
        if (beginIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
        if (endIndex >= 1) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public int compareTo(Path other) {
        return other.isIdentifier() ? this.idSegment.compareTo(other.getLastSegment()) : super.compareTo(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path that = (Path)obj;
            return that.isIdentifier() && this.idSegment.equals(that.getLastSegment());
        }
        return false;
    }
}

