/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.util.EnumSet;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Version;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.interceptors.IsMarshallableInterceptor;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class CacheContext {
    private static final Log LOGGER = LogFactory.getLog(CacheContext.class);
    private final AdvancedCache<String, SchematicEntry> cache;
    private final AdvancedCache<String, SchematicEntry> cacheForWriting;
    private final AdvancedCache<String, SchematicEntry> cacheForLocking;
    private final TransactionManager txnMgr;
    private final TransactionTable transactionTable;
    private final boolean explicitLockingEnabled;
    private final boolean deltaConsistsOfChanges;
    private final boolean clustered;

    CacheContext(AdvancedCache<String, SchematicEntry> cache) {
        boolean pre520Final;
        this.cache = cache;
        Configuration config = cache.getCacheConfiguration();
        this.clustered = config.clustering().cacheMode() != CacheMode.LOCAL;
        boolean deltaConsistsOfChanges = false;
        Flag deltaWriteFlag = null;
        short ispnVersionActual = Version.getVersionShort();
        short ispnVersion520 = Version.encodeVersion((int)5, (int)2, (int)0);
        if (ispnVersionActual >= ispnVersion520) {
            try {
                deltaWriteFlag = Flag.valueOf((String)"DELTA_WRITE");
                deltaConsistsOfChanges = true;
                LOGGER.debug((Object)"Found DELTA_WRITE flag");
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug((Object)"Failed to find DELTA_WRITE flag");
            }
        } else {
            deltaConsistsOfChanges = false;
            LOGGER.debug((Object)"No DELTA_WRITE flag available");
        }
        boolean bl = pre520Final = ispnVersionActual < ispnVersion520 || ispnVersionActual == ispnVersion520 && !Version.VERSION.toLowerCase().endsWith("final");
        if (pre520Final && config.loaders().usingAsyncStore()) {
            this.cache.removeInterceptor(IsMarshallableInterceptor.class);
            LOGGER.debug((Object)("Removing IsMarshallableInterceptor from interceptor stack in pre-5.2.0.Final Infinispan cache '" + cache.getName() + "'"));
        }
        LOGGER.trace((Object)("ispnVersionActual = " + ispnVersionActual));
        LOGGER.trace((Object)("ispnVersion520    = " + ispnVersion520));
        LOGGER.trace((Object)("Version.VERSION   = " + Version.VERSION));
        LOGGER.trace((Object)("Version.VERSION.toLowerCase().endsWith('final') = " + Version.VERSION.toLowerCase().endsWith("final")));
        LOGGER.trace((Object)("is pre-5.2.0.Final = " + pre520Final));
        LOGGER.trace((Object)("config.loaders().usingAsyncStore()    = " + config.loaders().usingAsyncStore()));
        EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
        flags.add(Flag.SKIP_REMOTE_LOOKUP);
        if (deltaWriteFlag != null) {
            LOGGER.debug((Object)("Passivation? " + config.loaders().passivation()));
            LOGGER.debug((Object)("Eviction? " + config.eviction().strategy()));
            LOGGER.debug((Object)("Clustering mode? " + config.clustering().cacheMode()));
            if (config.loaders().passivation() || config.eviction().strategy() != EvictionStrategy.NONE || config.clustering().cacheMode() != CacheMode.LOCAL) {
                flags.add(deltaWriteFlag);
            } else {
                flags.add(Flag.SKIP_CACHE_LOAD);
            }
        }
        LOGGER.debug((Object)("Using cache with flags " + flags + " during SchematicEntry updates"));
        this.cacheForWriting = this.cache.withFlags(flags.toArray(new Flag[flags.size()]));
        this.deltaConsistsOfChanges = deltaConsistsOfChanges;
        if (this.isDeltaContainingChangesEnabled()) {
            LOGGER.debug((Object)("Deltas will be used to serializing changes to documents in '" + cache.getName() + "'."));
        } else {
            LOGGER.debug((Object)("Deltas will NOT be used to serializing changes to documents in '" + cache.getName() + "'."));
        }
        this.txnMgr = cache.getTransactionManager();
        this.transactionTable = (TransactionTable)cache.getComponentRegistry().getComponent(TransactionTable.class);
        LockingMode lockingMode = config.transaction().lockingMode();
        boolean bl2 = this.explicitLockingEnabled = lockingMode == LockingMode.PESSIMISTIC;
        if (this.isExplicitLockingEnabled()) {
            this.cacheForLocking = this.cache.withFlags(new Flag[]{Flag.FAIL_SILENTLY});
            LOGGER.debug((Object)("Explicit locks will be used when modifying documents in '" + cache.getName() + "' (Infinispan's locking mode is PESSIMISTIC)."));
        } else {
            this.cacheForLocking = this.cache;
            LOGGER.debug((Object)("Explicit locks will NOT be used when modifying documents in '" + cache.getName() + "' (Infinispan's locking mode is not PESSIMISTIC)."));
        }
    }

    public AdvancedCache<String, SchematicEntry> getCache() {
        return this.cache;
    }

    public AdvancedCache<String, SchematicEntry> getCacheForWriting() {
        return this.cacheForWriting;
    }

    public AdvancedCache<String, SchematicEntry> getCacheForLocking() {
        return this.cacheForLocking;
    }

    public TransactionTable getTransactionTable() {
        return this.transactionTable;
    }

    public TransactionManager getTransactionManager() {
        return this.txnMgr;
    }

    public boolean isExplicitLockingEnabled() {
        return this.explicitLockingEnabled;
    }

    public boolean isDeltaContainingChangesEnabled() {
        return this.deltaConsistsOfChanges;
    }

    public boolean isClustered() {
        return this.clustered;
    }
}

