/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.CondVar;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.Mutex;

public class CVBuffer
implements BoundedChannel {
    private final Mutex mutex;
    private final CondVar notFull;
    private final CondVar notEmpty;
    private int count = 0;
    private int takePtr = 0;
    private int putPtr = 0;
    private final Object[] array;

    public CVBuffer(int cap) {
        this.array = new Object[cap];
        this.mutex = new Mutex();
        this.notFull = new CondVar(this.mutex);
        this.notEmpty = new CondVar(this.mutex);
    }

    public CVBuffer() {
        this(DefaultChannelCapacity.get());
    }

    public int capacity() {
        return this.array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object x) throws InterruptedException {
        this.mutex.acquire();
        try {
            while (this.count == this.array.length) {
                this.notFull.await();
            }
            this.array[this.putPtr] = x;
            this.putPtr = (this.putPtr + 1) % this.array.length;
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            this.mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object x = null;
        this.mutex.acquire();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            x = this.array[this.takePtr];
            this.array[this.takePtr] = null;
            this.takePtr = (this.takePtr + 1) % this.array.length;
            --this.count;
            this.notFull.signal();
        }
        finally {
            this.mutex.release();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object x, long msecs) throws InterruptedException {
        this.mutex.acquire();
        try {
            if (this.count == this.array.length) {
                this.notFull.timedwait(msecs);
                if (this.count == this.array.length) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.array[this.putPtr] = x;
            this.putPtr = (this.putPtr + 1) % this.array.length;
            ++this.count;
            this.notEmpty.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.mutex.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long msecs) throws InterruptedException {
        Object x = null;
        this.mutex.acquire();
        try {
            if (this.count == 0) {
                this.notEmpty.timedwait(msecs);
                if (this.count == 0) {
                    Object var4_3 = null;
                    return var4_3;
                }
            }
            x = this.array[this.takePtr];
            this.array[this.takePtr] = null;
            this.takePtr = (this.takePtr + 1) % this.array.length;
            --this.count;
            this.notFull.signal();
        }
        finally {
            this.mutex.release();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object peek() {
        try {
            this.mutex.acquire();
            try {
                if (this.count == 0) {
                    Object var1_1 = null;
                    return var1_1;
                }
                Object object = this.array[this.takePtr];
                return object;
            }
            finally {
                this.mutex.release();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }
}

