/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.DefinitionCache;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeTypeIterator;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.basic.BasicName;

@ThreadSafe
class JcrNodeType
implements NodeType {
    public static final String RESIDUAL_ITEM_NAME = "*";
    public static final Name RESIDUAL_NAME = new BasicName("", "*");
    private final NodeKey key;
    private final Name name;
    private final Name primaryItemName;
    private final List<JcrNodeType> declaredSupertypes;
    private final List<JcrNodeType> allSupertypes;
    private final List<JcrNodeType> thisAndAllSupertypes;
    private final Set<Name> thisAndAllSupertypesNames;
    private final boolean mixin;
    private final boolean orderableChildNodes;
    private final boolean isAbstract;
    private final boolean queryable;
    private final List<JcrNodeDefinition> childNodeDefinitions;
    private final List<JcrPropertyDefinition> propertyDefinitions;
    private final DefinitionCache allDefinitions;
    private ExecutionContext context;
    private JcrSession session;
    private RepositoryNodeTypeManager nodeTypeManager;

    JcrNodeType(NodeKey prototypeKey, ExecutionContext context, JcrSession session, RepositoryNodeTypeManager nodeTypeManager, Name name, List<JcrNodeType> declaredSupertypes, Name primaryItemName, Collection<JcrNodeDefinition> childNodeDefinitions, Collection<JcrPropertyDefinition> propertyDefinitions, boolean mixin, boolean isAbstract, boolean queryable, boolean orderableChildNodes) {
        assert (context != null);
        this.context = context;
        this.session = session;
        this.nodeTypeManager = nodeTypeManager;
        this.name = name;
        this.primaryItemName = primaryItemName;
        this.declaredSupertypes = declaredSupertypes != null ? declaredSupertypes : Collections.emptyList();
        this.mixin = mixin;
        this.queryable = queryable;
        this.isAbstract = isAbstract;
        this.orderableChildNodes = orderableChildNodes;
        this.propertyDefinitions = new ArrayList<JcrPropertyDefinition>(propertyDefinitions.size());
        for (JcrPropertyDefinition property : propertyDefinitions) {
            this.propertyDefinitions.add(property.with(this));
        }
        this.childNodeDefinitions = new ArrayList<JcrNodeDefinition>(childNodeDefinitions.size());
        for (JcrNodeDefinition childNode : childNodeDefinitions) {
            this.childNodeDefinitions.add(childNode.with(this));
        }
        LinkedList<JcrNodeType> thisAndAllSupertypes = new LinkedList<JcrNodeType>();
        HashSet<Name> typeNames = new HashSet<Name>();
        thisAndAllSupertypes.add(this);
        typeNames.add(this.name);
        for (int i = 0; i != thisAndAllSupertypes.size(); ++i) {
            JcrNodeType superType = (JcrNodeType)thisAndAllSupertypes.get(i);
            for (JcrNodeType superSuperType : superType.getDeclaredSupertypes()) {
                JcrNodeType jcrSuperSuperType = superSuperType;
                if (jcrSuperSuperType == null) {
                    assert (JcrNtLexicon.BASE.equals(name));
                    continue;
                }
                if (!typeNames.add(jcrSuperSuperType.getInternalName())) continue;
                thisAndAllSupertypes.add(jcrSuperSuperType);
            }
        }
        this.thisAndAllSupertypes = Collections.unmodifiableList(thisAndAllSupertypes);
        this.allSupertypes = thisAndAllSupertypes.size() > 1 ? thisAndAllSupertypes.subList(1, thisAndAllSupertypes.size()) : Collections.emptyList();
        this.thisAndAllSupertypesNames = Collections.unmodifiableSet(typeNames);
        this.allDefinitions = new DefinitionCache(this);
        this.key = prototypeKey.withId("/jcr:system/jcr:nodeTypes/" + name.getString());
    }

    final NodeKey key() {
        return this.key;
    }

    List<JcrNodeType> getTypeAndSupertypes() {
        return this.thisAndAllSupertypes;
    }

    List<JcrNodeType> supertypes() {
        return this.allSupertypes;
    }

    List<JcrNodeDefinition> childNodeDefinitions() {
        return this.childNodeDefinitions;
    }

    List<JcrPropertyDefinition> propertyDefinitions() {
        return this.propertyDefinitions;
    }

    Collection<JcrPropertyDefinition> allPropertyDefinitions() {
        return this.allDefinitions.allPropertyDefinitions();
    }

    Collection<JcrPropertyDefinition> allSingleValuePropertyDefinitions(Name propertyName) {
        return this.allDefinitions.allSingleValuePropertyDefinitions(propertyName);
    }

    Collection<JcrPropertyDefinition> allMultiValuePropertyDefinitions(Name propertyName) {
        return this.allDefinitions.allMultiValuePropertyDefinitions(propertyName);
    }

    Collection<JcrPropertyDefinition> allPropertyDefinitions(Name propertyName) {
        return this.allDefinitions.allPropertyDefinitions(propertyName);
    }

    Collection<JcrNodeDefinition> allChildNodeDefinitions() {
        return this.allDefinitions.allChildNodeDefinitions();
    }

    Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName, boolean requireSns) {
        return this.allDefinitions.allChildNodeDefinitions(childName, requireSns);
    }

    Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName) {
        return this.allDefinitions.allChildNodeDefinitions(childName);
    }

    JcrNodeDefinition childNodeDefinition(NodeDefinitionId nodeDefnId) {
        List<Name> requiredPrimaryTypeNames = Arrays.asList(nodeDefnId.getRequiredPrimaryTypes());
        for (JcrNodeDefinition nodeDefn : this.allChildNodeDefinitions(nodeDefnId.getChildDefinitionName())) {
            if (nodeDefn.requiredPrimaryTypeNameSet().size() != requiredPrimaryTypeNames.size() || !nodeDefn.requiredPrimaryTypeNameSet().containsAll(requiredPrimaryTypeNames)) continue;
            return nodeDefn;
        }
        return null;
    }

    public boolean canAddChildNode(String childNodeName) {
        CheckArg.isNotNull((Object)childNodeName, (String)"childNodeName");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create(childNodeName);
        return this.nodeTypes().findChildNodeDefinition(this.name, null, childName, null, 0, true) != null;
    }

    public boolean canAddChildNode(String childNodeName, String primaryNodeTypeName) {
        JcrNodeType childType;
        CheckArg.isNotNull((Object)childNodeName, (String)"childNodeName");
        CheckArg.isNotNull((Object)primaryNodeTypeName, (String)"primaryNodeTypeName");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create(childNodeName);
        Name childPrimaryTypeName = (Name)this.context.getValueFactories().getNameFactory().create(primaryNodeTypeName);
        RepositoryNodeTypeManager.NodeTypes nodeTypes = this.nodeTypes();
        JcrNodeDefinition childNodeDefinition = nodeTypes.findChildNodeDefinition(this.name, null, childName, childPrimaryTypeName, 0, true);
        if (childNodeDefinition != null && RESIDUAL_ITEM_NAME.equals(childNodeDefinition.getName())) {
            return true;
        }
        if (primaryNodeTypeName != null && ((childType = nodeTypes.getNodeType(childPrimaryTypeName)).isAbstract() || childType.isMixin())) {
            return false;
        }
        return childNodeDefinition != null;
    }

    public boolean canRemoveNode(String itemName) {
        CheckArg.isNotNull((Object)itemName, (String)"itemName");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create(itemName);
        return this.nodeTypes().canRemoveAllChildren(this.name, null, childName, true);
    }

    public boolean canRemoveItem(String itemName) {
        CheckArg.isNotNull((Object)itemName, (String)"itemName");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create(itemName);
        return this.nodeTypes().canRemoveItem(this.name, null, childName, true);
    }

    boolean canCastToTypeAndMatchesConstraints(JcrSession session, JcrPropertyDefinition propertyDefinition, Value value) {
        try {
            assert (value instanceof JcrValue) : "Illegal implementation of Value interface";
            ((JcrValue)value).asType(propertyDefinition.getRequiredType());
            return propertyDefinition.satisfiesConstraints(value, session);
        }
        catch (ValueFormatException vfe) {
            return false;
        }
    }

    boolean canCastToTypeAndMatchesConstraints(JcrSession session, JcrPropertyDefinition propertyDefinition, Value[] values) {
        for (Value value : values) {
            if (this.canCastToTypeAndMatchesConstraints(session, propertyDefinition, value)) continue;
            return false;
        }
        return true;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        return this.canSetProperty(this.session, propertyName, value);
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        return this.canSetProperty(this.session, propertyName, values);
    }

    public boolean canSetProperty(JcrSession session, String propertyName, Value value) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        return this.nodeTypes().findPropertyDefinition(session, this.name, null, name, value, false, true) != null;
    }

    public boolean canSetProperty(JcrSession session, String propertyName, Value[] values) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        if (values == null || values.length == 0) {
            return this.canRemoveProperty(propertyName);
        }
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        return this.nodeTypes().findPropertyDefinition(session, this.name, null, name, values, true) != null;
    }

    public boolean canRemoveProperty(String propertyName) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        return this.nodeTypes().canRemoveProperty(this.name, null, name, true);
    }

    public JcrNodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.childNodeDefinitions.toArray(new JcrNodeDefinition[this.childNodeDefinitions.size()]);
    }

    public JcrNodeDefinition[] getChildNodeDefinitions() {
        Collection<JcrNodeDefinition> definitions = this.allDefinitions.allChildNodeDefinitions();
        return definitions.toArray(new JcrNodeDefinition[definitions.size()]);
    }

    public JcrPropertyDefinition[] getPropertyDefinitions() {
        Collection<JcrPropertyDefinition> definitions = this.allDefinitions.allPropertyDefinitions();
        return definitions.toArray(new JcrPropertyDefinition[definitions.size()]);
    }

    public JcrNodeType[] getDeclaredSupertypes() {
        return this.declaredSupertypes.toArray(new JcrNodeType[this.declaredSupertypes.size()]);
    }

    public String[] getDeclaredSupertypeNames() {
        ArrayList<String> supertypeNames = new ArrayList<String>(this.declaredSupertypes.size());
        for (JcrNodeType declaredSupertype : this.declaredSupertypes) {
            supertypeNames.add(declaredSupertype.getName());
        }
        return supertypeNames.toArray(new String[supertypeNames.size()]);
    }

    public NodeTypeIterator getSubtypes() {
        return new JcrNodeTypeIterator(this.nodeTypes().subtypesFor(this));
    }

    public NodeTypeIterator getDeclaredSubtypes() {
        return new JcrNodeTypeIterator(this.nodeTypes().declaredSubtypesFor(this));
    }

    public String getName() {
        return this.name.getString(this.context.getNamespaceRegistry());
    }

    final Name getInternalName() {
        return this.name;
    }

    Name getInternalPrimaryItemName() {
        return this.primaryItemName;
    }

    public String getPrimaryItemName() {
        if (this.primaryItemName == null) {
            return null;
        }
        return this.primaryItemName.getString(this.context.getNamespaceRegistry());
    }

    public JcrPropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.propertyDefinitions.toArray(new JcrPropertyDefinition[this.propertyDefinitions.size()]);
    }

    public NodeType[] getSupertypes() {
        return this.allSupertypes.toArray(new NodeType[this.allSupertypes.size()]);
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public boolean isNodeType(String nodeTypeName) {
        if (nodeTypeName == null) {
            return false;
        }
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(nodeTypeName);
        return this.thisAndAllSupertypesNames.contains(name);
    }

    boolean isNodeType(Name nodeTypeName) {
        if (nodeTypeName == null) {
            return false;
        }
        return this.thisAndAllSupertypesNames.contains(nodeTypeName);
    }

    boolean isNodeTypeOneOf(Name ... nodeTypeNames) {
        if (nodeTypeNames == null || nodeTypeNames.length == 0) {
            return false;
        }
        for (Name nodeTypeName : nodeTypeNames) {
            if (!this.thisAndAllSupertypesNames.contains(nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JcrNodeType) {
            JcrNodeType that = (JcrNodeType)obj;
            return this.name.equals(that.name);
        }
        if (obj instanceof NodeType) {
            NodeType that = (NodeType)obj;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    final JcrNodeType with(RepositoryNodeTypeManager nodeTypeManager) {
        return new JcrNodeType(this.key, this.context, this.session, nodeTypeManager, this.name, this.declaredSupertypes, this.primaryItemName, this.childNodeDefinitions, this.propertyDefinitions, this.mixin, this.isAbstract, this.queryable, this.orderableChildNodes);
    }

    final JcrNodeType with(ExecutionContext context, JcrSession session) {
        return new JcrNodeType(this.key, context, session, this.nodeTypeManager, this.name, this.declaredSupertypes, this.primaryItemName, this.childNodeDefinitions, this.propertyDefinitions, this.mixin, this.isAbstract, this.queryable, this.orderableChildNodes);
    }

    final RepositoryNodeTypeManager.NodeTypes nodeTypes() {
        return this.nodeTypeManager.getNodeTypes();
    }

    final RepositoryNodeTypeManager nodeTypeManager() {
        return this.nodeTypeManager;
    }

    final boolean conflictsWith(NodeType primaryNodeType, NodeType[] mixinNodeTypes) {
        NodeDefinitionId nid;
        PropertyDefinitionId pid;
        HashMap<PropertyDefinitionId, JcrPropertyDefinition> props = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
        Name DEFAULT_NAME = this.name;
        for (JcrPropertyDefinition property : this.propertyDefinitions()) {
            pid = new PropertyDefinitionId(DEFAULT_NAME, property.name, 0, property.isMultiple());
            props.put(pid, property);
        }
        if (primaryNodeType.getName().equals(this.getName())) {
            return true;
        }
        for (JcrPropertyDefinition property : ((JcrNodeType)primaryNodeType).propertyDefinitions()) {
            String propTypeName;
            String oldPropTypeName;
            pid = new PropertyDefinitionId(DEFAULT_NAME, property.name, 0, property.isMultiple());
            JcrPropertyDefinition oldProp = props.put(pid, property);
            if (oldProp == null || (oldPropTypeName = oldProp.getDeclaringNodeType().getName()).equals(propTypeName = property.getDeclaringNodeType().getName())) continue;
            return true;
        }
        for (NodeType mixinNodeType : mixinNodeTypes) {
            if (mixinNodeType.getName().equals(this.getName())) {
                return true;
            }
            for (JcrPropertyDefinition property : ((JcrNodeType)mixinNodeType).propertyDefinitions()) {
                String propTypeName;
                String oldPropTypeName;
                PropertyDefinitionId pid2 = new PropertyDefinitionId(DEFAULT_NAME, property.name, 0, property.isMultiple());
                JcrPropertyDefinition oldProp = props.put(pid2, property);
                if (oldProp == null || (oldPropTypeName = oldProp.getDeclaringNodeType().getName()).equals(propTypeName = property.getDeclaringNodeType().getName())) continue;
                return true;
            }
        }
        HashMap<NodeDefinitionId, JcrNodeDefinition> childNodes = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
        for (JcrNodeDefinition childNode : this.childNodeDefinitions()) {
            nid = new NodeDefinitionId(DEFAULT_NAME, childNode.name, new Name[0]);
            childNodes.put(nid, childNode);
        }
        Iterator<JcrNodeDefinition> i$ = ((JcrNodeType)primaryNodeType).childNodeDefinitions().iterator();
        while (i$.hasNext()) {
            String childNodeTypeName;
            String oldNodeTypeName;
            JcrNodeDefinition childNode;
            nid = new NodeDefinitionId(DEFAULT_NAME, childNode.name, new Name[0]);
            childNode = i$.next();
            JcrNodeDefinition oldNode = childNodes.put(nid, childNode);
            if (oldNode == null || (oldNodeTypeName = oldNode.getDeclaringNodeType().getName()).equals(childNodeTypeName = childNode.getDeclaringNodeType().getName())) continue;
            return true;
        }
        for (NodeType mixinNodeType : mixinNodeTypes) {
            Iterator<JcrNodeDefinition> i$2 = ((JcrNodeType)mixinNodeType).childNodeDefinitions().iterator();
            while (i$2.hasNext()) {
                String childNodeTypeName;
                String oldNodeTypeName;
                JcrNodeDefinition childNode;
                NodeDefinitionId nid2 = new NodeDefinitionId(DEFAULT_NAME, childNode.name, new Name[0]);
                childNode = i$2.next();
                JcrNodeDefinition oldNode = childNodes.put(nid2, childNode);
                if (oldNode == null || (oldNodeTypeName = oldNode.getDeclaringNodeType().getName()).equals(childNodeTypeName = childNode.getDeclaringNodeType().getName())) continue;
                return true;
            }
        }
        return false;
    }
}

