/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Set;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class VersionedPutKeyValueCommand
extends PutKeyValueCommand {
    public static final byte COMMAND_ID = 28;
    private EntryVersion version;

    public VersionedPutKeyValueCommand() {
    }

    public VersionedPutKeyValueCommand(Object key, Object value, boolean putIfAbsent, CacheNotifier notifier, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags, EntryVersion version) {
        super(key, value, putIfAbsent, notifier, lifespanMillis, maxIdleTimeMillis, flags);
        this.version = version;
    }

    public EntryVersion getVersion() {
        return this.version;
    }

    public void setVersion(EntryVersion version) {
        this.version = version;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Object r = super.perform(ctx);
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (!(this.value instanceof Delta)) {
            e.setVersion(this.version);
        }
        return r;
    }

    @Override
    public byte getCommandId() {
        return 28;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.value, this.lifespanMillis, this.maxIdleTimeMillis, this.version, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 28) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.value = parameters[1];
        this.lifespanMillis = (Long)parameters[2];
        this.maxIdleTimeMillis = (Long)parameters[3];
        this.version = (EntryVersion)parameters[4];
        this.flags = (Set)parameters[5];
    }

    @Override
    public String toString() {
        return "VersionedPutKeyValueCommand{key=" + this.key + ", value=" + this.value + ", version=" + this.version + ", flags=" + this.flags + ", putIfAbsent=" + this.putIfAbsent + ", lifespanMillis=" + this.lifespanMillis + ", maxIdleTimeMillis=" + this.maxIdleTimeMillis + "}";
    }
}

