/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.impl.BridgeFactory;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.AnnotationProcessingHelper;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FieldMetadata {
    private static final Log log = LoggerFactory.make();
    private final XProperty fieldGetter;
    private final String fieldName;
    private final Store store;
    private final Field.Index index;
    private final Float boost;
    private final BoostStrategy dynamicBoostStrategy;
    private final Field.TermVector termVector;
    private final Integer precisionStep;
    private final String nullToken;
    private final FieldBridge fieldBridge;
    private final Analyzer analyzer;

    public FieldMetadata(String prefix, XProperty member, Field fieldAnn, NumericField numericFieldAnn, Spatial spatialAnn, ConfigContext context, ReflectionManager reflectionManager) {
        Analyzer tmpAnalyzer;
        String indexNullAs;
        ReflectionHelper.setAccessible((XMember)member);
        this.fieldGetter = member;
        if (fieldAnn != null) {
            this.index = AnnotationProcessingHelper.getIndex(fieldAnn.index(), fieldAnn.analyze(), fieldAnn.norms());
            this.store = fieldAnn.store();
            this.fieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, fieldAnn.name());
            this.boost = AnnotationProcessingHelper.getBoost(member, fieldAnn);
            this.termVector = AnnotationProcessingHelper.getTermVector(fieldAnn.termVector());
            indexNullAs = fieldAnn.indexNullAs();
            if (indexNullAs.equals("__DO_NOT_INDEX_NULL__")) {
                indexNullAs = null;
            } else if (indexNullAs.equals("__DEFAULT_NULL_TOKEN__")) {
                indexNullAs = context.getDefaultNullToken();
            }
            this.nullToken = indexNullAs;
            tmpAnalyzer = AnnotationProcessingHelper.getAnalyzer(fieldAnn.analyzer(), context);
        } else {
            this.index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
            this.store = spatialAnn.store();
            this.fieldName = prefix + ReflectionHelper.getAttributeName((XMember)member, spatialAnn.name());
            this.boost = AnnotationProcessingHelper.getBoost(member, spatialAnn);
            this.termVector = Field.TermVector.NO;
            this.nullToken = indexNullAs = null;
            tmpAnalyzer = null;
        }
        this.dynamicBoostStrategy = AnnotationProcessingHelper.getDynamicBoost(member);
        this.precisionStep = AnnotationProcessingHelper.getPrecisionStep(numericFieldAnn);
        FieldBridge bridge = BridgeFactory.guessType(fieldAnn, numericFieldAnn, (XMember)member, reflectionManager);
        if (indexNullAs != null && bridge instanceof TwoWayFieldBridge) {
            bridge = new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)bridge, indexNullAs);
        }
        this.fieldBridge = bridge;
        if (tmpAnalyzer == null) {
            tmpAnalyzer = AnnotationProcessingHelper.getAnalyzer((org.hibernate.search.annotations.Analyzer)member.getAnnotation(org.hibernate.search.annotations.Analyzer.class), context);
        }
        this.analyzer = tmpAnalyzer;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Field.Index getIndex() {
        return this.index;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void appendToPropertiesMetadata(AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata) {
        this.sanityCheckFieldConfiguration(propertiesMetadata);
        propertiesMetadata.fieldGetters.add((XMember)this.fieldGetter);
        propertiesMetadata.fieldGetterNames.add(this.fieldGetter.getName());
        propertiesMetadata.fieldNames.add(this.fieldName);
        propertiesMetadata.fieldNameToPositionMap.put(this.fieldGetter.getName(), propertiesMetadata.fieldNames.size());
        propertiesMetadata.fieldStore.add(this.store);
        propertiesMetadata.fieldIndex.add(this.index);
        propertiesMetadata.fieldBoosts.add(this.boost);
        propertiesMetadata.dynamicFieldBoosts.add(this.dynamicBoostStrategy);
        propertiesMetadata.fieldTermVectors.add(this.termVector);
        propertiesMetadata.precisionSteps.add(this.precisionStep);
        propertiesMetadata.fieldNullTokens.add(this.nullToken);
        propertiesMetadata.fieldBridges.add(this.fieldBridge);
    }

    private void sanityCheckFieldConfiguration(AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata) {
        int indexOfFieldWithSameName = propertiesMetadata.fieldNames.lastIndexOf(this.fieldName);
        if (indexOfFieldWithSameName != -1 && !propertiesMetadata.fieldIndex.get(indexOfFieldWithSameName).equals((Object)this.index)) {
            log.inconsistentFieldConfiguration(this.fieldName);
        }
    }
}

