/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Protocol;
import org.hibernate.search.indexes.serialization.avro.impl.AvroDeserializer;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializer;
import org.hibernate.search.indexes.serialization.spi.Deserializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.serialization.spi.Serializer;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class AvroSerializationProvider
implements SerializationProvider {
    private static final Log log = LoggerFactory.make();
    private static String V1_PATH = "org/hibernate/search/remote/codex/avro/v1_0/";
    private static final String AVRO_SCHEMA_FILE_SUFFIX = ".avro";
    private static final String AVRO_PROTOCOL_FILE_SUFFIX = ".avpr";
    private Map<String, String> schemas = new HashMap<String, String>();
    private Protocol protocol;
    public static byte MAJOR_VERSION = (byte)-127;
    public static byte MINOR_VERSION = (byte)-128;

    public static int getMajorVersion() {
        return MAJOR_VERSION + 128;
    }

    public static int getMinorVersion() {
        return MINOR_VERSION + 128;
    }

    @Override
    public Serializer getSerializer() {
        return new AvroSerializer(this.protocol);
    }

    @Override
    public Deserializer getDeserializer() {
        return new AvroDeserializer(this.protocol);
    }

    public AvroSerializationProvider() {
        log.serializationProtocol(AvroSerializationProvider.getMajorVersion(), AvroSerializationProvider.getMinorVersion());
        this.parseSchema("attribute/TokenTrackingAttribute");
        this.parseSchema("attribute/CharTermAttribute");
        this.parseSchema("attribute/PayloadAttribute");
        this.parseSchema("attribute/KeywordAttribute");
        this.parseSchema("attribute/PositionIncrementAttribute");
        this.parseSchema("attribute/FlagsAttribute");
        this.parseSchema("attribute/TypeAttribute");
        this.parseSchema("attribute/OffsetAttribute");
        this.parseSchema("field/TermVector");
        this.parseSchema("field/Index");
        this.parseSchema("field/Store");
        this.parseSchema("field/TokenStreamField");
        this.parseSchema("field/ReaderField");
        this.parseSchema("field/StringField");
        this.parseSchema("field/BinaryField");
        this.parseSchema("field/NumericIntField");
        this.parseSchema("field/NumericLongField");
        this.parseSchema("field/NumericFloatField");
        this.parseSchema("field/NumericDoubleField");
        this.parseSchema("field/CustomFieldable");
        this.parseSchema("Document");
        this.parseSchema("operation/Id");
        this.parseSchema("operation/OptimizeAll");
        this.parseSchema("operation/PurgeAll");
        this.parseSchema("operation/Delete");
        this.parseSchema("operation/Add");
        this.parseSchema("operation/Update");
        this.parseSchema("Message");
        this.protocol = this.parseProtocol("Works");
    }

    private void parseSchema(String filename) {
        String fullFileName = V1_PATH + filename + AVRO_SCHEMA_FILE_SUFFIX;
        String messageSchemaAsString = FileHelper.readResourceAsString(fullFileName, AvroSerializationProvider.class.getClassLoader());
        this.schemas.put(filename, messageSchemaAsString);
    }

    public Protocol parseProtocol(String name) {
        String filename = V1_PATH + name + AVRO_PROTOCOL_FILE_SUFFIX;
        String protocolSkeleton = FileHelper.readResourceAsString(filename, AvroSerializationProvider.class.getClassLoader());
        String protocolString = this.inlineSchemas(protocolSkeleton);
        return Protocol.parse((String)protocolString);
    }

    public String inlineSchemas(String protocolSkeleton) {
        String result = protocolSkeleton;
        for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
            result = AvroSerializationProvider.replace(result, "`" + entry.getKey() + "`", entry.getValue());
        }
        return result;
    }

    static String replace(String str, String pattern, String replace) {
        int e;
        int s = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public String toString() {
        return "Avro SerializationProvider v" + AvroSerializationProvider.getMajorVersion() + "." + AvroSerializationProvider.getMinorVersion();
    }
}

