/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.VInt8IntDecoder;

public class FourFlagsIntDecoder
extends IntDecoder {
    private static final byte[][] decodeTable = new byte[256][4];
    private final IntDecoder decoder = new VInt8IntDecoder();
    private int indicator;
    private int ordinal = 0;

    public long decode() throws IOException {
        byte decodeVal;
        if ((this.ordinal & 3) == 0) {
            this.indicator = this.in.read();
            if (this.indicator < 0) {
                return 0x100000000L;
            }
            this.ordinal = 0;
        }
        if ((decodeVal = decodeTable[this.indicator][this.ordinal++]) == 0) {
            long decode = this.decoder.decode();
            return decode == 0x100000000L ? 0x100000000L : decode + 4L;
        }
        return decodeVal;
    }

    public void reInit(InputStream in) {
        super.reInit(in);
        this.decoder.reInit(in);
        this.ordinal = 0;
        this.indicator = 0;
    }

    public String toString() {
        return "FourFlags (VInt8)";
    }

    static {
        int i = 256;
        while (i != 0) {
            --i;
            int j = 4;
            while (j != 0) {
                FourFlagsIntDecoder.decodeTable[i][--j] = (byte)(i >>> (j << 1) & 3);
            }
        }
    }
}

