/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.bus;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.HashCode;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;

@ThreadSafe
public final class RepositoryChangeBus
implements ChangeBus {
    private static final String NULL_WORKSPACE_NAME = "null_workspace_name";
    protected static final Logger LOGGER = Logger.getLogger(RepositoryChangeBus.class);
    protected volatile boolean shutdown;
    private final ExecutorService executor;
    private final Set<ChangeSetDispatcher> dispatchers;
    private final Map<Integer, Future<?>> workers;
    private final String systemWorkspaceName;

    public RepositoryChangeBus(ExecutorService executor, String systemWorkspaceName) {
        this.systemWorkspaceName = systemWorkspaceName;
        this.workers = new HashMap();
        this.dispatchers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.executor = executor;
        this.shutdown = false;
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        this.dispatchers.clear();
        this.stopWork();
    }

    private void stopWork() {
        this.executor.shutdown();
        for (Future<?> worker : this.workers.values()) {
            if (worker.isDone()) continue;
            worker.cancel(true);
        }
        this.workers.clear();
    }

    @Override
    public boolean register(ChangeSetListener listener) {
        if (listener == null) {
            return false;
        }
        int hashCode = HashCode.compute((Object[])new Object[]{listener});
        if (!this.workers.containsKey(hashCode)) {
            ChangeSetDispatcher dispatcher = new ChangeSetDispatcher(listener);
            this.dispatchers.add(dispatcher);
            this.workers.put(hashCode, this.executor.submit(dispatcher));
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister(ChangeSetListener listener) {
        if (listener == null) {
            return false;
        }
        int hashCode = HashCode.compute((Object[])new Object[]{listener});
        if (this.workers.containsKey(hashCode)) {
            Iterator<ChangeSetDispatcher> dispatcherIterator = this.dispatchers.iterator();
            while (dispatcherIterator.hasNext()) {
                ChangeSetDispatcher dispatcher = dispatcherIterator.next();
                if (dispatcher.listenerHashCode() != hashCode) continue;
                Future<?> work = this.workers.remove(hashCode);
                work.cancel(true);
                dispatcherIterator.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public void notify(ChangeSet changeSet) {
        String workspaceName;
        if (changeSet == null || !this.hasObservers()) {
            return;
        }
        if (this.shutdown) {
            throw new IllegalStateException("Change bus has been already shut down, should not have any more observers");
        }
        String string = workspaceName = changeSet.getWorkspaceName() != null ? changeSet.getWorkspaceName() : NULL_WORKSPACE_NAME;
        if (workspaceName.equalsIgnoreCase(this.systemWorkspaceName)) {
            this.submitChanges(changeSet, true);
        } else {
            this.submitChanges(changeSet, false);
        }
    }

    private boolean submitChanges(ChangeSet changeSet, boolean inThread) {
        for (ChangeSetDispatcher dispatcher : this.dispatchers) {
            if (inThread) {
                dispatcher.listener().notify(changeSet);
                continue;
            }
            dispatcher.submit(changeSet);
        }
        return true;
    }

    @Override
    public boolean hasObservers() {
        return !this.dispatchers.isEmpty();
    }

    private class ChangeSetDispatcher
    implements Callable<Void> {
        private final int listenerHashCode;
        private ChangeSetListener listener;
        private BlockingQueue<ChangeSet> queue;

        protected ChangeSetDispatcher(ChangeSetListener listener) {
            this.listener = listener;
            this.listenerHashCode = HashCode.compute((Object[])new Object[]{listener});
            this.queue = new LinkedBlockingQueue<ChangeSet>();
        }

        @Override
        public Void call() {
            while (!RepositoryChangeBus.this.shutdown) {
                try {
                    ChangeSet changeSet = this.queue.take();
                    if (changeSet == null) continue;
                    this.listener.notify(changeSet);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
            this.shutdown();
            return null;
        }

        protected void submit(ChangeSet changeSet) {
            if (!this.queue.offer(changeSet)) {
                LOGGER.debug("Cannot submit change set: {0} because the queue is full", new Object[]{changeSet});
            }
        }

        protected int listenerHashCode() {
            return this.listenerHashCode;
        }

        protected ChangeSetListener listener() {
            return this.listener;
        }

        private void shutdown() {
            while (!this.queue.isEmpty()) {
                this.listener.notify((ChangeSet)this.queue.remove());
            }
            this.listener = null;
            this.queue = null;
        }
    }
}

