/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.clustering;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.fork.ForkChannel;
import org.jgroups.protocols.CENTRAL_LOCK;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Protocol;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.clustering.ClusteringI18n;
import org.modeshape.jcr.clustering.MessageConsumer;

@ThreadSafe
public final class ClusteringService {
    protected static final Logger LOGGER = Logger.getLogger(ClusteringService.class);
    private static final String FORK_CHANNEL_NAME = "modeshape-fork-channel";
    private static final long DEFAULT_MAX_CLOCK_DELAY_CLUSTER_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    private static final String GLOBAL_LOCK = "modeshape-global-lock";
    private final Listener listener = new Listener();
    private final Receiver receiver = new Receiver();
    protected final AtomicBoolean isOpen = new AtomicBoolean(false);
    protected final AtomicInteger membersInCluster = new AtomicInteger(1);
    private final long maxAllowedClockDelayMillis = DEFAULT_MAX_CLOCK_DELAY_CLUSTER_MILLIS;
    private Channel channel;
    private Channel originalChannel;
    private JChannel lockChannel;
    protected LockService lockService;
    protected final Set<MessageConsumer<Serializable>> consumers = new CopyOnWriteArraySet<MessageConsumer<Serializable>>();

    public synchronized ClusteringService startStandalone(String clusterName, String jgroupsConfig) {
        if (StringUtil.isBlank((String)clusterName)) {
            clusterName = "modeshape-cluster";
        }
        try {
            this.channel = this.newChannel(jgroupsConfig);
            this.initChannel(clusterName);
            this.initLockService(this.channel);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized ClusteringService startForked(Channel mainChannel) {
        CheckArg.isNotNull((Object)mainChannel, (String)"mainChannel");
        try {
            Protocol topProtocol = mainChannel.getProtocolStack().getTopProtocol();
            this.channel = new ForkChannel(mainChannel, "modeshape-stack", FORK_CHANNEL_NAME, true, 1, topProtocol.getClass(), new Protocol[0]);
            this.originalChannel = mainChannel;
            this.initChannel(FORK_CHANNEL_NAME);
            this.initLockService(mainChannel);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initLockService(Channel mainChannel) throws Exception {
        Protocol bottomProtocol = mainChannel.getProtocolStack().getBottomProtocol();
        this.lockChannel = new ForkChannel(mainChannel, "modeshape-lock-stack", "modeshape-lock-channel", true, 1, bottomProtocol.getClass(), new Protocol[]{new CENTRAL_LOCK()});
        this.lockChannel.setReceiver((org.jgroups.Receiver)new ReceiverAdapter(){

            public void viewAccepted(View view) {
                if (view instanceof MergeView) {
                    ClusteringService.this.lockService.unlockAll();
                }
            }
        });
        this.lockChannel.connect("ignored");
        this.lockService = new LockService(this.lockChannel);
    }

    private void initChannel(String clusterName) throws Exception {
        this.channel.addChannelListener((ChannelListener)this.listener);
        this.channel.setReceiver((org.jgroups.Receiver)this.receiver);
        this.channel.connect(clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel newChannel(String jgroupsConfig) throws Exception {
        if (StringUtil.isBlank((String)jgroupsConfig)) {
            return new JChannel();
        }
        XmlConfigurator configurator = null;
        InputStream stream = ClusteringService.class.getClassLoader().getResourceAsStream(jgroupsConfig);
        try {
            configurator = XmlConfigurator.getInstance((InputStream)stream);
        }
        catch (IOException e) {
            LOGGER.debug((Throwable)e, "Channel configuration is not a classpath resource", new Object[0]);
            stream = new ByteArrayInputStream(jgroupsConfig.getBytes());
            try {
                configurator = XmlConfigurator.getInstance((InputStream)stream);
            }
            catch (IOException e1) {
                LOGGER.debug((Throwable)e, "Channel configuration is not valid XML content", new Object[0]);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        if (configurator == null) {
            throw new RepositoryException(ClusteringI18n.channelConfigurationError.text(new Object[]{jgroupsConfig}));
        }
        return new JChannel((ProtocolStackConfigurator)configurator);
    }

    public synchronized void addConsumer(MessageConsumer<? extends Serializable> consumer) {
        this.consumers.add(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        LOGGER.debug("Shutting down cluster service", new Object[0]);
        this.consumers.clear();
        if (this.lockChannel != null) {
            try {
                this.lockService.unlockAll();
                this.lockChannel.close();
                LOGGER.debug("Successfully closed lock channel", new Object[0]);
            }
            finally {
                this.lockService = null;
                this.lockChannel = null;
            }
        }
        if (this.channel != null) {
            this.isOpen.set(false);
            try {
                this.channel.removeChannelListener((ChannelListener)this.listener);
                this.channel.setReceiver(null);
                this.channel.close();
                LOGGER.debug("Successfully closed main channel", new Object[0]);
            }
            finally {
                this.channel = null;
            }
            this.membersInCluster.set(1);
            if (this.originalChannel != null) {
                Protocol removed = this.originalChannel.getProtocolStack().removeProtocol(FORK.class);
                if (removed == null) {
                    LOGGER.debug("FORK protocol not found in original channel stack", new Object[0]);
                }
                this.originalChannel = null;
            }
        }
    }

    public boolean tryLock(long time, TimeUnit unit) {
        try {
            return this.lockService.getLock(GLOBAL_LOCK).tryLock(time, unit);
        }
        catch (InterruptedException e) {
            LOGGER.debug("Thread " + Thread.currentThread().getName() + " received interrupt request while waiting to acquire lock '{0}'", new Object[]{GLOBAL_LOCK});
            Thread.interrupted();
            return false;
        }
    }

    public void unlock() {
        this.lockService.getLock(GLOBAL_LOCK).unlock();
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public boolean multipleMembersInCluster() {
        return this.membersInCluster.get() > 1;
    }

    public int membersInCluster() {
        return this.membersInCluster.get();
    }

    public String clusterName() {
        return this.channel.getClusterName();
    }

    public long getMaxAllowedClockDelayMillis() {
        return this.maxAllowedClockDelayMillis;
    }

    public boolean sendMessage(Serializable payload) {
        if (!this.isOpen() || !this.multipleMembersInCluster()) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending payload {0} in cluster {1} ", new Object[]{payload, this.clusterName()});
        }
        try {
            byte[] messageData = this.toByteArray(payload);
            Message jgMessage = new Message(null, null, messageData);
            this.channel.send(jgMessage);
            return true;
        }
        catch (Exception e) {
            throw new SystemFailureException(ClusteringI18n.errorSendingMessage.text(new Object[]{this.clusterName()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(Object payload) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(output);){
            stream.writeObject(payload);
        }
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable fromByteArray(byte[] data, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (classLoader == null) {
            classLoader = ClusteringService.class.getClassLoader();
        }
        try (ObjectInputStreamWithClassLoader input = new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), classLoader);){
            Serializable serializable = (Serializable)input.readObject();
            return serializable;
        }
    }

    private static class ObjectInputStreamWithClassLoader
    extends ObjectInputStream {
        private ClassLoader cl;

        public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.cl = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.cl == null) {
                return super.resolveClass(desc);
            }
            try {
                return Class.forName(desc.getName(), false, this.cl);
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.cl = null;
        }
    }

    protected class Listener
    implements ChannelListener {
        protected Listener() {
        }

        public void channelClosed(Channel channel) {
            ClusteringService.this.isOpen.set(false);
        }

        public void channelConnected(Channel channel) {
            ClusteringService.this.isOpen.set(true);
        }

        public void channelDisconnected(Channel channel) {
            ClusteringService.this.isOpen.set(false);
        }
    }

    protected final class Receiver
    extends ReceiverAdapter {
        protected Receiver() {
        }

        public void block() {
            ClusteringService.this.isOpen.set(false);
        }

        public void receive(Message message) {
            try {
                Serializable payload = ClusteringService.this.fromByteArray(message.getBuffer(), ((Object)((Object)this)).getClass().getClassLoader());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cluster {0} received payload {1}", new Object[]{ClusteringService.this.clusterName(), payload});
                }
                for (MessageConsumer<Serializable> consumer : ClusteringService.this.consumers) {
                    if (!consumer.getPayloadType().isAssignableFrom(payload.getClass())) continue;
                    consumer.consume(payload);
                }
            }
            catch (Exception e) {
                String msg = ClusteringI18n.errorReceivingMessage.text(new Object[]{ClusteringService.this.clusterName()});
                throw new SystemFailureException(msg, (Throwable)e);
            }
        }

        public void suspect(Address suspectedMbr) {
            LOGGER.error((I18nResource)ClusteringI18n.memberOfClusterIsSuspect, new Object[]{ClusteringService.this.clusterName(), suspectedMbr});
        }

        public void viewAccepted(View newView) {
            LOGGER.trace("Members of '{0}' cluster have changed: {1}, total count: {2}", new Object[]{ClusteringService.this.clusterName(), newView, newView.getMembers().size()});
            ClusteringService.this.membersInCluster.set(newView.getMembers().size());
            if (ClusteringService.this.membersInCluster.get() > 1) {
                LOGGER.debug("There are now multiple members of cluster '{0}'; changes will be propagated throughout the cluster", new Object[]{ClusteringService.this.clusterName()});
            } else if (ClusteringService.this.membersInCluster.get() == 1) {
                LOGGER.debug("There is only one member of cluster '{0}'; changes will be propagated locally only", new Object[]{ClusteringService.this.clusterName()});
            }
        }
    }
}

