/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.engine.process;

import java.util.Iterator;
import org.modeshape.common.collection.SequentialIterator;
import org.modeshape.jcr.cache.CachedNodeSupplier;
import org.modeshape.jcr.query.BufferManager;
import org.modeshape.jcr.query.NodeSequence;
import org.modeshape.jcr.query.RowExtractors;
import org.modeshape.jcr.query.engine.process.BufferedRows;
import org.modeshape.jcr.query.engine.process.BufferingSequence;
import org.modeshape.jcr.query.model.NullOrder;

public class SortingSequence
extends BufferingSequence {
    private final BufferManager.DistinctBuffer<BufferedRows.BufferedRow> rowsWithNullKey;
    private final NullOrder nullOrder;
    private Iterator<BufferedRows.BufferedRow> bufferedRows;
    private int batchSize = 0;

    public SortingSequence(String workspaceName, NodeSequence delegate, RowExtractors.ExtractFromRow extractor, BufferManager bufferMgr, CachedNodeSupplier nodeCache, boolean pack, boolean useHeap, boolean allowDuplicates, NullOrder nullOrder) {
        super(workspaceName, delegate, extractor, bufferMgr, nodeCache, pack, useHeap, allowDuplicates);
        this.nullOrder = nullOrder;
        BufferedRows.BufferedRowFactory<? extends BufferedRows.BufferedRow> rowSerializer = BufferedRows.serializer(nodeCache, this.width);
        this.rowsWithNullKey = bufferMgr.createDistinctBuffer(rowSerializer).keepSize(true).useHeap(useHeap).make();
    }

    @Override
    public long getRowCount() {
        if (this.bufferedRows == null) {
            this.bufferedRows = this.initialize();
        }
        return super.rowCount() + this.rowsWithNullKey.size();
    }

    @Override
    public NodeSequence.Batch nextBatch() {
        if (this.bufferedRows == null) {
            this.bufferedRows = this.initialize();
        }
        if (this.remainingRowCount.get() == 0L) {
            return null;
        }
        return this.batchFrom(this.bufferedRows, this.batchSize);
    }

    protected Iterator<BufferedRows.BufferedRow> initialize() {
        this.batchSize = this.loadAll(this.delegate, this.extractor, this.rowsWithNullKey);
        this.remainingRowCount.set(this.buffer.size() + this.rowsWithNullKey.size());
        if (this.rowsWithNullKey.isEmpty()) {
            return this.buffer.ascending();
        }
        assert (this.nullOrder != null);
        switch (this.nullOrder) {
            case NULLS_FIRST: {
                return SequentialIterator.create(this.rowsWithNullKey.iterator(), this.buffer.ascending());
            }
            case NULLS_LAST: {
                return SequentialIterator.create(this.buffer.ascending(), this.rowsWithNullKey.iterator());
            }
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.rowsWithNullKey.close();
        }
    }

    public String toString() {
        return "(sorting-sequence width=" + this.width() + " order=" + this.extractor + " " + this.delegate + ")";
    }
}

