/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.DelegatingClassLoader;
import org.modeshape.common.util.StringURLClassLoader;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.Environment;

public class LocalEnvironment
implements Environment {
    public static final Class<? extends TransactionManagerLookup> DEFAULT_TRANSACTION_MANAGER_LOOKUP_CLASS = GenericTransactionManagerLookup.class;
    public static final String DEFAULT_CONFIGURATION_NAME = "defaultCacheContainer";
    private final Class<? extends TransactionManagerLookup> transactionManagerLookupClass;
    private final ConcurrentMap<String, CacheContainer> containers = new ConcurrentHashMap<String, CacheContainer>();
    private volatile boolean shared = false;
    private final Logger logger = Logger.getLogger(this.getClass());

    public LocalEnvironment() {
        this.transactionManagerLookupClass = DEFAULT_TRANSACTION_MANAGER_LOOKUP_CLASS;
    }

    public LocalEnvironment(Class<? extends TransactionManagerLookup> transactionManagerLookupClass) {
        if (transactionManagerLookupClass == null) {
            transactionManagerLookupClass = DEFAULT_TRANSACTION_MANAGER_LOOKUP_CLASS;
        }
        this.transactionManagerLookupClass = transactionManagerLookupClass;
    }

    public CacheContainer getCacheContainer() throws IOException, NamingException {
        return this.getCacheContainer(null);
    }

    @Override
    public synchronized CacheContainer getCacheContainer(String name) throws IOException, NamingException {
        CacheContainer container;
        if (name == null) {
            name = DEFAULT_CONFIGURATION_NAME;
        }
        if ((container = (CacheContainer)this.containers.get(name)) == null) {
            container = this.createContainer(name);
            this.containers.put(name, container);
        }
        return container;
    }

    @Override
    public synchronized void shutdown() {
        if (!this.shared) {
            this.doShutdown();
        }
    }

    protected void doShutdown() {
        for (CacheContainer container : this.containers.values()) {
            this.shutdown(container);
        }
        this.containers.clear();
    }

    @Override
    public ClassLoader getClassLoader(ClassLoader fallbackLoader, String ... classpathEntries) {
        StringURLClassLoader urlClassLoader;
        ArrayList<String> urls = new ArrayList<String>();
        if (classpathEntries != null) {
            for (String url : classpathEntries) {
                if (StringUtil.isBlank((String)url)) continue;
                urls.add(url);
            }
        }
        ArrayList<Object> delegatesList = new ArrayList<Object>();
        if (!urls.isEmpty() && (urlClassLoader = new StringURLClassLoader(urls)).getURLs().length > 0) {
            delegatesList.add(urlClassLoader);
        }
        ClassLoader currentLoader = this.getClass().getClassLoader();
        if (fallbackLoader != null && !fallbackLoader.equals(currentLoader)) {
            if (fallbackLoader.getParent().equals(currentLoader)) {
                currentLoader = fallbackLoader;
            } else {
                delegatesList.add(fallbackLoader);
            }
        }
        return delegatesList.isEmpty() ? currentLoader : new DelegatingClassLoader(currentLoader, delegatesList);
    }

    protected void shutdown(CacheContainer container) {
        container.stop();
    }

    protected Class<? extends TransactionManagerLookup> transactionManagerLookupClass() {
        return this.transactionManagerLookupClass;
    }

    protected TransactionManagerLookup transactionManagerLookupInstance() {
        try {
            return this.transactionManagerLookupClass().newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected CacheContainer createContainer(String configFile) throws IOException, NamingException {
        CacheContainer container = null;
        if (configFile != null && !configFile.equals(DEFAULT_CONFIGURATION_NAME)) {
            configFile = configFile.trim();
            try {
                this.logger.debug("Starting cache manager using configuration at '{0}'", new Object[]{configFile});
                container = new DefaultCacheManager(configFile);
            }
            catch (FileNotFoundException e) {
                container = (CacheContainer)this.jndiContext().lookup(configFile);
            }
        }
        if (container == null) {
            ConfigurationBuilder config = this.createDefaultConfigurationBuilder();
            GlobalConfigurationBuilder global = this.createGlobalConfigurationBuilder();
            container = this.createContainer(global, config);
        }
        return container;
    }

    protected ConfigurationBuilder createDefaultConfigurationBuilder() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        configurationBuilder.transaction().transactionManagerLookup(this.transactionManagerLookupInstance());
        configurationBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        return configurationBuilder;
    }

    protected GlobalConfigurationBuilder createGlobalConfigurationBuilder() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        return global;
    }

    protected CacheContainer createContainer(GlobalConfigurationBuilder globalConfigurationBuilder, ConfigurationBuilder configurationBuilder) {
        GlobalConfiguration globalConfiguration = globalConfigurationBuilder.build();
        Configuration configuration = configurationBuilder.build();
        this.logger.debug("Starting cache manager with global configuration \n{0}\nand default configuration:\n{1}", new Object[]{globalConfiguration, configuration});
        return new DefaultCacheManager(globalConfiguration, configuration);
    }

    @Deprecated
    protected Configuration createDefaultConfiguration() {
        return this.createDefaultConfigurationBuilder().build();
    }

    @Deprecated
    protected GlobalConfiguration createGlobalConfiguration() {
        return this.createGlobalConfigurationBuilder().build();
    }

    @Deprecated
    protected CacheContainer createContainer(GlobalConfiguration globalConfiguration, Configuration configuration) {
        this.logger.debug("Starting cache manager with global configuration \n{0}\nand default configuration:\n{1}", new Object[]{globalConfiguration, configuration});
        return new DefaultCacheManager(globalConfiguration, configuration);
    }

    protected Context jndiContext() throws NamingException {
        return new InitialContext();
    }

    public void addCacheContainerIfAbsent(String name, CacheContainer cacheContainer) {
        CheckArg.isNotNull((Object)cacheContainer, (String)"cacheContainer");
        this.containers.putIfAbsent(name, cacheContainer);
    }

    public CacheContainer addCacheContainer(String name, CacheContainer cacheContainer) {
        CheckArg.isNotNull((Object)cacheContainer, (String)"cacheContainer");
        return this.containers.put(name, cacheContainer);
    }

    public Configuration defineCache(String cacheName, Configuration configuration) {
        CheckArg.isNotNull((Object)cacheName, (String)"cacheName");
        CheckArg.isNotNull((Object)configuration, (String)"configuration");
        return this.defineCache(null, cacheName, configuration);
    }

    public Configuration defineCache(String cacheContainerName, String cacheName, Configuration configuration) {
        CacheContainer container;
        CheckArg.isNotNull((Object)cacheName, (String)"cacheName");
        CheckArg.isNotNull((Object)configuration, (String)"configuration");
        if (cacheContainerName == null) {
            cacheContainerName = DEFAULT_CONFIGURATION_NAME;
        }
        if ((container = (CacheContainer)this.containers.get(cacheContainerName)) == null) {
            Configuration config = this.createDefaultConfiguration();
            GlobalConfiguration global = this.createGlobalConfiguration();
            CacheContainer newContainer = this.createContainer(global, config);
            container = this.containers.putIfAbsent(cacheContainerName, newContainer);
            if (container == null) {
                container = newContainer;
            }
        }
        return ((EmbeddedCacheManager)container).defineConfiguration(cacheName, configuration);
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }
}

