/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.local;

import java.util.Comparator;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.index.local.IndexValues;
import org.modeshape.jcr.index.local.LocalMapIndex;
import org.modeshape.jcr.index.local.MapDB;

final class LocalDuplicateIndex<T>
extends LocalMapIndex<MapDB.UniqueKey<T>, T> {
    private static final Logger LOGGER = Logger.getLogger(LocalDuplicateIndex.class);
    private static final String NEXT_COUNTER = "next-counter";
    private final AtomicLong counter;

    static <T> LocalDuplicateIndex<T> create(String name, String workspaceName, DB db, IndexValues.Converter<T> converter, Serializer<T> valueSerializer, Comparator<T> comparator) {
        return new LocalDuplicateIndex<T>(name, workspaceName, db, converter, valueSerializer, comparator);
    }

    protected LocalDuplicateIndex(String name, String workspaceName, DB db, IndexValues.Converter<T> converter, Serializer<T> valueSerializer, Comparator<T> comparator) {
        super(name, workspaceName, db, IndexValues.uniqueKeyConverter(converter), MapDB.uniqueKeyBTreeSerializer(valueSerializer, comparator), MapDB.uniqueKeySerializer(valueSerializer, comparator));
        Long nextCounter = (Long)this.options.get(NEXT_COUNTER);
        this.counter = new AtomicLong(nextCounter != null ? nextCounter : 0L);
    }

    @Override
    public void shutdown(boolean destroyed) {
        this.options.put(NEXT_COUNTER, this.counter.get());
        super.shutdown(destroyed);
    }

    @Override
    public void add(String nodeKey, T value) {
        LOGGER.trace("Adding node '{0}' to '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, value});
        this.keysByValue.put(new MapDB.UniqueKey<T>(value, this.counter.getAndIncrement()), (Object)nodeKey);
    }

    @Override
    public void remove(String nodeKey, T value) {
        MapDB.UniqueKey<T> fromKey = new MapDB.UniqueKey<T>(value, 0L);
        MapDB.UniqueKey<T> toKey = new MapDB.UniqueKey<T>(value, Long.MAX_VALUE);
        ConcurrentNavigableMap matching = this.keysByValue.subMap(fromKey, true, toKey, true);
        for (MapDB.UniqueKey actualValue : matching.keySet()) {
            LOGGER.trace("Removing node '{0}' from '{1}' index with value '{2}'", new Object[]{nodeKey, this.name, actualValue.actualKey});
            this.keysByValue.remove((Object)actualValue);
        }
    }
}

