/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.cache.NodeKey;

final class JcrRootNode
extends AbstractJcrNode {
    private final String NAME_STR = "";
    private final String PATH = "/";
    private NodeDefinitionId rootNodeDefnId;

    protected JcrRootNode(JcrSession session, NodeKey rootNodeKey) {
        super(session, rootNodeKey);
    }

    @Override
    NodeDefinitionId nodeDefinitionId() throws RepositoryException {
        if (this.rootNodeDefnId == null) {
            this.rootNodeDefnId = this.session.workspace().nodeTypeManager().getRootNodeDefinition().getId();
        }
        return this.rootNodeDefnId;
    }

    @Override
    public JcrNodeDefinition getDefinition() throws RepositoryException {
        return this.session.workspace().nodeTypeManager().getRootNodeDefinition();
    }

    @Override
    final boolean isRoot() {
        return true;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    AbstractJcrNode.Type type() {
        return AbstractJcrNode.Type.ROOT;
    }

    public String getName() {
        return "";
    }

    public String getPath() {
        return "/";
    }

    @Override
    public AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException {
        throw new ItemNotFoundException();
    }

    @Override
    protected void doRemove() throws ConstraintViolationException, RepositoryException {
        String msg = JcrI18n.unableToRemoveRootNode.text(new Object[]{this.workspaceName()});
        throw new ConstraintViolationException(msg);
    }
}

