/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.example.sequencer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.modeshape.example.sequencer.ConsoleInput;
import org.modeshape.example.sequencer.ContentInfo;
import org.modeshape.example.sequencer.JavaInfo;
import org.modeshape.example.sequencer.MediaInfo;
import org.modeshape.example.sequencer.UserInterface;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrTools;
import org.modeshape.jcr.api.SecurityContext;
import org.modeshape.jcr.api.SecurityContextCredentials;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.sequencer.SequencingService;
import org.modeshape.sequencer.classfile.ClassFileSequencer;

public class SequencingClient {
    public static final String DEFAULT_REPOSITORY_NAME = "repo";
    public static final String DEFAULT_WORKSPACE_NAME = "default";
    public static final String DEFAULT_USERNAME = "jsmith";
    public static final char[] DEFAULT_PASSWORD = "secret".toCharArray();
    private final String repositoryName;
    private final String workspaceName;
    private final JcrConfiguration configuration;
    private JcrEngine engine;
    private UserInterface userInterface;
    private Repository repository;

    public static void main(String[] args) {
        String repositoryId = "content";
        String workspaceName = DEFAULT_WORKSPACE_NAME;
        JcrConfiguration config = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)config.repositorySource("store").usingClass(InMemoryRepositorySource.class)).setDescription("The repository for our content")).setProperty("defaultWorkspaceName", workspaceName);
        config.repository(repositoryId).addNodeTypes("sequencing.cnd").registerNamespace("class", "http://www.modeshape.org/sequencer/javaclass/1.0").setSource("store");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("Image Sequencer").usingClass("org.modeshape.sequencer.image.ImageMetadataSequencer").loadedFromClasspath()).setDescription("Sequences image files to extract the characteristics of the image")).sequencingFrom("//(*.(jpg|jpeg|gif|bmp|pcx|png|iff|ras|pbm|pgm|ppm|psd)[*])/jcr:content[@jcr:data]").andOutputtingTo("/images/$1");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("MP3 Sequencer").usingClass("org.modeshape.sequencer.mp3.Mp3MetadataSequencer").loadedFromClasspath()).setDescription("Sequences mp3 files to extract the id3 tags of the audio file")).sequencingFrom("//(*.mp3[*])/jcr:content[@jcr:data]").andOutputtingTo("/mp3s/$1");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("Java Class Sequencer").usingClass(ClassFileSequencer.class)).setDescription("Sequences Java class files to extract the structure of the classes")).sequencingFrom("//*.class[*]/jcr:content[@jcr:data]").andOutputtingTo("/classes");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("Java Sequencer").usingClass("org.modeshape.sequencer.java.JavaMetadataSequencer").loadedFromClasspath()).setDescription("Sequences Java files to extract the AST structure of the Java source code")).sequencingFrom("//(*.java[*])/jcr:content[@jcr:data]").andOutputtingTo("/java/$1");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("CSV Sequencer").usingClass("org.modeshape.sequencer.text.DelimitedTextSequencer").loadedFromClasspath()).setDescription("Sequences CSV files to extract the contents")).sequencingFrom("//(*.csv[*])/jcr:content[@jcr:data]").andOutputtingTo("/csv/$1");
        ((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)((ModeShapeConfiguration.SequencerDefinition)config.sequencer("Fixed Width Sequencer").usingClass("org.modeshape.sequencer.text.FixedWidthTextSequencer").loadedFromClasspath()).setDescription("Sequences fixed width files to extract the contents")).setProperty("commentMarker", "#")).setProperty("columnStartPositions", (Object)new int[]{10, 20, 30, 40})).sequencingFrom("//(*.txt[*])/jcr:content[@jcr:data]").andOutputtingTo("/txt/$1");
        SequencingClient client = new SequencingClient(config, repositoryId, workspaceName);
        client.setUserInterface(new ConsoleInput(client));
    }

    public SequencingClient(JcrConfiguration config, String repositoryName, String workspaceName) {
        this.configuration = config;
        this.repositoryName = repositoryName != null ? repositoryName : DEFAULT_REPOSITORY_NAME;
        this.workspaceName = workspaceName != null ? workspaceName : DEFAULT_WORKSPACE_NAME;
    }

    public void setUserInterface(UserInterface userInterface) {
        this.userInterface = userInterface;
    }

    public void startRepository() throws Exception {
        if (this.repository == null) {
            try {
                this.engine = this.configuration.build();
                this.engine.start();
                this.repository = this.engine.getRepository(this.repositoryName);
            }
            catch (Exception e) {
                this.repository = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownRepository() throws Exception {
        if (this.repository != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(4L, TimeUnit.SECONDS);
            }
            finally {
                this.repository = null;
            }
        }
    }

    public SequencingService.Statistics getStatistics() {
        return this.engine.getSequencingService().getStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile() throws Exception {
        URL url = this.userInterface.getFileToUpload();
        String filename = url.getPath().replaceAll("([^/]*/)*", "");
        String nodePath = this.userInterface.getRepositoryPath("/a/b/" + filename);
        String mimeType = this.getMimeType(url);
        if (mimeType == null) {
            System.err.println("Could not determine mime type for file " + url + ".  Cancelling upload.");
            return;
        }
        Session session = this.createSession();
        JcrTools tools = new JcrTools();
        try {
            Node node = tools.findOrCreateNode(session, nodePath, "nt:folder", "nt:file");
            Node contentNode = tools.findOrCreateChild(node, "jcr:content", "nt:resource");
            contentNode.setProperty("jcr:mimeType", mimeType);
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            Binary binaryValue = session.getValueFactory().createBinary(url.openStream());
            contentNode.setProperty("jcr:data", binaryValue);
            session.save();
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search() throws Exception {
        ArrayList<ContentInfo> infos;
        block42: {
            infos = new ArrayList<ContentInfo>();
            Session session = this.createSession();
            try {
                NodeIterator colIter;
                Node rowNode;
                NodeIterator rowIter;
                int colCount;
                Properties props;
                Node node;
                NodeIterator i;
                LinkedList<Node> nodesToVisit;
                Node root = session.getRootNode();
                if (root.hasNode("images") || root.hasNode("mp3s")) {
                    Node mediaNode;
                    NodeIterator iter;
                    Node mediasNode;
                    if (root.hasNode("images")) {
                        mediasNode = root.getNode("images");
                        iter = mediasNode.getNodes();
                        while (iter.hasNext()) {
                            mediaNode = iter.nextNode();
                            if (!mediaNode.hasNode("image:metadata")) continue;
                            infos.add(this.extractMediaInfo("image:metadata", "image", mediaNode));
                        }
                    }
                    if (root.hasNode("mp3s")) {
                        mediasNode = root.getNode("mp3s");
                        iter = mediasNode.getNodes();
                        while (iter.hasNext()) {
                            mediaNode = iter.nextNode();
                            if (!mediaNode.hasNode("mp3:metadata")) continue;
                            infos.add(this.extractMediaInfo("mp3:metadata", "mp3", mediaNode));
                        }
                    }
                }
                if (root.hasNode("zips")) {
                    nodesToVisit = new LinkedList<Node>();
                    i = root.getNode("zips").getNodes();
                    while (i.hasNext()) {
                        nodesToVisit.addLast(i.nextNode());
                    }
                    while (!nodesToVisit.isEmpty()) {
                        node = (Node)nodesToVisit.remove();
                        String nodeType = "nt:folder".equals(node.getPrimaryNodeType().getName()) ? "folder" : "file";
                        infos.add(new MediaInfo(node.getPath(), node.getName(), nodeType, new Properties()));
                        NodeIterator i2 = node.getNodes();
                        while (i2.hasNext()) {
                            nodesToVisit.addLast(i2.nextNode());
                        }
                    }
                }
                if (root.hasNode("txt")) {
                    nodesToVisit = new LinkedList();
                    i = root.getNode("txt").getNodes();
                    while (i.hasNext()) {
                        nodesToVisit.addLast(i.nextNode());
                    }
                    while (!nodesToVisit.isEmpty()) {
                        node = (Node)nodesToVisit.remove();
                        props = new Properties();
                        int rowCount = 0;
                        colCount = 0;
                        rowIter = node.getNodes();
                        while (rowIter.hasNext()) {
                            rowNode = rowIter.nextNode();
                            ++rowCount;
                            colCount = 0;
                            colIter = rowNode.getNodes();
                            while (colIter.hasNext()) {
                                colIter.nextNode();
                                ++colCount;
                            }
                        }
                        props.put("rows", String.valueOf(rowCount));
                        props.put("columns", String.valueOf(colCount));
                        infos.add(new ContentInfo(node.getPath(), node.getName(), props));
                    }
                }
                if (root.hasNode("csv")) {
                    nodesToVisit = new LinkedList();
                    i = root.getNode("csv").getNodes();
                    while (i.hasNext()) {
                        nodesToVisit.addLast(i.nextNode());
                    }
                    while (!nodesToVisit.isEmpty()) {
                        node = (Node)nodesToVisit.remove();
                        props = new Properties();
                        int rowCount = 0;
                        colCount = 0;
                        rowIter = node.getNodes();
                        while (rowIter.hasNext()) {
                            rowNode = rowIter.nextNode();
                            ++rowCount;
                            colCount = 0;
                            colIter = rowNode.getNodes();
                            while (colIter.hasNext()) {
                                colIter.nextNode();
                                ++colCount;
                            }
                        }
                        props.put("rows", String.valueOf(rowCount));
                        props.put("columns", String.valueOf(colCount));
                        infos.add(new ContentInfo(node.getPath(), node.getName(), props));
                    }
                }
                if (root.hasNode("classes")) {
                    nodesToVisit = new LinkedList();
                    i = root.getNode("classes").getNodes();
                    while (i.hasNext()) {
                        nodesToVisit.addLast(i.nextNode());
                    }
                    while (!nodesToVisit.isEmpty()) {
                        node = (Node)nodesToVisit.remove();
                        if ("class:class".equals(node.getPrimaryNodeType().getName())) {
                            props = new Properties();
                            props.put("constructors", (Object)node.getNode("class:constructors").getNodes().getSize());
                            props.put("methods", (Object)node.getNode("class:methods").getNodes().getSize());
                            props.put("fields", (Object)node.getNode("class:fields").getNodes().getSize());
                            infos.add(new MediaInfo(node.getPath(), node.getName(), "class", props));
                            continue;
                        }
                        NodeIterator i3 = node.getNodes();
                        while (i3.hasNext()) {
                            nodesToVisit.addLast(i3.nextNode());
                        }
                    }
                }
                if (!root.hasNode("java")) break block42;
                TreeMap<String, List<Properties>> tree = new TreeMap<String, List<Properties>>();
                if (!root.hasNode("java")) break block42;
                Node javaSourcesNode = root.getNode("java");
                NodeIterator i4 = javaSourcesNode.getNodes();
                while (i4.hasNext()) {
                    Node javaSourceNode = i4.nextNode();
                    if (!javaSourceNode.hasNodes()) continue;
                    Node javaCompilationUnit = javaSourceNode.getNodes().nextNode();
                    ArrayList<Properties> javaElements = new ArrayList<Properties>();
                    try {
                        Node javaPackageDeclarationNode = javaCompilationUnit.getNode("java:package/java:packageDeclaration");
                        javaElements.add(this.extractJavaInfo(javaPackageDeclarationNode));
                        tree.put("Class package", javaElements);
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    javaElements = new ArrayList();
                    try {
                        NodeIterator singleImportIterator = javaCompilationUnit.getNode("java:import/java:importDeclaration/java:singleImport").getNodes();
                        while (singleImportIterator.hasNext()) {
                            Node javasingleTypeImportDeclarationNode = singleImportIterator.nextNode();
                            javaElements.add(this.extractJavaInfo(javasingleTypeImportDeclarationNode));
                        }
                        tree.put("Class single Imports", javaElements);
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    javaElements = new ArrayList();
                    try {
                        NodeIterator javaImportOnDemandIterator = javaCompilationUnit.getNode("java:import/java:importDeclaration/java:importOnDemand").getNodes();
                        while (javaImportOnDemandIterator.hasNext()) {
                            Node javaImportOnDemandtDeclarationNode = javaImportOnDemandIterator.nextNode();
                            javaElements.add(this.extractJavaInfo(javaImportOnDemandtDeclarationNode));
                        }
                        tree.put("Class on demand imports", javaElements);
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    javaElements = new ArrayList();
                    Node javaNormalDeclarationClassNode = javaCompilationUnit.getNode("java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration");
                    javaElements.add(this.extractJavaInfo(javaNormalDeclarationClassNode));
                    tree.put("Class head information", javaElements);
                    javaElements = new ArrayList();
                    NodeIterator javaFieldTypeIterator = javaCompilationUnit.getNode("java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:field/java:fieldType").getNodes();
                    while (javaFieldTypeIterator.hasNext()) {
                        Node rootFieldTypeNode = javaFieldTypeIterator.nextNode();
                        if (rootFieldTypeNode.hasNode("java:primitiveType")) {
                            Node javaPrimitiveTypeNode = rootFieldTypeNode.getNode("java:primitiveType");
                            javaElements.add(this.extractJavaInfo(javaPrimitiveTypeNode));
                        }
                        if (rootFieldTypeNode.hasNode("java:simpleType")) {
                            Node javaSimpleTypeNode = rootFieldTypeNode.getNode("java:simpleType");
                            javaElements.add(this.extractJavaInfo(javaSimpleTypeNode));
                        }
                        if (rootFieldTypeNode.hasNode("java:parameterizedType")) {
                            Node javaParameterizedType = rootFieldTypeNode.getNode("java:parameterizedType");
                            javaElements.add(this.extractJavaInfo(javaParameterizedType));
                        }
                        if (!rootFieldTypeNode.hasNode("java:arrayType")) continue;
                        Node javaArrayType = rootFieldTypeNode.getNode("java:arrayType[2]");
                        javaElements.add(this.extractJavaInfo(javaArrayType));
                    }
                    tree.put("Class field members", javaElements);
                    javaElements = new ArrayList();
                    NodeIterator javaConstructorIterator = javaCompilationUnit.getNode("java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:constructor").getNodes();
                    while (javaConstructorIterator.hasNext()) {
                        Node javaConstructor = javaConstructorIterator.nextNode();
                        javaElements.add(this.extractJavaInfo(javaConstructor));
                    }
                    tree.put("Class constructors", javaElements);
                    javaElements = new ArrayList();
                    NodeIterator javaMethodIterator = javaCompilationUnit.getNode("java:unitType/java:classDeclaration/java:normalClass/java:normalClassDeclaration/java:method").getNodes();
                    while (javaMethodIterator.hasNext()) {
                        Node javaMethod = javaMethodIterator.nextNode();
                        javaElements.add(this.extractJavaInfo(javaMethod));
                    }
                    tree.put("Class member functions", javaElements);
                    JavaInfo javaInfo = new JavaInfo(javaCompilationUnit.getPath(), javaCompilationUnit.getName(), "java source", tree);
                    infos.add(javaInfo);
                }
            }
            finally {
                session.logout();
            }
        }
        this.userInterface.displaySearchResults(infos);
    }

    private MediaInfo extractMediaInfo(String metadataNodeName, String mediaType, Node mediaNode) throws RepositoryException, PathNotFoundException, ValueFormatException {
        String nodePath = mediaNode.getPath();
        String nodeName = mediaNode.getName();
        mediaNode = mediaNode.getNode(metadataNodeName);
        Properties props = new Properties();
        PropertyIterator propertyIter = mediaNode.getProperties();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.nextProperty();
            String name = property.getName();
            String stringValue = null;
            if (property.getDefinition().isMultiple()) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Value value : property.getValues()) {
                    if (!first) {
                        sb.append(", ");
                        first = false;
                    }
                    sb.append(value.getString());
                }
                stringValue = sb.toString();
            } else {
                stringValue = property.getValue().getString();
            }
            props.put(name, stringValue);
        }
        return new MediaInfo(nodePath, nodeName, mediaType, props);
    }

    private Properties extractJavaInfo(Node node) throws ValueFormatException, IllegalStateException, RepositoryException {
        if (node.hasProperties()) {
            Properties properties = new Properties();
            PropertyIterator propertyIter = node.getProperties();
            while (propertyIter.hasNext()) {
                Property property = propertyIter.nextProperty();
                String name = property.getName();
                String stringValue = property.getValue().getString();
                properties.put(name, stringValue);
            }
            return properties;
        }
        return null;
    }

    protected Session createSession() throws RepositoryException {
        MyCustomSecurityContext securityContext = new MyCustomSecurityContext();
        SecurityContextCredentials credentials = new SecurityContextCredentials((SecurityContext)securityContext);
        return this.repository.login((Credentials)credentials, this.workspaceName);
    }

    protected String getMimeType(URL file) {
        String filename = file.getPath().toLowerCase();
        if (filename.endsWith(".gif")) {
            return "image/gif";
        }
        if (filename.endsWith(".png")) {
            return "image/png";
        }
        if (filename.endsWith(".pict")) {
            return "image/x-pict";
        }
        if (filename.endsWith(".bmp")) {
            return "image/bmp";
        }
        if (filename.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (filename.endsWith(".jpe")) {
            return "image/jpeg";
        }
        if (filename.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (filename.endsWith(".ras")) {
            return "image/x-cmu-raster";
        }
        if (filename.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (filename.endsWith(".jar")) {
            return "application/java-archive";
        }
        if (filename.endsWith(".java")) {
            return "text/x-java-source";
        }
        if (filename.endsWith(".csv")) {
            return "text/csv";
        }
        if (filename.endsWith(".txt")) {
            return "text/plain";
        }
        if (filename.endsWith(".clazz")) {
            return "application/x-java-class";
        }
        return null;
    }

    protected class MyCustomSecurityContext
    implements SecurityContext {
        protected MyCustomSecurityContext() {
        }

        public String getUserName() {
            return "Fred";
        }

        public boolean hasRole(String roleName) {
            return true;
        }

        public void logout() {
        }
    }
}

