/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.example.sequencer;

import java.util.Map;
import java.util.Properties;
import org.modeshape.common.annotation.Immutable;

@Immutable
public class ContentInfo {
    private final Properties properties = new Properties();
    private final String name;
    private final String path;

    protected ContentInfo(String path, String name, Properties props) {
        this.name = name;
        this.path = path;
        if (props != null) {
            this.properties.putAll((Map<?, ?>)props);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getInfoType() {
        return this.getClass().getSimpleName().replaceAll("Info$", "");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("   Name: " + this.getName() + "\n");
        sb.append("   Path: " + this.getPath() + "\n");
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            sb.append("   " + entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return sb.toString();
    }
}

