/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.WebdavServlet;
import org.modeshape.web.jcr.webdav.DefaultRequestResolver;
import org.modeshape.web.jcr.webdav.ModeShapeWebdavStore;
import org.modeshape.web.jcr.webdav.RequestResolver;

public class ModeShapeWebdavServlet
extends WebdavServlet {
    private static final long serialVersionUID = 1L;
    public static final String INIT_REQUEST_RESOLVER_CLASS_NAME = "org.modeshape.web.jcr.webdav.REQUEST_RESOLVER_CLASS_NAME";
    public static final String INIT_CONTENT_PRIMARY_TYPE_NAMES = "org.modeshape.web.jcr.webdav.CONTENT_PRIMARY_TYPE_NAMES";
    public static final String INIT_RESOURCE_PRIMARY_TYPES_NAMES = "org.modeshape.web.jcr.webdav.RESOURCE_PRIMARY_TYPE_NAMES";
    public static final String INIT_NEW_FOLDER_PRIMARY_TYPE_NAME = "org.modeshape.web.jcr.webdav.NEW_FOLDER_PRIMARY_TYPE_NAME";
    public static final String INIT_NEW_RESOURCE_PRIMARY_TYPE_NAME = "org.modeshape.web.jcr.webdav.NEW_RESOURCE_PRIMARY_TYPE_NAME";
    public static final String INIT_NEW_CONTENT_PRIMARY_TYPE_NAME = "org.modeshape.web.jcr.webdav.NEW_CONTENT_PRIMARY_TYPE_NAME";
    private RequestResolver requestResolver;

    protected IWebdavStore constructStore(String clazzName, File root) {
        return new ModeShapeWebdavStore(this.getInitParameter(INIT_CONTENT_PRIMARY_TYPE_NAMES), this.getInitParameter(INIT_RESOURCE_PRIMARY_TYPES_NAMES), this.getInitParameter(INIT_NEW_FOLDER_PRIMARY_TYPE_NAME), this.getInitParameter(INIT_NEW_RESOURCE_PRIMARY_TYPE_NAME), this.getInitParameter(INIT_NEW_CONTENT_PRIMARY_TYPE_NAME), this.requestResolver);
    }

    private void constructRequestResolver() {
        String requestResolverClassName = this.getInitParameter(INIT_REQUEST_RESOLVER_CLASS_NAME);
        if (requestResolverClassName == null) {
            this.requestResolver = new DefaultRequestResolver();
        } else {
            try {
                Class<RequestResolver> clazz = Class.forName(requestResolverClassName).asSubclass(RequestResolver.class);
                this.requestResolver = clazz.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        this.requestResolver.initialize(this.getServletContext());
    }

    public void init() throws ServletException {
        this.constructRequestResolver();
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ModeShapeWebdavStore.setRequest(req);
        try {
            super.service(req, resp);
        }
        finally {
            ModeShapeWebdavStore.setRequest(null);
        }
    }
}

