/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.WebdavException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.mimetype.aperture.ApertureMimeTypeDetector;
import org.modeshape.web.jcr.RepositoryFactory;
import org.modeshape.web.jcr.webdav.RequestResolver;
import org.modeshape.web.jcr.webdav.ResolvedRequest;
import org.modeshape.web.jcr.webdav.UriResolver;
import org.modeshape.web.jcr.webdav.WebdavI18n;

public class ModeShapeWebdavStore
implements IWebdavStore {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ThreadLocal<HttpServletRequest> THREAD_LOCAL_REQUEST = new ThreadLocal();
    private static final Map<String, byte[]> OSX_DOUBLE_DATA = Collections.synchronizedMap(new WeakHashMap());
    private static final String CONTENT_NODE_NAME = "jcr:content";
    private static final String DATA_PROP_NAME = "jcr:data";
    private static final String CREATED_PROP_NAME = "jcr:created";
    private static final String MODIFIED_PROP_NAME = "jcr:lastModified";
    private static final String ENCODING_PROP_NAME = "jcr:encoding";
    private static final String MIME_TYPE_PROP_NAME = "jcr:mimeType";
    private static final String DEFAULT_CONTENT_PRIMARY_TYPES = "nt:resource, mode:resource";
    private static final String DEFAULT_RESOURCE_PRIMARY_TYPES = "nt:file";
    private static final String DEFAULT_NEW_FOLDER_PRIMARY_TYPE = "nt:folder";
    private static final String DEFAULT_NEW_RESOURCE_PRIMARY_TYPE = "nt:file";
    private static final String DEFAULT_NEW_CONTENT_PRIMARY_TYPE = "mode:resource";
    private final Collection<String> contentPrimaryTypes;
    private final Collection<String> filePrimaryTypes;
    private final String newFolderPrimaryType;
    private final String newResourcePrimaryType;
    private final String newContentPrimaryType;
    private final MimeTypeDetector mimeTypeDetector = new ApertureMimeTypeDetector();
    private final RequestResolver uriResolver;

    public ModeShapeWebdavStore(RequestResolver uriResolver) {
        this(null, null, null, null, null, uriResolver);
    }

    public ModeShapeWebdavStore(String contentPrimaryTypes, String filePrimaryTypes, String newFolderPrimaryType, String newResourcePrimaryType, String newContentPrimaryType, RequestResolver uriResolver) {
        this.contentPrimaryTypes = ModeShapeWebdavStore.split(contentPrimaryTypes != null ? contentPrimaryTypes : DEFAULT_CONTENT_PRIMARY_TYPES);
        this.filePrimaryTypes = ModeShapeWebdavStore.split(filePrimaryTypes != null ? filePrimaryTypes : "nt:file");
        this.newFolderPrimaryType = newFolderPrimaryType != null ? newFolderPrimaryType : DEFAULT_NEW_FOLDER_PRIMARY_TYPE;
        this.newResourcePrimaryType = newResourcePrimaryType != null ? newResourcePrimaryType : "nt:file";
        this.newContentPrimaryType = newContentPrimaryType != null ? newContentPrimaryType : DEFAULT_NEW_CONTENT_PRIMARY_TYPE;
        this.uriResolver = uriResolver;
    }

    private static final Set<String> setFor(String ... elements) {
        HashSet<String> set = new HashSet<String>(elements.length);
        set.addAll(Arrays.asList(elements));
        return set;
    }

    private static final Set<String> split(String commaDelimitedString) {
        return ModeShapeWebdavStore.setFor(commaDelimitedString.split("\\s*,\\s*"));
    }

    static final void setRequest(HttpServletRequest request) {
        THREAD_LOCAL_REQUEST.set(request);
    }

    public ITransaction begin(Principal principal) {
        return new JcrSessionTransaction(principal);
    }

    public void commit(ITransaction transaction) {
        CheckArg.isNotNull((Object)transaction, (String)"transaction");
        assert (transaction instanceof JcrSessionTransaction);
        ((JcrSessionTransaction)transaction).commit();
    }

    public void rollback(ITransaction transaction) {
    }

    public void checkAuthentication(ITransaction transaction) {
    }

    public void createFolder(ITransaction transaction, String folderUri) {
        int ind = folderUri.lastIndexOf(47);
        String parentUri = folderUri.substring(0, ind + 1);
        String resourceName = folderUri.substring(ind + 1);
        try {
            Node parentNode = this.nodeFor(transaction, parentUri);
            parentNode.addNode(resourceName, this.newFolderPrimaryType);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public void createResource(ITransaction transaction, String resourceUri) {
        if (resourceUri.endsWith(".DS_Store")) {
            return;
        }
        int ind = resourceUri.lastIndexOf(47);
        String parentUri = resourceUri.substring(0, ind + 1);
        String resourceName = resourceUri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(resourceUri, null);
            return;
        }
        try {
            Node parentNode = this.nodeFor(transaction, parentUri);
            Node resourceNode = parentNode.addNode(resourceName, this.newResourcePrimaryType);
            Node contentNode = resourceNode.addNode(CONTENT_NODE_NAME, this.newContentPrimaryType);
            contentNode.setProperty(DATA_PROP_NAME, "");
            contentNode.setProperty(MODIFIED_PROP_NAME, Calendar.getInstance());
            contentNode.setProperty(ENCODING_PROP_NAME, "UTF-8");
            contentNode.setProperty(MIME_TYPE_PROP_NAME, "text/plain");
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public String[] getChildrenNames(ITransaction transaction, String folderUri) {
        try {
            Node node = this.nodeFor(transaction, folderUri);
            if (this.isFile(node) || this.isContent(node)) {
                return null;
            }
            LinkedList<String> children = new LinkedList<String>();
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                children.add(iter.nextNode().getName());
            }
            return children.toArray(EMPTY_STRING_ARRAY);
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public InputStream getResourceContent(ITransaction transaction, String resourceUri) {
        try {
            Node node = this.nodeFor(transaction, resourceUri);
            if (!this.isFile(node)) {
                return null;
            }
            if (!node.hasNode(CONTENT_NODE_NAME)) {
                return null;
            }
            return node.getProperty("jcr:content/jcr:data").getBinary().getStream();
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public long getResourceLength(ITransaction transaction, String path) {
        try {
            Node node = this.nodeFor(transaction, path);
            if (!this.isFile(node)) {
                return -1L;
            }
            if (!node.hasNode(CONTENT_NODE_NAME)) {
                return -1L;
            }
            Property contentProp = node.getProperty("jcr:content/jcr:data");
            long length = contentProp.getLength();
            if (length != -1L) {
                return length;
            }
            String data = contentProp.getString();
            return data.length();
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        if (uri.length() == 0) {
            uri = "/";
        }
        StoredObject ob = new StoredObject();
        try {
            Node node = this.nodeFor(transaction, uri);
            if (this.isContent(node)) {
                return null;
            }
            if (!this.isFile(node)) {
                ob.setFolder(true);
                ob.setCreationDate(new Date());
                ob.setLastModified(new Date());
                ob.setResourceLength(0L);
            } else if (node.hasNode(CONTENT_NODE_NAME)) {
                Node content = node.getNode(CONTENT_NODE_NAME);
                ob.setFolder(false);
                Date createDate = node.hasProperty(CREATED_PROP_NAME) ? node.getProperty(CREATED_PROP_NAME).getDate().getTime() : new Date();
                ob.setCreationDate(createDate);
                ob.setLastModified(content.getProperty(MODIFIED_PROP_NAME).getDate().getTime());
                ob.setResourceLength(content.getProperty(DATA_PROP_NAME).getLength());
            } else {
                ob.setNullResource(true);
            }
        }
        catch (PathNotFoundException pnfe) {
            return null;
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
        return ob;
    }

    public void removeObject(ITransaction transaction, String uri) {
        int ind = uri.lastIndexOf(47);
        String resourceName = uri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(uri, null);
            return;
        }
        try {
            this.nodeFor(transaction, uri).remove();
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
    }

    public long setResourceContent(ITransaction transaction, String resourceUri, InputStream content, String contentType, String characterEncoding) {
        if (resourceUri.endsWith(".DS_Store")) {
            return 0L;
        }
        int ind = resourceUri.lastIndexOf(47);
        String resourceName = resourceUri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            try {
                OSX_DOUBLE_DATA.put(resourceUri, IoUtil.readBytes((InputStream)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 0L;
        }
        try {
            Node node = this.nodeFor(transaction, resourceUri);
            if (!this.isFile(node)) {
                return -1L;
            }
            Node contentNode = node.hasNode(CONTENT_NODE_NAME) ? node.getNode(CONTENT_NODE_NAME) : node.addNode(CONTENT_NODE_NAME, this.newContentPrimaryType);
            contentNode.setProperty(ENCODING_PROP_NAME, characterEncoding != null ? characterEncoding : "UTF-8");
            Binary binary = node.getSession().getValueFactory().createBinary(content);
            contentNode.setProperty(DATA_PROP_NAME, binary);
            contentNode.setProperty(MODIFIED_PROP_NAME, Calendar.getInstance());
            if (contentType == null) {
                contentType = this.mimeTypeDetector.mimeTypeOf(resourceName, binary.getStream());
            }
            return contentNode.getProperty(DATA_PROP_NAME).getLength();
        }
        catch (RepositoryException re) {
            throw new WebdavException((Throwable)re);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RuntimeException t) {
            throw t;
        }
    }

    private boolean isContent(Node node) throws RepositoryException {
        for (String nodeType : this.contentPrimaryTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isFile(Node node) throws RepositoryException {
        for (String nodeType : this.filePrimaryTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    private final Node nodeFor(ITransaction transaction, String uri) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).nodeFor(uri);
    }

    protected final RequestResolver uriResolver() {
        return this.uriResolver;
    }

    class JcrSessionTransaction
    implements ITransaction {
        private final Principal principal;
        private final Session session;
        private final UriResolver uriResolver;

        JcrSessionTransaction(Principal principal) {
            this.principal = principal;
            HttpServletRequest request = (HttpServletRequest)THREAD_LOCAL_REQUEST.get();
            if (request == null) {
                throw new WebdavException(WebdavI18n.noStoredRequest.text(new Object[0]));
            }
            try {
                ResolvedRequest resolvedRequest = ModeShapeWebdavStore.this.uriResolver().resolve(request);
                this.session = RepositoryFactory.getSession((HttpServletRequest)request, (String)resolvedRequest.getRepositoryName(), (String)resolvedRequest.getWorkspaceName());
                this.uriResolver = resolvedRequest.getUriResolver();
                assert (this.session != null);
            }
            catch (RepositoryException re) {
                throw new WebdavException((Throwable)re);
            }
        }

        Session session() {
            return this.session;
        }

        Node nodeFor(String uri) throws RepositoryException {
            String resolvedUri = this.uriResolver.resolve(uri);
            Item item = this.session.getItem(resolvedUri);
            if (item instanceof Property) {
                throw new WebdavException();
            }
            return (Node)item;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        void commit() {
            try {
                this.session.save();
            }
            catch (RepositoryException re) {
                throw new WebdavException((Throwable)re);
            }
        }
    }
}

