/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.simple;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Query;
import javax.persistence.Table;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.util.SecureHash;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.property.PropertyType;

@Entity
@Table(name="MODE_SIMPLE_LARGE_VALUES")
@NamedQueries(value={@NamedQuery(name="LargeValueEntity.selectUnused", query="select largeValue.hash from LargeValueEntity largeValue where largeValue.hash not in (select values.hash from NodeEntity node join node.largeValues values)"), @NamedQuery(name="LargeValueEntity.deleteAllUnused", query="delete LargeValueEntity lve where lve.hash not in (select values.hash from NodeEntity node join node.largeValues values)"), @NamedQuery(name="LargeValueEntity.deleteIn", query="delete LargeValueEntity lve where lve.hash in (:inValues)")})
public class LargeValueEntity {
    @Id
    @Column(name="SHA1", nullable=false, length=40)
    private String hash;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE", nullable=false)
    private PropertyType type;
    @Column(name="LENGTH", nullable=false)
    private long length;
    @Column(name="COMPRESSED", nullable=true)
    private Boolean compressed;
    @Lob
    @Column(name="DATA", nullable=false)
    private byte[] data;

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public PropertyType getType() {
        return this.type;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isCompressed() {
        return this.compressed != null && this.compressed != false;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LargeValueEntity) {
            LargeValueEntity that = (LargeValueEntity)obj;
            if (this.getHash().equals(that.getHash())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Large " + this.type + " value (hash=" + this.getHash() + ",compressed=" + this.isCompressed() + ")";
    }

    public static int deleteUnused(EntityManager manager, String dialect) {
        assert (manager != null);
        int result = 0;
        if (dialect.toLowerCase().indexOf("mysql") != -1) {
            int toIndex;
            Query select = manager.createNamedQuery("LargeValueEntity.selectUnused");
            List hashes = select.getResultList();
            if (hashes.isEmpty()) {
                return 0;
            }
            int endIndex = hashes.size();
            int fromIndex = 0;
            do {
                toIndex = Math.min(fromIndex + 20, endIndex);
                Query query = manager.createNamedQuery("LargeValueEntity.deleteIn");
                query.setParameter("inValues", hashes.subList(fromIndex, toIndex));
                query.executeUpdate();
                result += toIndex - fromIndex;
            } while ((fromIndex = toIndex) < endIndex);
        } else {
            Query delete = manager.createNamedQuery("LargeValueEntity.deleteAllUnused");
            result = delete.executeUpdate();
        }
        manager.flush();
        return result;
    }

    private static byte[] computeHash(byte[] value) {
        try {
            return SecureHash.getHash((SecureHash.Algorithm)SecureHash.Algorithm.SHA_1, (byte[])value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemFailureException((Throwable)e);
        }
    }

    public static LargeValueEntity create(byte[] data, PropertyType type, boolean compressed) {
        try {
            String hashStr = StringUtil.getHexString((byte[])LargeValueEntity.computeHash(data));
            LargeValueEntity entity = new LargeValueEntity();
            entity.setData(data);
            entity.setType(type);
            entity.setCompressed(compressed);
            entity.setHash(hashStr);
            return entity;
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
    }
}

