/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.AcceptParameterHttpPreprocessor;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.interceptors.SecurityInterceptor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.jboss.resteasy.util.GetRestful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyDeployment {
    protected boolean deploymentSensitiveFactoryEnabled = false;
    protected boolean asyncJobServiceEnabled = false;
    protected int asyncJobServiceMaxJobResults = 100;
    protected long asyncJobServiceMaxWait = 300000L;
    protected int asyncJobServiceThreadPoolSize = 100;
    protected String asyncJobServiceBasePath = "/asynch/jobs";
    protected String applicationClass;
    protected Application application;
    protected boolean registerBuiltin = true;
    protected List<String> providerClasses = new ArrayList<String>();
    protected List<Class> actualProviderClasses = new ArrayList<Class>();
    protected List<Object> providers = new ArrayList<Object>();
    protected boolean securityEnabled = false;
    protected List<String> jndiResources = new ArrayList<String>();
    protected List<String> resourceClasses = new ArrayList<String>();
    protected List<Class> actualResourceClasses = new ArrayList<Class>();
    protected List<Object> resources = new ArrayList<Object>();
    protected Map<String, String> mediaTypeMappings = new HashMap<String, String>();
    protected Map<String, String> languageExtensions = new HashMap<String, String>();
    protected List<String> interceptorPrecedences = new ArrayList<String>();
    protected Map<String, String> interceptorBeforePrecedences = new HashMap<String, String>();
    protected Map<String, String> interceptorAfterPrecedences = new HashMap<String, String>();
    protected Registry registry;
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    protected String paramMapping;
    private static final Logger logger = LoggerFactory.getLogger(ResteasyDeployment.class);

    public void start() {
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactory();
        }
        if (this.deploymentSensitiveFactoryEnabled) {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (!(defaultInstance instanceof ThreadLocalResteasyProviderFactory)) {
                ResteasyProviderFactory.setInstance(new ThreadLocalResteasyProviderFactory(defaultInstance));
            }
        } else {
            ResteasyProviderFactory.setInstance(this.providerFactory);
        }
        if (this.asyncJobServiceEnabled) {
            AsynchronousDispatcher asyncDispatcher = new AsynchronousDispatcher(this.providerFactory);
            asyncDispatcher.setMaxCacheSize(this.asyncJobServiceMaxJobResults);
            asyncDispatcher.setMaxWaitMilliSeconds(this.asyncJobServiceMaxWait);
            asyncDispatcher.setThreadPoolSize(this.asyncJobServiceThreadPoolSize);
            asyncDispatcher.setBasePath(this.asyncJobServiceBasePath);
            this.dispatcher = asyncDispatcher;
            asyncDispatcher.start();
        } else {
            this.dispatcher = new SynchronousDispatcher(this.providerFactory);
        }
        this.registry = this.dispatcher.getRegistry();
        if (this.interceptorPrecedences != null) {
            for (String string : this.interceptorPrecedences) {
                this.providerFactory.appendInterceptorPrecedence(string.trim());
            }
        }
        if (this.interceptorBeforePrecedences != null) {
            for (Map.Entry entry : this.interceptorBeforePrecedences.entrySet()) {
                this.providerFactory.insertInterceptorPrecedenceBefore(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
            }
        }
        if (this.interceptorAfterPrecedences != null) {
            for (Map.Entry entry : this.interceptorAfterPrecedences.entrySet()) {
                this.providerFactory.insertInterceptorPrecedenceAfter(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
            }
        }
        if (this.securityEnabled) {
            this.providerFactory.getServerPreProcessInterceptorRegistry().register((PreProcessInterceptor)((Object)SecurityInterceptor.class));
        }
        if (this.registerBuiltin) {
            RegisterBuiltin.register(this.providerFactory);
        }
        if (this.applicationClass != null) {
            try {
                this.application = (Application)Thread.currentThread().getContextClassLoader().loadClass(this.applicationClass).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        this.registration();
        if (this.paramMapping != null) {
            this.dispatcher.addHttpPreprocessor(new AcceptParameterHttpPreprocessor(this.paramMapping));
        }
        if (this.mediaTypeMappings != null) {
            HashMap<String, MediaType> extMap = new HashMap<String, MediaType>();
            for (Map.Entry<String, String> ext : this.mediaTypeMappings.entrySet()) {
                String value = ext.getValue();
                extMap.put(ext.getKey().trim(), MediaType.valueOf((String)value.trim()));
            }
            if (this.dispatcher.getMediaTypeMappings() != null) {
                this.dispatcher.getMediaTypeMappings().putAll(extMap);
            } else {
                this.dispatcher.setMediaTypeMappings(extMap);
            }
        }
        if (this.languageExtensions != null) {
            if (this.dispatcher.getLanguageMappings() != null) {
                this.dispatcher.getLanguageMappings().putAll(this.languageExtensions);
            } else {
                this.dispatcher.setLanguageMappings(this.languageExtensions);
            }
        }
    }

    public void registration() {
        if (this.application != null) {
            this.processApplication(this.application);
        }
        if (this.providerClasses != null) {
            for (String string : this.providerClasses) {
                this.registerProvider(string);
            }
        }
        if (this.providers != null) {
            for (Object object : this.providers) {
                this.providerFactory.registerProviderInstance(object);
            }
        }
        for (Class clazz : this.actualProviderClasses) {
            this.providerFactory.registerProvider(clazz);
        }
        if (this.jndiResources != null) {
            for (String string : this.jndiResources) {
                this.registry.addJndiResource(string.trim());
            }
        }
        if (this.resourceClasses != null) {
            for (String string : this.resourceClasses) {
                Class<?> clazz = null;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(string.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.registry.addPerRequestResource(clazz);
            }
        }
        if (this.resources != null) {
            for (Object object : this.resources) {
                this.registry.addSingletonResource(object);
            }
        }
        for (Class clazz : this.actualResourceClasses) {
            this.registry.addPerRequestResource(clazz);
        }
    }

    public void stop() {
    }

    protected void processApplication(Application config) {
        logger.info("Deploying " + Application.class.getName() + ": " + config.getClass());
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (GetRestful.isRootResource(clazz)) {
                    this.actualResourceClasses.add(clazz);
                    continue;
                }
                if (clazz.isAnnotationPresent(Provider.class)) {
                    this.actualProviderClasses.add(clazz);
                    continue;
                }
                throw new RuntimeException("Application.getClasses() returned unknown class type: " + clazz.getName());
            }
        }
        if (config.getSingletons() != null) {
            for (Object obj : config.getSingletons()) {
                if (GetRestful.isRootResource(obj.getClass())) {
                    logger.info("Adding singleton resource " + obj.getClass().getName() + " from Application " + Application.class.getName());
                    this.resources.add(obj);
                    continue;
                }
                if (obj.getClass().isAnnotationPresent(Provider.class)) {
                    this.providers.add(obj);
                    continue;
                }
                throw new RuntimeException("Application.getSingletons() returned unknown class type: " + obj.getClass().getName());
            }
        }
    }

    protected void registerProvider(String clazz) {
        Class<?> provider = null;
        try {
            provider = Thread.currentThread().getContextClassLoader().loadClass(clazz.trim());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.providerFactory.registerProvider(provider);
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public boolean isDeploymentSensitiveFactoryEnabled() {
        return this.deploymentSensitiveFactoryEnabled;
    }

    public void setDeploymentSensitiveFactoryEnabled(boolean deploymentSensitiveFactoryEnabled) {
        this.deploymentSensitiveFactoryEnabled = deploymentSensitiveFactoryEnabled;
    }

    public boolean isAsyncJobServiceEnabled() {
        return this.asyncJobServiceEnabled;
    }

    public void setAsyncJobServiceEnabled(boolean asyncJobServiceEnabled) {
        this.asyncJobServiceEnabled = asyncJobServiceEnabled;
    }

    public int getAsyncJobServiceMaxJobResults() {
        return this.asyncJobServiceMaxJobResults;
    }

    public void setAsyncJobServiceMaxJobResults(int asyncJobServiceMaxJobResults) {
        this.asyncJobServiceMaxJobResults = asyncJobServiceMaxJobResults;
    }

    public long getAsyncJobServiceMaxWait() {
        return this.asyncJobServiceMaxWait;
    }

    public void setAsyncJobServiceMaxWait(long asyncJobServiceMaxWait) {
        this.asyncJobServiceMaxWait = asyncJobServiceMaxWait;
    }

    public int getAsyncJobServiceThreadPoolSize() {
        return this.asyncJobServiceThreadPoolSize;
    }

    public void setAsyncJobServiceThreadPoolSize(int asyncJobServiceThreadPoolSize) {
        this.asyncJobServiceThreadPoolSize = asyncJobServiceThreadPoolSize;
    }

    public String getAsyncJobServiceBasePath() {
        return this.asyncJobServiceBasePath;
    }

    public void setAsyncJobServiceBasePath(String asyncJobServiceBasePath) {
        this.asyncJobServiceBasePath = asyncJobServiceBasePath;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public boolean isRegisterBuiltin() {
        return this.registerBuiltin;
    }

    public void setRegisterBuiltin(boolean registerBuiltin) {
        this.registerBuiltin = registerBuiltin;
    }

    public List<String> getProviderClasses() {
        return this.providerClasses;
    }

    public void setProviderClasses(List<String> providerClasses) {
        this.providerClasses = providerClasses;
    }

    public List<Object> getProviders() {
        return this.providers;
    }

    public void setProviders(List<Object> providers) {
        this.providers = providers;
    }

    public List<Class> getActualProviderClasses() {
        return this.actualProviderClasses;
    }

    public void setActualProviderClasses(List<Class> actualProviderClasses) {
        this.actualProviderClasses = actualProviderClasses;
    }

    public List<Class> getActualResourceClasses() {
        return this.actualResourceClasses;
    }

    public void setActualResourceClasses(List<Class> actualResourceClasses) {
        this.actualResourceClasses = actualResourceClasses;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public List<String> getJndiResources() {
        return this.jndiResources;
    }

    public void setJndiResources(List<String> jndiResources) {
        this.jndiResources = jndiResources;
    }

    public List<String> getResourceClasses() {
        return this.resourceClasses;
    }

    public void setResourceClasses(List<String> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public Map<String, String> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    public void setMediaTypeMappings(Map<String, String> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    public List<Object> getResources() {
        return this.resources;
    }

    public void setResources(List<Object> resources) {
        this.resources = resources;
    }

    public Map<String, String> getLanguageExtensions() {
        return this.languageExtensions;
    }

    public void setLanguageExtensions(Map<String, String> languageExtensions) {
        this.languageExtensions = languageExtensions;
    }

    public List<String> getInterceptorPrecedences() {
        return this.interceptorPrecedences;
    }

    public void setInterceptorPrecedences(List<String> interceptorPrecedences) {
        this.interceptorPrecedences = interceptorPrecedences;
    }

    public Map<String, String> getInterceptorBeforePrecedences() {
        return this.interceptorBeforePrecedences;
    }

    public void setInterceptorBeforePrecedences(Map<String, String> interceptorBeforePrecedences) {
        this.interceptorBeforePrecedences = interceptorBeforePrecedences;
    }

    public Map<String, String> getInterceptorAfterPrecedences() {
        return this.interceptorAfterPrecedences;
    }

    public void setInterceptorAfterPrecedences(Map<String, String> interceptorAfterPrecedences) {
        this.interceptorAfterPrecedences = interceptorAfterPrecedences;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setMediaTypeParamMapping(String paramMapping) {
        this.paramMapping = paramMapping;
    }
}

