/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;

@Immutable
public class StringReference
implements Reference {
    private static final long serialVersionUID = 2299467578161645109L;
    private String id;

    public StringReference(String id) {
        this.id = id;
    }

    @Override
    public String getString() {
        return this.id;
    }

    @Override
    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        return encoder.encode(this.getString());
    }

    @Override
    public int compareTo(Reference that) {
        if (this == that) {
            return 0;
        }
        if (that instanceof StringReference) {
            return this.id.compareTo(((StringReference)that).getString());
        }
        return this.getString().compareTo(that.getString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Reference) {
            return this.id.equals(((Reference)obj).getString());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.id;
    }
}

