/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.RequestType;

public class ReadPropertyRequest
extends CacheableRequest {
    private static final long serialVersionUID = 1L;
    private final Location on;
    private final String workspaceName;
    private final Name propertyName;
    private Property property;
    private Location actualLocation;

    public ReadPropertyRequest(Location on, String workspaceName, Name propertyName) {
        CheckArg.isNotNull((Object)on, (String)"on");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.on = on;
        this.propertyName = propertyName;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location on() {
        return this.on;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public Name named() {
        return this.propertyName;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setProperty(Property property) {
        this.checkNotFrozen();
        if (property != null) {
            CheckArg.isEquals((Object)property.getName(), (String)"property's name", (Object)this.named(), (String)"property name");
        }
        this.property = property;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)actual, (String)"actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
        this.property = null;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.on, this.workspaceName, this.propertyName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadPropertyRequest that = (ReadPropertyRequest)obj;
            if (!this.on().isSame(that.on())) {
                return false;
            }
            if (!this.named().equals(that.named())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        return "read " + this.named() + " property on " + this.on() + " in the \"" + this.workspaceName + "\" workspace";
    }

    @Override
    public RequestType getType() {
        return RequestType.READ_PROPERTY;
    }
}

