/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.cnd;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.modeshape.cnd.CndImporter;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.cnd.CndSequencerI18n;

public class CndSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        OutputDestination destination = new OutputDestination(output, context);
        Path root = context.getValueFactories().getPathFactory().createRootPath();
        CndImporter importer = new CndImporter((Destination)destination, root);
        String resourceName = context.getInputPath().getString(context.getNamespaceRegistry());
        try {
            importer.importFrom(stream, context.getProblems(), resourceName);
        }
        catch (IOException e) {
            context.getProblems().addError((Throwable)e, CndSequencerI18n.errorSequencingCndContent, new Object[]{e.getLocalizedMessage()});
        }
    }

    protected class OutputDestination
    implements Destination {
        private final SequencerOutput output;
        private final StreamSequencerContext context;

        protected OutputDestination(SequencerOutput output, StreamSequencerContext context) {
            this.output = output;
            this.context = context;
        }

        public ExecutionContext getExecutionContext() {
            return this.context;
        }

        public void create(Path path, List<Property> properties) {
            for (Property property : properties) {
                this.output.setProperty(path, property.getName(), new Object[]{property.getValues()});
            }
        }

        public void create(Path path, Property firstProperty, Property ... additionalProperties) {
            this.output.setProperty(path, firstProperty.getName(), new Object[]{firstProperty.getValues()});
            for (Property property : additionalProperties) {
                this.output.setProperty(path, property.getName(), new Object[]{property.getValues()});
            }
        }

        public void setProperties(Path path, Property ... properties) {
            for (Property property : properties) {
                this.output.setProperty(path, property.getName(), new Object[]{property.getValues()});
            }
        }

        public void submit() {
        }
    }
}

