/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.cnd.CndImporter;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.basic.GraphNamespaceRegistry;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeEngine;

@ThreadSafe
public class JcrEngine
extends ModeShapeEngine
implements Repositories {
    static final int LOCK_SWEEP_INTERVAL_IN_MILLIS = 30000;
    static final int LOCK_EXTENSION_INTERVAL_IN_MILLIS = 60000;
    private static final Logger log = Logger.getLogger(ModeShapeEngine.class);
    private final Map<String, JcrRepository> repositories;
    private final Lock repositoriesLock;
    private final Map<String, Object> descriptors = new HashMap<String, Object>();
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(2);

    JcrEngine(ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configuration) {
        super(context, configuration);
        this.repositories = new HashMap<String, JcrRepository>();
        this.repositoriesLock = new ReentrantLock();
        this.initDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpLocks() {
        ArrayList<JcrRepository> repos;
        try {
            this.repositoriesLock.lock();
            repos = new ArrayList<JcrRepository>(this.repositories.values());
        }
        finally {
            this.repositoriesLock.unlock();
        }
        for (JcrRepository repository : repos) {
            try {
                repository.getRepositoryLockManager().cleanUpLocks();
            }
            catch (Throwable t) {
                log.error(t, JcrI18n.errorCleaningUpLocks, new Object[]{repository.getRepositorySourceName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preShutdown() {
        this.scheduler.shutdown();
        super.preShutdown();
        try {
            this.repositoriesLock.lock();
            for (JcrRepository repository : this.repositories.values()) {
                repository.close();
            }
            this.repositories.clear();
        }
        finally {
            this.repositoriesLock.unlock();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.scheduler.awaitTermination(timeout, unit)) {
            return false;
        }
        return super.awaitTermination(timeout, unit);
    }

    public void start() {
        super.start();
        final JcrEngine engine = this;
        Runnable cleanUpTask = new Runnable(){

            @Override
            public void run() {
                engine.cleanUpLocks();
            }
        };
        this.scheduler.scheduleAtFixedRate(cleanUpTask, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public String getEngineVersion() {
        return JcrRepository.getBundleProperty("jcr.repository.version", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JcrRepository getRepository(String repositoryName) throws RepositoryException {
        CheckArg.isNotEmpty((String)repositoryName, (String)"repositoryName");
        this.checkRunning();
        try {
            this.repositoriesLock.lock();
            JcrRepository repository = this.repositories.get(repositoryName);
            if (repository == null) {
                try {
                    repository = this.doCreateJcrRepository(repositoryName);
                }
                catch (PathNotFoundException e) {
                    String msg = JcrI18n.repositoryDoesNotExist.text(new Object[]{repositoryName});
                    throw new RepositoryException(msg);
                }
                this.repositories.put(repositoryName, repository);
            }
            JcrRepository jcrRepository = repository;
            return jcrRepository;
        }
        finally {
            this.repositoriesLock.unlock();
        }
    }

    public Set<String> getRepositoryNames() {
        this.checkRunning();
        HashSet<String> results = new HashSet<String>();
        PathFactory pathFactory = this.getExecutionContext().getValueFactories().getPathFactory();
        Path repositoriesPath = pathFactory.create(this.configuration.getPath(), new Name[]{ModeShapeLexicon.REPOSITORIES});
        Graph configuration = this.getConfigurationGraph();
        for (Location child : (List)configuration.getChildren().of(repositoriesPath)) {
            Name repositoryName = child.getPath().getLastSegment().getName();
            results.add(this.readable(repositoryName));
        }
        return Collections.unmodifiableSet(results);
    }

    protected JcrRepository doCreateJcrRepository(String repositoryName) throws RepositoryException, PathNotFoundException {
        Property property;
        SubgraphNode descriptorsNode;
        RepositoryConnectionFactory connectionFactory = this.getRepositoryConnectionFactory();
        HashMap<String, String> descriptors = new HashMap<String, String>();
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        PathFactory pathFactory = this.getExecutionContext().getValueFactories().getPathFactory();
        Path repositoriesPath = pathFactory.create(this.configuration.getPath(), new Name[]{ModeShapeLexicon.REPOSITORIES});
        Path repositoryPath = pathFactory.create(repositoriesPath, repositoryName);
        Graph configuration = this.getConfigurationGraph();
        Subgraph subgraph = (Subgraph)configuration.getSubgraphOfDepth(6).at(repositoryPath);
        SubgraphNode optionsNode = subgraph.getNode(ModeShapeLexicon.OPTIONS);
        if (optionsNode != null) {
            for (Location optionLocation : optionsNode.getChildren()) {
                JcrRepository.Option option;
                Node optionNode = configuration.getNodeAt(optionLocation);
                Path.Segment segment = optionLocation.getPath().getLastSegment();
                Property valueProperty = optionNode.getProperty(ModeShapeLexicon.VALUE);
                if (valueProperty == null || (option = JcrRepository.Option.findOption(segment.getName().getLocalName())) == null) continue;
                options.put(option, valueProperty.getFirstValue().toString());
            }
        }
        if ((descriptorsNode = subgraph.getNode(ModeShapeLexicon.DESCRIPTORS)) != null) {
            for (Location descriptorLocation : descriptorsNode.getChildren()) {
                Node optionNode = configuration.getNodeAt(descriptorLocation);
                Path.Segment segment = descriptorLocation.getPath().getLastSegment();
                Property valueProperty = optionNode.getProperty(ModeShapeLexicon.VALUE);
                if (valueProperty == null) continue;
                descriptors.put(segment.getName().getLocalName(), valueProperty.getFirstValue().toString());
            }
        }
        ExecutionContext context = this.getExecutionContext();
        SubgraphNode namespacesNode = subgraph.getNode(ModeShapeLexicon.NAMESPACES);
        descriptors.put("custom.rep.name", repositoryName);
        if (namespacesNode != null) {
            GraphNamespaceRegistry registry = new GraphNamespaceRegistry(configuration, namespacesNode.getLocation().getPath(), ModeShapeLexicon.URI, new Property[0]);
            context = context.with((NamespaceRegistry)registry);
        }
        if ((property = subgraph.getRoot().getProperty(ModeShapeLexicon.SOURCE_NAME)) == null || property.isEmpty()) {
            String readableName = this.readable(ModeShapeLexicon.SOURCE_NAME);
            String readablePath = this.readable(subgraph.getLocation());
            String msg = JcrI18n.propertyNotFoundOnNode.text(new Object[]{readableName, readablePath, configuration.getCurrentWorkspaceName()});
            throw new RepositoryException(msg);
        }
        String sourceName = (String)context.getValueFactories().getStringFactory().create(property.getFirstValue());
        RepositorySource source = this.getRepositorySource(sourceName);
        RepositorySourceCapabilities capabilities = source != null ? source.getCapabilities() : null;
        JcrRepository repository = new JcrRepository(context, connectionFactory, sourceName, (Observable)this.getRepositoryService().getRepositoryLibrary(), capabilities, descriptors, options);
        SubgraphNode nodeTypesNode = subgraph.getNode(JcrLexicon.NODE_TYPES);
        if (nodeTypesNode != null) {
            boolean needToRefreshSubgraph = false;
            Property resourceProperty = nodeTypesNode.getProperty(ModeShapeLexicon.RESOURCE);
            if (resourceProperty != null) {
                for (Object resourceValue : resourceProperty) {
                    String resources = (String)this.context.getValueFactories().getStringFactory().create(resourceValue);
                    for (String resource : resources.split("\\s*,\\s*")) {
                        Graph.Batch batch = configuration.batch();
                        GraphBatchDestination destination = new GraphBatchDestination(batch);
                        Path nodeTypesPath = pathFactory.create(repositoryPath, new Name[]{JcrLexicon.NODE_TYPES});
                        CndImporter importer = new CndImporter((Destination)destination, nodeTypesPath, true);
                        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
                        SimpleProblems cndProblems = new SimpleProblems();
                        try {
                            if (is != null) {
                                importer.importFrom(is, (Problems)cndProblems, resource);
                                batch.execute();
                                needToRefreshSubgraph = true;
                            }
                        }
                        catch (IOException ioe) {
                            String msg = JcrI18n.errorLoadingNodeTypeDefintions.text(new Object[]{resource, ioe.getMessage()});
                            throw new RepositoryException(msg, (Throwable)ioe);
                        }
                        if (cndProblems.isEmpty()) continue;
                        this.getProblems().addAll((Iterable)cndProblems);
                        if (!cndProblems.hasErrors()) continue;
                        String msg = null;
                        Throwable cause = null;
                        for (Problem problem : cndProblems) {
                            if (problem.getStatus() != Problem.Status.ERROR) continue;
                            msg = problem.getMessageString();
                            cause = problem.getThrowable();
                            break;
                        }
                        throw new RepositoryException(JcrI18n.errorLoadingNodeTypeDefintions.text(new Object[]{resource, msg}), cause);
                    }
                }
            }
            NamespaceRegistry repoRegistry = repository.getExecutionContext().getNamespaceRegistry();
            for (NamespaceRegistry.Namespace namespace : configuration.getContext().getNamespaceRegistry().getNamespaces()) {
                if (repoRegistry.isRegisteredNamespaceUri(namespace.getNamespaceUri())) continue;
                repoRegistry.register(namespace.getPrefix(), namespace.getNamespaceUri());
            }
            Subgraph nodeTypesSubgraph = subgraph;
            if (needToRefreshSubgraph) {
                nodeTypesSubgraph = (Subgraph)configuration.getSubgraphOfDepth(4).at(nodeTypesNode.getLocation().getPath());
            }
            repository.getRepositoryTypeManager().registerNodeTypes(nodeTypesSubgraph, nodeTypesNode.getLocation());
        }
        return repository;
    }

    protected final String readable(Name name) {
        return name.getString(this.context.getNamespaceRegistry());
    }

    protected final String readable(Path path) {
        return path.getString(this.context.getNamespaceRegistry());
    }

    protected final String readable(Location location) {
        return location.getString(this.context.getNamespaceRegistry());
    }

    public Map<String, Object> initDescriptors() {
        ValueFactories factories = this.getExecutionContext().getValueFactories();
        this.descriptors.put("jcr.specification.name", JcrEngine.valueFor(factories, JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
        this.descriptors.put("jcr.specification.version", JcrEngine.valueFor(factories, "2.0"));
        if (!this.descriptors.containsKey("jcr.repository.name")) {
            this.descriptors.put("jcr.repository.name", JcrEngine.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.name", true)));
        }
        if (!this.descriptors.containsKey("jcr.repository.vendor")) {
            this.descriptors.put("jcr.repository.vendor", JcrEngine.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor", true)));
        }
        if (!this.descriptors.containsKey("jcr.repository.vendor.url")) {
            this.descriptors.put("jcr.repository.vendor.url", JcrEngine.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor.url", true)));
        }
        if (!this.descriptors.containsKey("jcr.repository.version")) {
            this.descriptors.put("jcr.repository.version", JcrEngine.valueFor(factories, this.getEngineVersion()));
        }
        return this.descriptors;
    }

    private static JcrValue valueFor(ValueFactories valueFactories, int type, Object value) {
        return new JcrValue(valueFactories, null, type, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, String value) {
        return JcrEngine.valueFor(valueFactories, 1, value);
    }
}

