/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.util.concurrent.TimeUnit;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.jboss.managed.JBossManagedI18n;
import org.modeshape.jboss.managed.ModeShapeManagedObject;

@ManagementObject(description="A ModeShape connector (repository source)", componentType=@ManagementComponent(type="ModeShape", subtype="Connector"), properties=ManagementProperties.EXPLICIT)
public class ManagedConnector
implements ModeShapeManagedObject {
    private final RepositorySource connector;

    protected ManagedConnector() {
        this.connector = null;
    }

    public ManagedConnector(RepositorySource connector) {
        CheckArg.isNotNull((Object)connector, (String)"connector");
        this.connector = connector;
    }

    @ManagementProperty(name="Retry Limit", description="The maximum number of retries to perform on an operation", readOnly=false, use={ViewUse.RUNTIME})
    public int getRetryLimit() {
        return this.connector.getRetryLimit();
    }

    @ManagementProperty(name="Connector Name", description="The name of the repository source", readOnly=true, use={ViewUse.CONFIGURATION})
    @ManagementObjectID(prefix="ModeShape-")
    public String getName() {
        return this.connector.getName();
    }

    @ManagementProperty(name="Supports Creating Workspaces", description="Indicates if creating workspaces is allowed", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingCreatingWorkspaces() {
        return this.connector.getCapabilities().supportsCreatingWorkspaces();
    }

    @ManagementProperty(name="Supports Events", description="Indicates if the publishing of changes events is supported", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingEvents() {
        return this.connector.getCapabilities().supportsEvents();
    }

    @ManagementProperty(name="Supports Locks", description="Indicates if locks can be created", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingLocks() {
        return this.connector.getCapabilities().supportsLocks();
    }

    @ManagementProperty(name="Supports Queries", description="Indicates if queries are supported", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingQueries() {
        return this.connector.getCapabilities().supportsQueries();
    }

    @ManagementProperty(name="Supports References", description="Indicates if references by identifiers are supported", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingReferences() {
        return this.connector.getCapabilities().supportsReferences();
    }

    @ManagementProperty(name="Supports Same Name Siblings", description="Indicates if siblings can have the same name", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingSameNameSiblings() {
        return this.connector.getCapabilities().supportsSameNameSiblings();
    }

    @ManagementProperty(name="Supports Searches", description="Indicates if full-text searches are supported", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingSearches() {
        return this.connector.getCapabilities().supportsSearches();
    }

    @ManagementProperty(name="Supports Updates", description="Indicates if updates can be made to the repository source", readOnly=true, use={ViewUse.CONFIGURATION})
    public boolean isSupportingUpdates() {
        return this.connector.getCapabilities().supportsUpdates();
    }

    @ManagementOperation(description="Indicates if the connection is valid and alive", impact=ManagedOperation.Impact.ReadOnly)
    public boolean ping() {
        try {
            return this.connector.getConnection().ping(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).log(Logger.Level.ERROR, (Throwable)e, JBossManagedI18n.errorDeterminingIfConnectionIsAlive, new Object[]{this.connector.getName()});
            return false;
        }
    }

    public void setRetryLimit(int limit) {
        CheckArg.isNonNegative((int)limit, (String)"limit");
        this.connector.setRetryLimit(limit);
    }
}

