/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.joda.time.DateTime;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jboss.managed.ManagedLock;
import org.modeshape.jboss.managed.ManagedRepositoryMapper;
import org.modeshape.jboss.managed.ManagedSession;
import org.modeshape.jboss.managed.ModeShapeManagedObject;
import org.modeshape.jcr.JcrRepository;

@MetaMapping(value=ManagedRepositoryMapper.class)
public class ManagedRepository
implements ModeShapeManagedObject {
    private final Map<String, String> descriptors;
    private final Map<String, String> options;
    private final JcrRepository repository;
    private String name;
    private String version;

    public ManagedRepository() {
        this.repository = null;
        this.options = null;
        this.descriptors = null;
    }

    public ManagedRepository(JcrRepository repository) {
        CheckArg.isNotNull((Object)repository, (String)"repository");
        this.repository = repository;
        HashMap tempOptions = new HashMap();
        for (Map.Entry entry : this.repository.getOptions().entrySet()) {
            tempOptions.put(((JcrRepository.Option)entry.getKey()).toString(), entry.getValue());
        }
        this.options = Collections.unmodifiableMap(tempOptions);
        HashMap<String, String> tempDescriptors = new HashMap<String, String>();
        for (String descriptorName : this.repository.getDescriptorKeys()) {
            tempDescriptors.put(descriptorName, this.repository.getDescriptor(descriptorName));
        }
        this.descriptors = Collections.unmodifiableMap(tempDescriptors);
    }

    @ManagementProperty(name="Name", description="The name of this repository", readOnly=true, use={ViewUse.CONFIGURATION})
    public String getName() {
        if (this.descriptors != null) {
            return this.descriptors.get("custom.rep.name");
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManagementProperty(name="Version", description="The JCR version supported by this repository", readOnly=true, use={ViewUse.CONFIGURATION})
    public String getVersion() {
        if (this.descriptors != null) {
            return this.descriptors.get("jcr.specification.version") + " " + this.descriptors.get("jcr.specification.name");
        }
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ManagementProperty(name="Query Activity", description="The number of queries executed", use={ViewUse.STATISTIC})
    public int getQueryActivity() {
        return 0;
    }

    @ManagementProperty(name="Save Activity", description="The number of nodes saved", use={ViewUse.STATISTIC})
    public int getSaveActivity() {
        return 0;
    }

    @ManagementProperty(name="Session Activity", description="The number of sessions created", use={ViewUse.STATISTIC})
    public Object getSessionActivity() {
        return 0;
    }

    @ManagementOperation(description="Obtains all the managed locks sorted by the owner", impact=ManagedOperation.Impact.ReadOnly)
    public List<ManagedLock> listLocks() {
        return this.listLocks(ManagedLock.SORT_BY_OWNER);
    }

    public List<ManagedLock> listLocks(Comparator<ManagedLock> lockSorter) {
        CheckArg.isNotNull(lockSorter, (String)"lockSorter");
        ArrayList<ManagedLock> locks = new ArrayList<ManagedLock>();
        for (int i = 0; i < 5; ++i) {
            locks.add(new ManagedLock("workspace-" + i, true, "sessionId-1", new DateTime(), "id-" + i, "owner-" + i, true));
        }
        Collections.sort(locks, lockSorter);
        return locks;
    }

    @ManagementOperation(description="Obtains the managed sessions sorted by user name", impact=ManagedOperation.Impact.ReadOnly)
    public List<ManagedSession> listSessions() {
        return this.listSessions(ManagedSession.SORT_BY_USER);
    }

    public List<ManagedSession> listSessions(Comparator<ManagedSession> sessionSorter) {
        CheckArg.isNotNull(sessionSorter, (String)"sessionSorter");
        ArrayList<ManagedSession> sessions = new ArrayList<ManagedSession>();
        for (int i = 0; i < 5; ++i) {
            sessions.add(new ManagedSession("workspace-" + i, "userName-" + i, "sessionId-1", new DateTime()));
        }
        Collections.sort(sessions, sessionSorter);
        return sessions;
    }

    @ManagementOperation(description="Removes the lock with the specified ID", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="lockId", description="The lock identifier")})
    public boolean removeLock(String lockId) {
        return false;
    }

    @ManagementOperation(description="Terminates the session with the specified ID", impact=ManagedOperation.Impact.WriteOnly, params={@ManagementParameter(name="sessionId", description="The session identifier")})
    public boolean terminateSession(String sessionId) {
        return false;
    }
}

