/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import net.jcip.annotations.Immutable;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jboss.managed.ModeShapeManagedObject;
import org.modeshape.repository.sequencer.SequencingService;

@Immutable
@ManagementObject(name="ModeShapeSequencingService", description="A ModeShape sequencing service", componentType=@ManagementComponent(type="ModeShape", subtype="SequencingService"), properties=ManagementProperties.EXPLICIT)
public class ManagedSequencingService
implements ModeShapeManagedObject {
    private final SequencingService sequencingService;

    protected ManagedSequencingService() {
        this.sequencingService = null;
    }

    public ManagedSequencingService(SequencingService sequencingService) {
        CheckArg.isNotNull((Object)sequencingService, (String)"sequencingService");
        this.sequencingService = sequencingService;
    }

    @ManagementProperty(name="Job Activity", description="The number of sequencing jobs executed", readOnly=true, use={ViewUse.STATISTIC})
    public int getJobActivity() {
        return 0;
    }

    @ManagementProperty(name="Nodes Sequenced", description="The number of nodes that have been sequenced", readOnly=true, use={ViewUse.STATISTIC})
    public long getNodesSequencedCount() {
        return this.sequencingService.getStatistics().getNumberOfNodesSequenced();
    }

    @ManagementProperty(name="Nodes Skipped", description="The number of nodes skipped (not sequenced)", readOnly=true, use={ViewUse.STATISTIC})
    public long getNodesSkippedCount() {
        return this.sequencingService.getStatistics().getNumberOfNodesSkipped();
    }

    @ManagementProperty(name="Queued Jobs", description="The number of queued jobs", readOnly=true, use={ViewUse.STATISTIC})
    public int getQueuedJobCount() {
        return 0;
    }

    @ManagementProperty(name="Start Time", description="The time the sequencing statistics (sequenced, skipped) began", readOnly=true, use={ViewUse.RUNTIME})
    public long getStartTime() {
        return this.sequencingService.getStatistics().getStartTime();
    }

    @ManagementOperation(description="Obtains the list of queued managed jobs", impact=ManagedOperation.Impact.ReadOnly)
    public Object listQueuedJobs() {
        return null;
    }
}

