/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.zip.ZipI18n;
import org.modeshape.sequencer.zip.ZipLexicon;

public class ZipSequencer
implements StreamSequencer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
        DateTimeFactory dateFactory = context.getValueFactories().getDateFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        NameFactory nameFactory = context.getValueFactories().getNameFactory();
        Path pathToArchiveFile = context.getInputPath();
        Name zipFileName = null;
        if (pathToArchiveFile != null && !pathToArchiveFile.isRoot()) {
            if (pathToArchiveFile.getLastSegment().getName().equals(JcrLexicon.CONTENT)) {
                pathToArchiveFile = pathToArchiveFile.getParent();
            }
            if (!pathToArchiveFile.isRoot()) {
                zipFileName = pathToArchiveFile.getLastSegment().getName();
            }
        }
        if (zipFileName == null) {
            zipFileName = ZipLexicon.CONTENT;
        }
        DateTime now = dateFactory.create();
        String username = context.getSecurityContext().getUserName();
        MimeTypeDetector mimeDetector = context.getMimeTypeDetector();
        ZipInputStream in = null;
        in = new ZipInputStream(stream);
        ZipEntry entry = in.getNextEntry();
        byte[] buf = new byte[1024];
        Path zipPath = pathFactory.createRelativePath(new Name[]{zipFileName});
        output.setProperty(zipPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ZipLexicon.FILE});
        while (entry != null) {
            Path entryPath = zipPath;
            String entryName = entry.getName();
            for (String segment : entryName.split(File.separator)) {
                entryPath = pathFactory.create(entryPath, new Name[]{(Name)nameFactory.create(segment)});
            }
            long time = entry.getTime();
            DateTime dateTime = time != -1L ? (DateTime)dateFactory.create(time) : now;
            output.setProperty(entryPath, JcrLexicon.CREATED, new Object[]{dateTime});
            if (username != null) {
                output.setProperty(entryPath, JcrLexicon.CREATED_BY, new Object[]{username});
            }
            if (entry.isDirectory()) {
                output.setProperty(entryPath, JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER});
            } else {
                String mimeType;
                int n;
                output.setProperty(entryPath, JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE});
                Path contentPath = pathFactory.create(entryPath, new Name[]{JcrLexicon.CONTENT});
                output.setProperty(contentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.RESOURCE});
                ByteArrayOutputStream baout = new ByteArrayOutputStream();
                while ((n = in.read(buf, 0, 1024)) > -1) {
                    baout.write(buf, 0, n);
                }
                byte[] bytes = baout.toByteArray();
                output.setProperty(contentPath, JcrLexicon.DATA, new Object[]{binaryFactory.create(bytes)});
                output.setProperty(contentPath, JcrLexicon.LAST_MODIFIED, new Object[]{dateTime});
                if (username != null) {
                    output.setProperty(contentPath, JcrLexicon.LAST_MODIFIED_BY, new Object[]{username});
                }
                if ((mimeType = mimeDetector.mimeTypeOf(entryName, null)) != null) {
                    output.setProperty(contentPath, JcrLexicon.MIMETYPE, new Object[]{mimeType});
                }
            }
            in.closeEntry();
            entry = in.getNextEntry();
        }
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Exception e) {
            String location = (String)context.getValueFactories().getStringFactory().create(context.getInputPath());
            context.getProblems().addError((Throwable)e, ZipI18n.errorClosingZipFile, new Object[]{location, e.getMessage()});
        }
        return;
        catch (Exception e) {
            String location;
            try {
                location = (String)context.getValueFactories().getStringFactory().create(context.getInputPath());
                context.getProblems().addError((Throwable)e, ZipI18n.errorReadingZipFile, new Object[]{location, e.getMessage()});
                if (in == null) return;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    String location2 = (String)context.getValueFactories().getStringFactory().create(context.getInputPath());
                    context.getProblems().addError((Throwable)e2, ZipI18n.errorClosingZipFile, new Object[]{location2, e2.getMessage()});
                }
                throw throwable;
            }
            try {
                in.close();
                return;
            }
            catch (Exception e3) {
                location = (String)context.getValueFactories().getStringFactory().create(context.getInputPath());
                context.getProblems().addError((Throwable)e3, ZipI18n.errorClosingZipFile, new Object[]{location, e3.getMessage()});
            }
            return;
        }
    }
}

