/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.PropertyType;
import javax.jcr.query.RowIterator;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrQueryResult;

public class JcrSqlQueryResult
extends JcrQueryResult {
    public static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    public static final String JCR_PATH_COLUMN_NAME = "jcr:path";
    public static final String JCR_SCORE_COLUMN_TYPE = PropertyType.nameFromValue((int)4).toUpperCase();
    public static final String JCR_PATH_COLUMN_TYPE = PropertyType.nameFromValue((int)1).toUpperCase();
    private final List<String> columnNames;
    private final List<String> columnTypes;

    public JcrSqlQueryResult(JcrQueryContext context, String query, QueryResults graphResults, Schemata schemata) {
        super(context, query, graphResults, schemata);
        LinkedList<String> columnNames = new LinkedList<String>(graphResults.getColumns().getColumnNames());
        LinkedList<String> columnTypes = new LinkedList<String>(graphResults.getColumns().getColumnTypes());
        if (!columnNames.contains(JCR_SCORE_COLUMN_NAME)) {
            columnNames.add(0, JCR_SCORE_COLUMN_NAME);
            columnTypes.add(0, JCR_SCORE_COLUMN_TYPE);
        }
        if (!columnNames.contains(JCR_PATH_COLUMN_NAME)) {
            columnNames.add(0, JCR_PATH_COLUMN_NAME);
            columnTypes.add(0, JCR_PATH_COLUMN_TYPE);
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
        this.columnTypes = Collections.unmodifiableList(columnTypes);
    }

    @Override
    public List<String> getColumnNameList() {
        return this.columnNames;
    }

    @Override
    public List<String> getColumnTypeList() {
        return this.columnTypes;
    }

    @Override
    public RowIterator getRows() {
        int numRows = this.results.getRowCount();
        List tuples = this.results.getTuples();
        return new JcrQueryResult.SingleSelectorQueryResultRowIterator(this.context, this.queryStatement, this.results, tuples.iterator(), numRows);
    }
}

