/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAccessor
implements DataAccessor {
    public static final String FILE_KEY = "file";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DataObject getDataObject(String string, DataSource dataSource, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        return this.get(string, dataSource, null, map, rDFContainerFactory);
    }

    public DataObject getDataObjectIfModified(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        return this.get(string, dataSource, accessData, map, rDFContainerFactory);
    }

    private DataObject get(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        Object object;
        if (!string.startsWith("file:")) {
            throw new IllegalArgumentException("non-file scheme: " + string);
        }
        File file = this.getFile(string, map);
        if (!file.exists()) {
            throw new UrlNotFoundException(string);
        }
        boolean bl = file.isFile();
        boolean bl2 = file.isDirectory();
        if (!bl && !bl2) {
            this.logger.warn("not a file nor a folder: " + file);
        }
        if (accessData != null) {
            long l = file.lastModified();
            object = accessData.get(string, "date");
            if (object != null) {
                try {
                    long l2 = Long.parseLong((String)object);
                    if (l2 == l) {
                        return null;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.error("illegal long: " + (String)object, (Throwable)numberFormatException);
                }
            }
            accessData.put(string, "date", String.valueOf(l));
        }
        URI uRI = this.toURI(file);
        boolean bl3 = true;
        if (map != null && map.get("suppressParentChildLinks") != null && map.get("suppressParentChildLinks").equals(Boolean.TRUE)) {
            bl3 = false;
        }
        object = this.createMetadata(file, uRI, bl, bl2, bl3, rDFContainerFactory);
        DataObject dataObject = null;
        if (bl) {
            if (file.canRead()) {
                dataObject = new FileDataObjectBase(uRI, dataSource, (RDFContainer)object, file);
            }
            dataObject.getMetadata().add(RDF.type, (Node)NFO.FileDataObject);
        } else {
            dataObject = bl2 ? new FolderDataObjectBase(uRI, dataSource, (RDFContainer)object) : new DataObjectBase(uRI, dataSource, (RDFContainer)object);
        }
        return dataObject;
    }

    private File getFile(String string, Map map) throws IOException {
        Object object;
        if (map != null && (object = map.get(FILE_KEY)) instanceof File) {
            return (File)object;
        }
        try {
            object = new java.net.URI(string);
            return new File((java.net.URI)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("invalid url");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    private RDFContainer createMetadata(File file, URI uRI, boolean bl, boolean bl2, boolean bl3, RDFContainerFactory rDFContainerFactory) {
        File file2;
        String string;
        RDFContainer rDFContainer = rDFContainerFactory.getRDFContainer(uRI);
        rDFContainer.add(RDF.type, (Node)NFO.FileDataObject);
        long l = file.lastModified();
        if (l != 0L) {
            rDFContainer.add(NFO.fileLastModified, new Date(l));
        }
        if ((string = file.getName()) != null) {
            rDFContainer.add(NFO.fileName, string);
        }
        if ((file2 = file.getParentFile()) != null) {
            rDFContainer.add(NFO.belongsToContainer, (Node)this.toURI(file2));
            rDFContainer.add(rDFContainer.getModel().createStatement((Resource)this.toURI(file2), RDF.type, (Node)NFO.Folder));
        }
        if (bl) {
            long l2 = file.length();
            rDFContainer.add(NFO.fileSize, l2);
        } else if (bl2 && bl3) {
            final RDFContainer rDFContainer2 = rDFContainer;
            file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (file != null) {
                        rDFContainer2.add(NIE.hasPart, (Node)FileAccessor.this.toURI(file));
                        rDFContainer2.add(rDFContainer2.getModel().createStatement((Resource)FileAccessor.this.toURI(file), RDF.type, (Node)NFO.FileDataObject));
                    }
                    return false;
                }
            });
        }
        return rDFContainer;
    }

    private URI toURI(File file) {
        return URIImpl.createURIWithoutChecking((String)file.toURI().toString());
    }
}

