/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.datasource.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.datasource.config.UrlPattern;
import org.semanticdesktop.aperture.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExpPattern
extends UrlPattern {
    private Pattern pattern;

    public RegExpPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public RegExpPattern(String string) {
        this(Pattern.compile(string));
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPatternString() {
        return this.pattern.pattern();
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String string) {
        this.pattern = Pattern.compile(string);
    }

    @Override
    public boolean matches(String string) {
        return this.pattern.matcher(string).matches();
    }

    @Override
    public Collection<Statement> getStatements(Model model, Resource resource) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        arrayList.add(ModelUtil.createStatement(model, resource, RDF.type, (Node)DATASOURCE.RegExpPattern));
        try {
            arrayList.add(ModelUtil.createStatement(model, resource, RDF.value, (Node)ModelUtil.createLiteral(model, this.getPatternString(), XSD._string)));
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object instanceof RegExpPattern) {
            RegExpPattern regExpPattern = (RegExpPattern)object;
            bl = this.getPatternString().equals(regExpPattern.getPatternString());
        }
        return bl;
    }

    public int hashCode() {
        return this.getPatternString().hashCode();
    }
}

