/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.text;

import net.jcip.annotations.Immutable;

@Immutable
public final class Position {
    public static final Position EMPTY_CONTENT_POSITION = new Position(-1, 1, 0);
    private final int line;
    private final int column;
    private final int indexInContent;

    public Position(int indexInContent, int line, int column) {
        this.indexInContent = indexInContent < 0 ? -1 : indexInContent;
        this.line = line;
        this.column = column;
        assert (this.indexInContent >= -1);
        assert (this.line > 0);
        assert (this.column >= 0);
        assert (this.indexInContent >= 0 || this.line == 1 && this.column == 0);
    }

    public int getIndexInContent() {
        return this.indexInContent;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int hashCode() {
        return this.indexInContent;
    }

    public String toString() {
        return "" + this.indexInContent + ':' + this.line + ':' + this.column;
    }

    public Position add(Position position) {
        if (this.getIndexInContent() < 0) {
            return position.getIndexInContent() < 0 ? EMPTY_CONTENT_POSITION : position;
        }
        if (position.getIndexInContent() < 0) {
            return this;
        }
        int index = this.getIndexInContent() + position.getIndexInContent();
        int line = position.getLine() + this.getLine() - 1;
        int column = this.getLine() == 1 ? this.getColumn() + position.getColumn() : this.getColumn();
        return new Position(index, line, column);
    }
}

