/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.UUID;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.manager.CacheContainer;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.infinispan.InfinispanConnectorI18n;
import org.modeshape.connector.infinispan.InfinispanRepository;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Connection;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.observe.Observer;

@ThreadSafe
public abstract class BaseInfinispanSource
implements BaseRepositorySource,
ObjectFactory {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_LIMIT = 0;
    public static final String DEFAULT_ROOT_NODE_UUID = "cafebabe-cafe-babe-cafe-babecafebabe";
    public static final String DEFAULT_NAME_OF_DEFAULT_WORKSPACE = "default";
    public static final boolean DEFAULT_UPDATES_ALLOWED = true;
    protected static final String ROOT_NODE_UUID = "rootNodeUuid";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String DEFAULT_CACHE_POLICY = "defaultCachePolicy";
    protected static final String RETRY_LIMIT = "retryLimit";
    protected static final String DEFAULT_WORKSPACE = "defaultWorkspace";
    protected static final String PREDEFINED_WORKSPACE_NAMES = "predefinedWorkspaceNames";
    protected static final String ALLOW_CREATING_WORKSPACES = "allowCreatingWorkspaces";
    protected static final String UPDATES_ALLOWED = "updatesAllowed";
    @Description(i18n=InfinispanConnectorI18n.class, value="namePropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="namePropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="namePropertyCategory")
    private volatile String name;
    @Description(i18n=InfinispanConnectorI18n.class, value="rootNodeUuidPropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="rootNodeUuidPropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="rootNodeUuidPropertyCategory")
    private volatile UUID rootNodeUuid = UUID.fromString("cafebabe-cafe-babe-cafe-babecafebabe");
    @Description(i18n=InfinispanConnectorI18n.class, value="retryLimitPropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="retryLimitPropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="retryLimitPropertyCategory")
    private volatile int retryLimit = 0;
    @Description(i18n=InfinispanConnectorI18n.class, value="defaultWorkspaceNamePropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="defaultWorkspaceNamePropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="defaultWorkspaceNamePropertyCategory")
    private volatile String defaultWorkspace;
    @Description(i18n=InfinispanConnectorI18n.class, value="predefinedWorkspacesPropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="predefinedWorkspacesPropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="predefinedWorkspacesPropertyCategory")
    private volatile String[] predefinedWorkspaces = new String[0];
    @Description(i18n=InfinispanConnectorI18n.class, value="updatesAllowedPropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="updatesAllowedPropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="updatesAllowedPropertyCategory")
    private volatile boolean updatesAllowed = true;
    private volatile CachePolicy defaultCachePolicy;
    private volatile RepositorySourceCapabilities capabilities = new RepositorySourceCapabilities(true, true, false, true, false);
    private transient InfinispanRepository repository;
    private transient Context jndiContext;
    private transient RepositoryContext repositoryContext;

    public void initialize(RepositoryContext context) throws RepositorySourceException {
        this.repositoryContext = context;
    }

    public String getName() {
        return this.name;
    }

    public RepositorySourceCapabilities getCapabilities() {
        return this.capabilities;
    }

    public int getRetryLimit() {
        return this.retryLimit;
    }

    public synchronized void setRetryLimit(int limit) {
        this.retryLimit = limit < 0 ? 0 : limit;
    }

    public synchronized void setName(String name) {
        if (this.name == name || this.name != null && this.name.equals(name)) {
            return;
        }
        this.name = name;
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public synchronized void setDefaultCachePolicy(CachePolicy defaultCachePolicy) {
        if (this.defaultCachePolicy == defaultCachePolicy || this.defaultCachePolicy != null && this.defaultCachePolicy.equals(defaultCachePolicy)) {
            return;
        }
        this.defaultCachePolicy = defaultCachePolicy;
    }

    public String getRootNodeUuid() {
        return this.rootNodeUuid.toString();
    }

    public UUID getRootNodeUuidObject() {
        return this.rootNodeUuid;
    }

    public synchronized void setRootNodeUuid(String rootNodeUuid) {
        UUID uuid = null;
        uuid = rootNodeUuid == null ? UUID.randomUUID() : UUID.fromString(rootNodeUuid);
        if (this.rootNodeUuid.equals(uuid)) {
            return;
        }
        this.rootNodeUuid = uuid;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public synchronized void setDefaultWorkspaceName(String nameOfDefaultWorkspace) {
        this.defaultWorkspace = nameOfDefaultWorkspace != null ? nameOfDefaultWorkspace : DEFAULT_NAME_OF_DEFAULT_WORKSPACE;
    }

    public synchronized String[] getPredefinedWorkspaceNames() {
        String[] copy = new String[this.predefinedWorkspaces.length];
        System.arraycopy(this.predefinedWorkspaces, 0, copy, 0, this.predefinedWorkspaces.length);
        return copy;
    }

    public synchronized void setPredefinedWorkspaceNames(String[] predefinedWorkspaceNames) {
        if (predefinedWorkspaceNames != null && predefinedWorkspaceNames.length == 1) {
            predefinedWorkspaceNames = predefinedWorkspaceNames[0].split("\\s*,\\s*");
        }
        this.predefinedWorkspaces = predefinedWorkspaceNames;
    }

    public boolean isCreatingWorkspacesAllowed() {
        return this.capabilities.supportsCreatingWorkspaces();
    }

    public synchronized void setCreatingWorkspacesAllowed(boolean allowWorkspaceCreation) {
        this.capabilities = new RepositorySourceCapabilities(true, this.capabilities.supportsUpdates(), false, allowWorkspaceCreation, this.capabilities.supportsReferences());
    }

    protected abstract CacheContainer createCacheContainer();

    final CacheContainer cacheContainer() {
        return this.repository.getCacheContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.repository != null) {
            try {
                this.repository.shutdown();
            }
            finally {
                this.repository = null;
            }
        }
    }

    public RepositoryContext getRepositoryContext() {
        return this.repositoryContext;
    }

    protected Observer getObserver() {
        return this.repositoryContext != null ? this.repositoryContext.getObserver() : null;
    }

    protected synchronized Context getContext() {
        return this.jndiContext;
    }

    protected synchronized void setContext(Context context) {
        this.jndiContext = context;
    }

    public boolean areUpdatesAllowed() {
        return this.updatesAllowed;
    }

    public void setUpdatesAllowed(boolean updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
    }

    public synchronized RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.getName() == null) {
            I18n msg = InfinispanConnectorI18n.propertyIsRequired;
            throw new RepositorySourceException(this.getName(), msg.text(new Object[]{"name"}));
        }
        if (this.repository == null) {
            Context context = this.getContext();
            if (context == null) {
                try {
                    context = new InitialContext();
                }
                catch (NamingException err) {
                    throw new RepositorySourceException(this.name, (Throwable)err);
                }
            }
            CacheContainer cacheContainer = this.createCacheContainer();
            this.repository = new InfinispanRepository(this, cacheContainer);
        }
        return new Connection((BaseRepositorySource)this, (Repository)this.repository);
    }

    public synchronized Reference getReference() {
        String className = this.getClass().getName();
        String managerClassName = this.getClass().getName();
        Reference ref = new Reference(className, managerClassName, null);
        ref.add(new StringRefAddr(SOURCE_NAME, this.getName()));
        ref.add(new StringRefAddr(ROOT_NODE_UUID, this.getRootNodeUuid().toString()));
        ref.add(new StringRefAddr(RETRY_LIMIT, Integer.toString(this.getRetryLimit())));
        ref.add(new StringRefAddr(DEFAULT_WORKSPACE, this.getDefaultWorkspaceName()));
        ref.add(new StringRefAddr(UPDATES_ALLOWED, String.valueOf(this.areUpdatesAllowed())));
        ref.add(new StringRefAddr(ALLOW_CREATING_WORKSPACES, Boolean.toString(this.isCreatingWorkspacesAllowed())));
        String[] workspaceNames = this.getPredefinedWorkspaceNames();
        if (workspaceNames != null && workspaceNames.length != 0) {
            ref.add(new StringRefAddr(PREDEFINED_WORKSPACE_NAMES, StringUtil.combineLines((String[])workspaceNames)));
        }
        if (this.getDefaultCachePolicy() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CachePolicy policy = this.getDefaultCachePolicy();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(policy);
                ref.add(new BinaryRefAddr(DEFAULT_CACHE_POLICY, baos.toByteArray()));
            }
            catch (IOException e) {
                I18n msg = InfinispanConnectorI18n.errorSerializingCachePolicyInSource;
                throw new RepositorySourceException(this.getName(), msg.text(new Object[]{policy.getClass().getName(), this.getName()}), (Throwable)e);
            }
        }
        return ref;
    }
}

