/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.Cache;
import org.modeshape.connector.infinispan.InfinispanConnectorI18n;
import org.modeshape.connector.infinispan.InfinispanNode;
import org.modeshape.connector.infinispan.InfinispanRepository;
import org.modeshape.connector.infinispan.InfinispanWorkspace;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.MapTransaction;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.InvalidWorkspaceException;

@NotThreadSafe
public class InfinispanTransaction
extends MapTransaction<InfinispanNode, InfinispanWorkspace> {
    private final InfinispanRepository repository;
    private final Lock lock;

    protected InfinispanTransaction(ExecutionContext context, InfinispanRepository repository, UUID rootNodeUuid, Lock lock) {
        super(context, (Repository)repository, rootNodeUuid);
        this.repository = repository;
        this.lock = lock;
    }

    public Set<String> getWorkspaceNames() {
        return this.repository.getWorkspaceNames();
    }

    public InfinispanWorkspace getWorkspace(String name, InfinispanWorkspace originalToClone) {
        Cache workspaceCache = this.repository.getCacheContainer().getCache(name);
        if (workspaceCache == null) {
            String msg = InfinispanConnectorI18n.unableToCreateWorkspace.text(new Object[]{name, this.repository.getSourceName()});
            throw new InvalidWorkspaceException(msg);
        }
        if (originalToClone != null) {
            return new InfinispanWorkspace(name, (Cache<UUID, InfinispanNode>)workspaceCache, originalToClone);
        }
        return new InfinispanWorkspace(name, (Cache<UUID, InfinispanNode>)workspaceCache, new InfinispanNode(this.repository.getRootNodeUuid()));
    }

    public boolean destroyWorkspace(InfinispanWorkspace workspace) {
        workspace.destroy();
        return true;
    }

    protected InfinispanNode createNode(UUID uuid, Path.Segment name, UUID parentUuid, Iterable<Property> properties) {
        return new InfinispanNode(uuid, name, parentUuid, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        try {
            super.commit();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            super.rollback();
        }
        finally {
            this.lock.unlock();
        }
    }
}

