/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.infinispan;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.manager.CacheContainer;
import org.modeshape.common.annotation.Category;
import org.modeshape.common.annotation.Description;
import org.modeshape.common.annotation.Label;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.StringUtil;
import org.modeshape.connector.infinispan.BaseInfinispanSource;
import org.modeshape.connector.infinispan.InfinispanConnectorI18n;
import org.modeshape.graph.cache.CachePolicy;

@ThreadSafe
public class RemoteInfinispanSource
extends BaseInfinispanSource {
    private static final long serialVersionUID = 1L;
    protected static final String INFINISPAN_SERVER_LIST = "remoteInfinispanServerList";
    @Description(i18n=InfinispanConnectorI18n.class, value="remoteInfinispanServerListPropertyDescription")
    @Label(i18n=InfinispanConnectorI18n.class, value="remoteInfinispanServerListPropertyLabel")
    @Category(i18n=InfinispanConnectorI18n.class, value="remoteInfinispanServerListPropertyCategory")
    private volatile String remoteInfinispanServerList;

    public String getRemoteInfinispanServerList() {
        return this.remoteInfinispanServerList;
    }

    public synchronized void setRemoteInfinispanServerList(String remoteInfinispanServerList) {
        if (this.remoteInfinispanServerList == remoteInfinispanServerList || this.remoteInfinispanServerList != null && this.remoteInfinispanServerList.equals(remoteInfinispanServerList)) {
            return;
        }
        this.remoteInfinispanServerList = remoteInfinispanServerList;
    }

    @Override
    protected CacheContainer createCacheContainer() {
        if (this.getRemoteInfinispanServerList() == null || this.getRemoteInfinispanServerList().equals("")) {
            return new RemoteCacheManager();
        }
        return new RemoteCacheManager(this.getRemoteInfinispanServerList());
    }

    @Override
    public synchronized Reference getReference() {
        Reference ref = super.getReference();
        ref.add(new StringRefAddr(INFINISPAN_SERVER_LIST, this.getRemoteInfinispanServerList()));
        return ref;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Reference) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> en = ref.getAll();
            while (en.hasMoreElements()) {
                Object value;
                String key;
                RefAddr subref = en.nextElement();
                if (subref instanceof StringRefAddr) {
                    key = subref.getType();
                    value = subref.getContent();
                    if (value == null) continue;
                    values.put(key, value.toString());
                    continue;
                }
                if (!(subref instanceof BinaryRefAddr)) continue;
                key = subref.getType();
                value = subref.getContent();
                if (!(value instanceof byte[])) continue;
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])value);
                ObjectInputStream ois = new ObjectInputStream(bais);
                value = ois.readObject();
                values.put(key, value);
            }
            String sourceName = (String)values.get("sourceName");
            String rootNodeUuidString = (String)values.get("rootNodeUuid");
            String remoteServerList = (String)values.get(INFINISPAN_SERVER_LIST);
            Object defaultCachePolicy = values.get("defaultCachePolicy");
            String retryLimit = (String)values.get("retryLimit");
            String defaultWorkspace = (String)values.get("defaultWorkspace");
            String createWorkspaces = (String)values.get("allowCreatingWorkspaces");
            String updatesAllowed = (String)values.get("updatesAllowed");
            String combinedWorkspaceNames = (String)values.get("predefinedWorkspaceNames");
            String[] workspaceNames = null;
            if (combinedWorkspaceNames != null) {
                List paths = StringUtil.splitLines((String)combinedWorkspaceNames);
                workspaceNames = paths.toArray(new String[paths.size()]);
            }
            RemoteInfinispanSource source = new RemoteInfinispanSource();
            if (sourceName != null) {
                source.setName(sourceName);
            }
            if (rootNodeUuidString != null) {
                source.setRootNodeUuid(rootNodeUuidString);
            }
            if (remoteServerList != null) {
                source.setRemoteInfinispanServerList(remoteServerList);
            }
            if (defaultCachePolicy instanceof CachePolicy) {
                source.setDefaultCachePolicy((CachePolicy)defaultCachePolicy);
            }
            if (retryLimit != null) {
                source.setRetryLimit(Integer.parseInt(retryLimit));
            }
            if (defaultWorkspace != null) {
                source.setDefaultWorkspaceName(defaultWorkspace);
            }
            if (createWorkspaces != null) {
                source.setCreatingWorkspacesAllowed(Boolean.parseBoolean(createWorkspaces));
            }
            if (workspaceNames != null && workspaceNames.length != 0) {
                source.setPredefinedWorkspaceNames(workspaceNames);
            }
            if (updatesAllowed != null) {
                source.setUpdatesAllowed(Boolean.valueOf(updatesAllowed));
            }
            return source;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RemoteInfinispanSource) {
            RemoteInfinispanSource that = (RemoteInfinispanSource)obj;
            return !(this.getName() == null ? that.getName() != null : !this.getName().equals(that.getName()));
        }
        return false;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.getName()});
    }
}

